/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENDig2Event.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef CAENDIG2EVENT_H
#define CAENDIG2EVENT_H

#include <QVector>

#define EV_ID_MAX	(1 << 24)

class CAENDig2Event {
	QVector<std::uint16_t*> mWaveforms;
	QVector<std::uint32_t> mSizes;

public:
	CAENDig2Event(int num_ch = 0, std::size_t size = 0);
	~CAENDig2Event() {
		std::for_each(mWaveforms.begin(), mWaveforms.end(), [](std::uint16_t* p) { delete[] p; });
	}

	void Init_waveforms(int num_ch, std::size_t size) {
		mWaveforms.resize(num_ch);
		mSizes.resize(num_ch);
		std::generate(mWaveforms.begin(), mWaveforms.end(), [size] { return new std::uint16_t[size]; });
	}

	auto data() {
		return mWaveforms.data();
	}
	auto data() const {
		return mWaveforms.data();
	}
	auto sizes() {
		return mSizes.data();
	}
	auto sizes() const {
		return mSizes.data();
	}
	std::uint32_t Ev_size;
	std::uint32_t Ev_ID;
	std::uint64_t Ev_Timestamp;
	std::uint16_t Ev_flags;
	std::uint64_t Ev_chmask;
};

#endif
