/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENDig2Device.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef CAENDIG2DEVICE_H
#define CAENDIG2DEVICE_H
#include <QObject>
#include <QVector>
#include <QMutex>
#include <QElapsedTimer>
#include <QWaitCondition>
#include "CAENparameter.h"
#include "CAENDig2Event.h"
#include "CAENDevice.h"

#define ACQ_STATUS_ARMED_BIT 0
#define ACQ_STATUS_RUN_BIT   1
#define ACQ_STATUS_BUSY_BIT  4

#define FLAGS_POWERFAIL					0x1
#define FLAGS_INITFAULT					0x2
#define FLAGS_SI5341_unlock				0x4
#define FLAGS_SI5395_unlock				0x8
#define FLAGS_LMK04832_unlock			0x10
#define FLAGS_JESD_unlock				0x20
#define FLAGS_DDR_PL_BANK0_CALIB_FAIL	0x40
#define FLAGS_DDR_PL_BANK1_CALIB_FAIL	0x80
#define FLAGS_DDR_PS_CALIB_FAIL			0x100
#define FLAGS_FPGA_CONFIG_FAIL			0x200
#define FLAGS_BIC_ERROR					0x400
#define FLAGS_ADC_OVT					0x800
#define FLAGS_AIR_OVT					0x1000
#define FLAGS_FPGA_OVT					0x2000
#define FLAGS_DCDC_OVT					0x4000
#define FLAGS_CLKIN_MISS				0x8000
#define FLAGS_ADC_SHUTDOWN				0x10000


class CAENDig2Device : public CAENDevice
{

public:
	CAENDig2Device(QString name, QString CType, QString address, uint64_t handle, bool isvirtual);
	CAENDig2Device() {};
	~CAENDig2Device();
	uint32_t getErrorFlags();
	void ApplyDefaultConfig(QHash<QString, QString> dpars, QHash<QString, QString>* cpars, QHash<QString, QString>* gpars);
	void updateBaselines();
	double getChOffset(int ch) const;
	double getReclen_us();
	double getReclen_ns();
	void setChOffset(int ch, double val);
	void updateChSample_to_V(int ch);
	double getChGain(int ch);
	void setChGain(int ch, double val);
	int getChThreshold(int ch);
	void setChThreshold(int ch, int val);
	CAENparameter* getThrParam(int ch);
	void setStartSource(QString value);
	QString getStartSource();
	void setRunDelay(int value);
	void setTRGOUTMode(QString value);
	QString getTRGOUTMode();
	QString getClkSource();
	void setClkSource(QString value);
	QString getTrgSource();
	void setTrgSource(QString value);
	uint32_t calcTrgSourceToSave();
	void setSelfTrgMask(QString val);
	QString getSelfTrgMask();
	void setDecimation(int val);
	int getDecimation();
	void StartAcquisition();
	void StopAcquisition();
	QString getAcqStatus();
	void SetDataFormat(QString format);
	QString getFWRel();
	bool isChEnabled(int ch);
	QString DecodeFlagsMask(uint32_t mask);
	void DefineTrgSource(uint32_t t);
	void DefinePreTrigger(uint32_t p);
	double getPreTrg_value();
	double getPreTrg_min();
	double getPreTrg_max();
	double getPreTrg_incr();
	double getPreTrg_valueS();
	double getPreTrg_minS();
	double getPreTrg_maxS();
	double getPreTrg_incrS();
	void setPreTrg(QString value);
	void setScopeChannel(QString value);
	QString getScopeChannel();
	void setGPIOMode(QString value);
	QString getGPIOMode();
	QString getFWGbE();
	void setThrMode(QString mode);
	QString getTrgOutMask();
	void Reboot();
	void setSyncOutMode(QString value);
	QString getClkOutFP();
	void setClkOutFP(QString value);
	void setVETOSource(QString veto);
	QString getVETOSource();
	QString getFormFactor();
	void setIOLevel(QString val);
	QString getIOLevel();
	void setGlobalStartMode(QString mode, int delay);
	bool isInfoStartWord(uint64_t word);
	bool isInfoStopWord(uint64_t word);
	uint64_t getChEnableMask();

	////////the following are defined only for dig2 
	CAENparameter *getPreTrgParam() { return mPreTrg; }				
	void setITLALogicOR();
	void setTrgITLAMask(QString value);
	QString getTrgITLAMask();
	void setTrgITLBMask(QString value);
	QString getTrgITLBMask();			
	QString getTAirIn();
	QString getTAirOut();
	QString getTCore();
	QString getTFirstADC();
	QString getTLastADC();
	QString getTDCDC();

protected:
	void FillInfo();
	void CreateParams();

private:
	QString mModel;		
	CAENparameter *mPreTrg=nullptr;	

	
};

#endif
