/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENDig1Device.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef CAENDIG1DEVICE_H
#define CAENDIG1DEVICE_H
#include <QObject>
#include <QVector>
#include <QMutex>
#include <QElapsedTimer>
#include <QWaitCondition>
#include "CAENparameter.h"
#include "CAENDig2Event.h"
#include "CAENDevice.h"

#define XX724_FAMILY_CODE  0
#define XX721_FAMILY_CODE  1
#define XX731_FAMILY_CODE  2
#define XX720_FAMILY_CODE  3
#define XX740_FAMILY_CODE  4
#define XX751_FAMILY_CODE  5
#define XX742_FAMILY_CODE  6
#define XX780_FAMILY_CODE  7
#define XX761_FAMILY_CODE  8
#define XX743_FAMILY_CODE  9
#define XX730_FAMILY_CODE  11
#define XX790_FAMILY_CODE  12
#define XX781_FAMILY_CODE  13
#define XX725_FAMILY_CODE  14
#define XX782_FAMILY_CODE  16

#define FLAGS_CHSHUTDOWN				0x1
#define FLAGS_PLLUNLOCK					0x2
#define FLAGS_CHOVT						0x4

class CAENDig1Device : public CAENDevice
{

public:
	CAENDig1Device(QString name, QString CType, QString address, uint64_t handle, bool isvirtual);
	CAENDig1Device() {};
	~CAENDig1Device();
	uint32_t getErrorFlags();
	void ApplyDefaultConfig(QHash<QString, QString> dpars, QHash<QString, QString>* cpars, QHash<QString, QString>* gpars);
	void updateBaselines();
	double getChOffset(int ch) const;
	double getReclen_us();
	double getReclen_ns();
	void setChOffset(int ch, double val);
	void updateChSample_to_V(int ch);
	double getChGain(int ch);
	void setChGain(int ch, double val);
	int getChThreshold(int ch);
	void setChThreshold(int ch, int val);
	CAENparameter* getThrParam(int ch);
	void setStartSource(QString value);
	QString getStartSource();
	void setRunDelay(int value);
	void setTRGOUTMode(QString value);
	QString getTRGOUTMode();
	QString getClkSource();
	void setClkSource(QString value);
	QString getTrgSource();
	void setTrgSource(QString value);
	uint32_t calcTrgSourceToSave();
	void setSelfTrgMask(QString val);
	QString getSelfTrgMask();
	void setDecimation(int val);
	int getDecimation();
	void StartAcquisition();
	void StopAcquisition();
	QString getAcqStatus();
	void SetDataFormat(QString format);
	QString getFWRel();
	bool isChEnabled(int ch);
	void setChEnabled(int ch, bool enable);
	QString DecodeFlagsMask(uint32_t mask);
	void DefineTrgSource(uint32_t t);
	void DefinePreTrigger(uint32_t p);
	double getPreTrg_value();
	double getPreTrg_min();
	double getPreTrg_max();
	double getPreTrg_incr();
	double getPreTrg_valueS();
	double getPreTrg_minS();
	double getPreTrg_maxS();
	double getPreTrg_incrS();
	void setScopeChannel(QString value);
	QString getScopeChannel();
	void setGPIOMode(QString value);
	QString getGPIOMode();
	QString getFWGbE();
	void setThrMode(QString mode) { return; } //nothing to do for dig1
	void setPreTrg(QString value);//ns
	QString getTrgOutMask();
	void setTrgOutMask(QString mask);
	void Reboot();
	void setSyncOutMode(QString value);
	QString getClkOutFP();
	void setClkOutFP(QString value);
	void setVETOSource(QString veto);
	QString getVETOSource();
	QString getFormFactor();
	void setIOLevel(QString val);
	QString getIOLevel();
	void setGlobalStartMode(QString mode, int delay);
	bool isInfoStartWord(uint64_t word);
	bool isInfoStopWord(uint64_t word);
	uint64_t getChEnableMask();

	//the following defined only for dig1
	CAENparameter* getPostTrgParam() { return mPostTrg; }
	QString getExtClkSource();
	void setExtClkSource(QString value);
	void setExtTrgEnable(QString value);
	void setSwTrgEnable(QString value);
	QString getExtTrgEnable();
	QString getSwTrgEnable();
	int getChGroupSize() { return mGroupSize; }
	void setExtTrgPropagate(QString value);
	void setSwTrgPropagate(QString value);
	void disableExtTrgIn(QString value);
	double getChADCTemp(int ch);
	void CalibrateADC();

protected:
	void FillInfo();
	void CreateParams();


private:
	CAENparameter *mPostTrg;
	int mGroupSize = 1;
	bool mPairedChannels = false;
	double VppNumFromString(QString inrange);
	QString VppStringFromNum(double num);
};

#endif
