#ifndef _ZLEDEMOFUNC_H_
#define _ZLEDEMOFUNC_H_

#include <CAENDigitizer.h>
#include <CAENDigitizerType.h>
#include <time.h>
#include <sys/timeb.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ZLEDemoConst.h"

#ifdef WIN32
#include <time.h>
#include <sys/timeb.h>
#include <conio.h>
#include <process.h>
#include <windows.h>
#define popen  _popen    /* redefine POSIX 'deprecated' popen as _popen */
#define pclose _pclose  /* redefine POSIX 'deprecated' pclose as _pclose */
#define getch  _getch     /* redefine POSIX 'deprecated' */
#define kbhit  _kbhit     /* redefine POSIX 'deprecated' */
#else
#include <unistd.h>
#include <stdint.h>   /* C99 compliant compilers: uint64_t */
#include <ctype.h>    /* toupper() */
#include <sys/time.h>
#define Sleep(t) usleep((t)*1000);
#endif

static long get_time();
ERROR_CODES OpenConfigFile(FILE **f_ini, char *ConfigFileName);
ERROR_CODES ParseConfigFile(FILE *f_ini, ZLEConfig_t *ConfigVar);
ERROR_CODES OpenPlotter(ZLEConfig_t *ConfigVar, ZLEPlot_t *PlotVar);
ERROR_CODES OpenRawFile(FILE **outfile, int BoardIndex, int FileIndex, char *path, char *fname);
ERROR_CODES OpenWaveFile(FILE ***outfile, int BoardIndex, ZLEBoardConfig_t *BoardConfigVar, char *path, char *fname);
void WaveWrite(FILE **WaveFile, CAEN_DGTZ_730_ZLE_Event_t *Event, ZLEBoardConfig_t *BoardConfigVar);
void SetPlotOptions(ZLEPlot_t *PlotVar);
int OpenDigitizer(int *handle, ZLEConfig_t ConfigVar);
int ProgramDigitizers(int *handle, ZLEConfig_t  *ConfigVar);
int PlotEvent(ZLEConfig_t  *ConfigVar, ZLEPlot_t *PlotVar, CAEN_DGTZ_730_ZLE_Event_t **Event, int mode);
void PrintData(Counter_t *Counter, Counter_t *CounterOld);
void CheckKeyboardCommands(int *handle, ZLEConfig_t  *ConfigVar, ZLEPlot_t *PlotVar);
int ClosePlotter(FILE **gnuplot);
void ResetCounter(Counter_t *Counter);
int UpdateTime(int RefreshTime, uint64_t *PrevRateTime);
uint32_t CheckMallocSize(int handle);
int XX2530_ZLE_SetPreSamples(int handle, uint32_t samples, int channel);
int XX2530_ZLE_SetPostSamples(int handle, uint32_t samples, int channel);
int XX2530_ZLE_SetDataThreshold(int handle, uint16_t threshold, int channel);
int XX2530_ZLE_SetTriggerThreshold(int handle, uint16_t threshold, int channel);
int XX2530_ZLE_SetPreTrigger(int handle, uint32_t samples, int channel);
int XX2530_ZLE_SetBLineMode(int handle, uint32_t mode, int channel);
int XX2530_ZLE_SetBLineDefValue(int handle, uint32_t bl, int channel);
int XX2530_ZLE_SetBLineNoise(int handle, uint32_t noise, int channel);
int XX2530_ZLE_NoThresholdEnable(int handle, int channel);
int XX2530_ZLE_NoThresholdDisable(int handle, int channel);
int XX2530_ZLE_TestPulseEnable(int handle, int channel);
int XX2530_ZLE_TestPulseDisable(int handle, int channel);
int XX2530_ZLE_SetTestPulseRate(int handle, uint32_t rate, int channel);
int XX2530_ZLE_SetTestPulseScale(int handle, uint32_t scale, int channel);
int XX2530_ZLE_SetTestPulsePolarity(int handle, uint32_t polarity, int channel);
int XX2530_ZLE_SetPulsePolarity(int handle, uint32_t polarity, int channel);
int XX2530_ZLE_SetTriggerMask(int handle, uint32_t mask);
int XX2530_ZLE_SetTriggerOutMask(int handle, uint32_t mask);
#endif