# ------------------------------------------------------------------
# global variables and data structures
# ------------------------------------------------------------------

from tkinter import *
import os
import sys

SocketLog = False

# -------------------------------------------------------
# Sizes and positions (GUI layout)
# W=width, H=height, X=x-pos, Y=y-pos, Xm=x-margin, Ym=y-margin
# -------------------------------------------------------
# Main Window Width and Height
Win_W = 685   
Win_H = 760    

# Run Control Frame
Win_Ctrl_Y = 50
Win_Ctrl_H = 120
Win_Ctrl_X = 0
Win_Ctrl_W = Win_W

# Status Bar
Win_StatBar_Y = Win_H - 30
Win_StatBar_X = 0
Win_StatBar_H = 30

# Tabs Frame
Win_Tabs_Y = Win_Ctrl_Y + Win_Ctrl_H
Win_Tabs_H = Win_H - Win_Tabs_Y - Win_StatBar_H - 30
Win_Tabs_X = 0
Win_Tabs_W = Win_W-5

BgCol = 'grey95'  # default background color
OffCol = 'grey'   # default 'off' color
ErCol = 'red'     # default error color
WrCol = 'yellow'  # defualt warning color
AfCol = 'orange'  # default almost full buffer color
OkCol = 'green'   # defualt 'is fine' color
DataCol = 'light blue' # defalut color of statistics when data are read

# Versions
Version = "5203"
Release = "3.0.0 - 23/05/2025"
# Ranges
MaxCh = 64
MaxBrd = 16
NumCh = 64
NumBrd = 16
Channels = range(NumCh)
Boards = range(NumBrd)

# acquisition variables
ImgPath = "..\\img\\"
CfgFile = "Janus_Config.txt"
ActiveCh = 0
ActiveBrd = 0

ACQSTATUS_DISCONNECTED = 0	    # offline
ACQSTATUS_SOCK_CONNECTED = 1	# GUI connected through socket
ACQSTATUS_HW_CONNECTED = 2		# Hardware connected
ACQSTATUS_READY = 3				# ready to start (HW connected, memory allocated and initialized)
ACQSTATUS_RUNNING = 4			# acquisition running (data taking)
ACQSTATUS_RESTARTING = 5		# Restarting acquisition
ACQSTATUS_CALIBTHR = 9			# Calibrate A5256 Discriminator Thresholds
ACQSTATUS_STAIRCASE = 10		# Running Staircase
ACQSTATUS_RAMPING_HV = 11		# Switching HV ON or OFF
ACQSTATUS_UPGRADING_FW = 12		# Upgrading the FW
ACQSTATUS_HOLDSCAN = 13		    # Running Scan Hold
ACQSTATUS_ERROR = -1			# Error

# Start Run
STARTRUN_MODE = {
	0: "ASYNC",
	1: "T0_CHIAN",
	2: "T1_CHAIN",
	3: "TDL"
}

# Macros
LLDumpMsg = os.path.join("..", "macros", "LL_dump_msg.txt")

# GUI hiding and options
CfgFile = "Janus_Config.txt"
GuiModeFile = "GUI_hide_parameters.txt"
GUIParamOptions = "GUI_param_options.json"
RunVars = "RunVars.txt"
PixelMap = "pixel_map.txt"
JanusCexe = "JanusC.exe"
ParRename = "param_rename.txt"
params = {}  # dictionary of all parameters
sections = []  # list of section

cfgfile_path = os.path.join('..', 'bin')
# Check if is executable
def is_exe():
    return getattr(sys, 'frozen', False)

# Time conversion function
def get_timeunit(val):
	unit = 'ps'
	if val > 1e12:
		val /= 1e12
		unit = "s"
	elif val > 1e9:
		val /= 1e9
		unit = "ms"
	elif val > 1e6:
		val /= 1e6
		unit = "us"
	elif val > 1e3:
		val /= 1e3
		unit = 'ns'
	else: unit = 'ps'
	return unit, val

def get_time_from_unit(val):
	unit = val.split(' ')[1]
	mval = float(val.split(' ')[0])
	if 'ps' in unit:
		pass
	elif 'ns' in unit:
		mval *= 1e3
	elif 'us' in unit:
		mval *= 1e6
	elif 'ms' in unit:
		mval *= 1e9
	elif unit == 's':
		mval *= 1e12
	else:
		mval *= 1e3
	return mval
	
