/******************************************************************************
* 
* CAEN SpA - Front End Division
* Via Vetraia, 11 - 55049 - Viareggio ITALY
* +390594388398 - www.caen.it
*
***************************************************************************//**
* \note TERMS OF USE:
* This program is free software; you can redistribute it and/or modify it under
* the terms of the GNU General Public License as published by the Free Software
* Foundation. This program is distributed in the hope that it will be useful, 
* but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. The user relies on the 
* software, documentation and results solely at his own risk.
******************************************************************************/


#include <CAENDigitizer.h>
#include "WaveCut.h"


int load_default=1;
int ch=-1, brd=-1;


int GetInt(FILE *f_ini)
{
	int ret;
	fscanf(f_ini, "%d", &ret);
	return ret;
}
int GetHex(FILE *f_ini)
{
	int ret;
	fscanf(f_ini, "%x", &ret);
	return ret;
}
float GetFloat(FILE *f_ini)
{
	float ret;
	fscanf(f_ini, "%f", &ret);
	return ret;
}

//void SetChannelParam(int *param[MAX_NBRD], int val)
void SetChannelParam(int param[MAX_NBRD][MAX_NCH], int val)
{
	int i, b;
    if (ch == -1)
        for(b=0; b<MAX_NBRD; b++)
			for(i=0; i<MAX_NCH; i++)
				param[b][i] = val;
    else
        param[brd][ch] = val;
}


int ParseConfigFile(FILE *f_ini, DPP_Config_t *WDcfg) 
{
	char str[1000], str1[1000];
	int i, b, val, Off=0, tr = -1;

	if (load_default) {
		/* Default settings */
		WDcfg->NumBrd = 0;
		WDcfg->NumCh = 8;
		WDcfg->OutFileFormat = OUTFILE_ASCII;
		WDcfg->TriggerMode = TRIGGER_MODE_SELF;
		WDcfg->VetoMode = VETO_DISABLED;
		WDcfg->TestWave = TESTWAVE_DISABLED;
		WDcfg->StartMode = START_MODE_INDEP_SW;
		WDcfg->StopOnEvents = 0;
		WDcfg->StopOnTime = 0;
		WDcfg->FPIOtype = CAEN_DGTZ_IOLevel_NIM;
		WDcfg->InputDelay = 64;
		WDcfg->RecordLength = 1024;
		WDcfg->PreTrigger = 64;
		WDcfg->GWn = 0;
        for(b=0; b<MAX_NBRD; b++)
			for(i=0; i<MAX_NCH; i++)
				WDcfg->EnableInput[b][i]=1;  
				WDcfg->TrgThreshold[b][i]=10;  
				WDcfg->PulsePolarity[b][i]=1;  
				WDcfg->NsBaseline[b][i]=2;  
				WDcfg->DCoffset[b][i]=8000;  
				WDcfg->N_LFW[b][i]=2;  
	}

	/* read config file and assign parameters */
	while(!feof(f_ini)) {
		int read;
        // read a word from the file
        read = fscanf(f_ini, "%s", str);
        if( !read || (read == EOF) || !strlen(str))
			continue;

        // skip comments
        if (str[0] == '#') {
			fgets(str, 1000, f_ini);
			continue;
		}

		if (strcmp(str, "@ON")==0) {
			Off = 0;
			continue;
		} else if (strcmp(str, "@OFF")==0) {
			Off = 1;
			continue;
		}
        if (Off)
            continue;

        // Section (COMMON or individual channel)
		if (str[0] == '[')								{	if (strstr(str, "COMMON")!=NULL) {
																ch = -1;
																brd = -1;
															} else if (strstr(str, "BOARD")!=NULL) {
																ch = -1;
																fscanf(f_ini, "%s", str1);
																sscanf(str1, "%d", &val);
																if (val < 0 || val >= MAX_NBRD) printf("%s: Invalid board number\n", str);
																else brd = val;
															} else if (strstr(str, "CHANNEL")!=NULL) {
																fscanf(f_ini, "%s", str1);
																sscanf(str1, "%d", &val);
																if (val < 0 || val >= MAX_NCH) printf("%s: Invalid channel number\n", str);
																else ch = val;
															}

        // LOAD: open another config file
		} else if (strcmp(str, "Load")==0)				{	FILE *cf;
															fscanf(f_ini, "%s", str1);
															cf = fopen(str1, "r");
															if (cf!=NULL) {
																load_default=0;
																ParseConfigFile(cf, WDcfg);
																fclose(cf);
																load_default=1;
															}
 
		} else if (strcmp(str, "Open")==0)				{	if (brd==-1) {
																printf("%s: cannot be a common setting (must be in a [BOARD] section)\n", str); 
																fgets(str1, 100, f_ini);
															} else {
																fscanf(f_ini, "%s", str1);
																if (strcmp(str1, "USB") == 0) {
																	WDcfg->LinkType[brd] = CAEN_DGTZ_USB;
																	WDcfg->LinkNum[brd] = GetInt(f_ini);
																	WDcfg->ConetNode[brd] = 0;
																}
																else if (strcmp(str1, "PCI") == 0) {
																	WDcfg->LinkType[brd] = CAEN_DGTZ_OpticalLink;
																	WDcfg->LinkNum[brd] = GetInt(f_ini);
																	WDcfg->ConetNode[brd] = GetInt(f_ini);
																}
																else if (strcmp(str1, "USB_A4818") == 0) {
																	WDcfg->LinkType[brd] = CAEN_DGTZ_USB_A4818;
																	WDcfg->LinkNum[brd] = GetInt(f_ini); // PID
																	WDcfg->ConetNode[brd] = GetInt(f_ini);
																}
																else if (strcmp(str1, "USB_V4718") == 0) {
																	WDcfg->LinkType[brd] = CAEN_DGTZ_USB_V4718;
																	WDcfg->LinkNum[brd] = GetInt(f_ini); // PID
																	WDcfg->ConetNode[brd] = 0;
																}
																else if (strcmp(str1, "ETH_V4718") == 0) {
																	WDcfg->LinkType[brd] = CAEN_DGTZ_ETH_V4718;
																	fscanf(f_ini, "%63s", WDcfg->HostName[brd]);
																	WDcfg->ConetNode[brd] = 0;
																}
																else {
																	printf("%s: invalid setting for %s\n", str1, str);
																	return -1;
																}
																WDcfg->BaseAddress[brd] = GetHex(f_ini);
																WDcfg->NumBrd++;
															}

		} else if (strcmp(str, "WriteRegister")==0)		{	for(i=0; i<MAX_NBRD-1; i++) {
																if ((brd == -1) || (i == brd)) {
																	if (WDcfg->GWn < MAX_GW) {
																		fscanf(f_ini, "%x", (int *)&WDcfg->GWaddr[i][WDcfg->GWn]);
																		fscanf(f_ini, "%x", (int *)&WDcfg->GWdata[i][WDcfg->GWn]);
																		fscanf(f_ini, "%x", (int *)&WDcfg->GWmask[i][WDcfg->GWn]);
																		WDcfg->GWn++;
																	} else {
																		printf("MAX_GW Generic Write exceeded (%d). Change MAX_GW and recompile\n", MAX_GW);
																	}
																}
															}

		} else if (strcmp(str, "RecordLength")==0)		{	WDcfg->RecordLength		= GetInt(f_ini);
		} else if (strcmp(str, "PreTrigger")==0) 		{	WDcfg->PreTrigger		= GetInt(f_ini); 
		} else if (strcmp(str, "InputDelay")==0) 		{	WDcfg->InputDelay		= GetInt(f_ini); 
		} else if (strcmp(str, "StopOnTime")==0) 		{	WDcfg->StopOnTime		= GetInt(f_ini);
		} else if (strcmp(str, "StopOnEvents")==0) 		{	WDcfg->StopOnEvents		= GetInt(f_ini);
		} else if (strcmp(str, "EnableInput")==0)		{	SetChannelParam(WDcfg->EnableInput,			GetInt(f_ini));
		} else if (strcmp(str, "DCoffset")==0)			{	SetChannelParam(WDcfg->DCoffset,			(int)((GetFloat(f_ini)+50) * 65535 / 100));
		} else if (strcmp(str, "TriggerThreshold")==0)	{	SetChannelParam(WDcfg->TrgThreshold,		GetInt(f_ini));
		} else if (strcmp(str, "NSBaseline")==0) 		{	SetChannelParam(WDcfg->NsBaseline,			GetInt(f_ini));
		} else if (strcmp(str, "N_LFW")==0) 		    {	SetChannelParam(WDcfg->N_LFW,			GetInt(f_ini));
		} else if (strcmp(str, "PulsePolarity")==0)		{	fscanf(f_ini, "%s", str1);
															if		(strcmp(str1, "NEGATIVE")==0)		SetChannelParam(WDcfg->PulsePolarity, CAEN_DGTZ_PulsePolarityNegative);
															else if (strcmp(str1, "POSITIVE")==0)		SetChannelParam(WDcfg->PulsePolarity, CAEN_DGTZ_PulsePolarityPositive);
															else 	printf("%s: invalid setting for %s\n", str1, str);
		} else if (strcmp(str, "StartMode")==0)			{	fscanf(f_ini, "%s", str1);
															if		(strcmp(str1, "INDEP_SW")==0)		WDcfg->StartMode = START_MODE_INDEP_SW;
															else if (strcmp(str1, "SYNC_S_IN")==0)		WDcfg->StartMode = START_MODE_SYNC_S_IN;
															else 	printf("%s: invalid setting for %s\n", str1, str);
		} else if (strcmp(str, "TriggerMode")==0)		{	fscanf(f_ini, "%s", str1);
															if		(strcmp(str1, "SELF_TRIGGER")==0)	WDcfg->TriggerMode = TRIGGER_MODE_SELF;
															else if (strcmp(str1, "EXT_TRIGGER")==0) 	WDcfg->TriggerMode = TRIGGER_MODE_EXTERNAL;
															else 	printf("%s: invalid setting for %s\n", str1, str);
		} else if (strcmp(str, "VetoMode")==0)  		{	fscanf(f_ini, "%s", str1);
															if		(strcmp(str1, "VETO_DISABLED")==0)	  WDcfg->VetoMode = VETO_DISABLED;
															else if (strcmp(str1, "VETO_ACTIVE_HIGH")==0) WDcfg->VetoMode = VETO_ACTIVE_HIGH;
															else if (strcmp(str1, "VETO_ACTIVE_LOW")==0)  WDcfg->VetoMode = VETO_ACTIVE_LOW;
															else 	printf("%s: invalid setting for %s\n", str1, str);
		} else if (strcmp(str, "TestWave")==0)			{	fscanf(f_ini, "%s", str1);
															if		(strcmp(str1, "TESTWAVE_DISABLED")==0)		WDcfg->TestWave = TESTWAVE_DISABLED;
															else if (strcmp(str1, "TESTWAVE_ENABLED")==0)		WDcfg->TestWave = TESTWAVE_ENABLED;
															else 	printf("%s: invalid setting for %s\n", str1, str);
		} else if (strcmp(str, "OutFileFormat")==0)		{	fscanf(f_ini, "%s", str1);
															if		(strcmp(str1, "BINARY")==0)			WDcfg->OutFileFormat = OUTFILE_BINARY;
															else if (strcmp(str1, "ASCII")==0)			WDcfg->OutFileFormat = OUTFILE_ASCII;
															else	printf("%s: invalid setting for %s\n", str1, str);
		} else if (strcmp(str, "FPIOtype")==0)			{	fscanf(f_ini, "%s", str1);
															if      (strcmp(str1, "TTL")==0)			WDcfg->FPIOtype = CAEN_DGTZ_IOLevel_TTL;
															else if (strcmp(str1, "NIM")==0)			WDcfg->FPIOtype = CAEN_DGTZ_IOLevel_NIM;
															else 	printf("%s: invalid setting for %s\n", str1, str);
		} else											{	printf("%s: unkwown parameter\n", str);
															fgets(str, (int) strlen(str)-1, f_ini);
		}

	}
	return 0;
}


