/******************************************************************************
*
* CAEN SpA - Front End Division
* Via Vetraia, 11 - 55049 - Viareggio ITALY
* +390594388398 - www.caen.it
*
***************************************************************************//**
* \note TERMS OF USE:
* This program is free software; you can redistribute it and/or modify it under
* the terms of the GNU General Public License as published by the Free Software
* Foundation. This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. The user relies on the
* software, documentation and results solely at his own risk.
******************************************************************************/

#include "keyb.h"
#include "WaveCut.h"

#include <stdio.h>
#ifdef WIN32

    #include <time.h>
    #include <sys/timeb.h>
    #include <conio.h>
    #include <process.h>
	#define getch _getch     /* redefine POSIX 'deprecated' */
	#define kbhit _kbhit     /* redefine POSIX 'deprecated' */

#else
    #include <unistd.h>
    #include <stdint.h>   /* C99 compliant compilers: uint64_t */
    #include <ctype.h>    /* toupper() */
    #include <sys/time.h>
#endif

extern char path[255];

// --------------------------------------------------------------------------------------------------------- 
// Description: get time from the computer
// Return: time in ms
// --------------------------------------------------------------------------------------------------------- 
long get_time()
{
    long time_ms;
#ifdef WIN32
    struct _timeb timebuffer;
    _ftime( &timebuffer );
    time_ms = (long)timebuffer.time * 1000 + (long)timebuffer.millitm;
#else
    struct timeval t1;
    struct timezone tz;
    gettimeofday(&t1, &tz);
    time_ms = (t1.tv_sec) * 1000 + t1.tv_usec / 1000;
#endif
    return time_ms;
}

// --------------------------------------------------------------------------------------------------------- 
// Description: Set bits of a registers 
// Inputs:	reg = original value of the register
//			start_bit = first bit of the parameter being written 
//			end_bit = last bit of the parameter being written 
//			val: value to write
// Return: updated value of the register
// --------------------------------------------------------------------------------------------------------- 
uint32_t RegisterSetBits(uint32_t reg, int start_bit, int end_bit, int val)
{
	uint32_t mask=0, rreg;
	int i;
	for(i=start_bit; i<=end_bit; i++)
		mask |= 1<<i;
	rreg = reg & ~mask | ((val<<start_bit) & mask);
	return rreg;
}


// --------------------------------------------------------------------------------------------------------- 
// Description: Save the waveform1 of one event to output file
// Inputs:	wave = output files
//			b = board index
//			ch = channel
//			Waveform = waveform to save
//			Ns = number of samples in the waveform
//			format = OUTFILE_ASCII or OUTFILE_BINARY
// Return: 0=OK, -1=error
// --------------------------------------------------------------------------------------------------------- 
int SaveWaveform(FILE *wave[MAX_NBRD][MAX_NCH], int b, int ch, uint16_t *Waveform, int Ns, uint64_t TimeStamp, int format)
{
	int i;

	if (wave[b][ch]==NULL) {
		char fname[100];					
		if (format == OUTFILE_ASCII) {
			sprintf(fname, "%s\\Wave_%d_%d.txt", path, b, ch);
			wave[b][ch] = fopen(fname, "w");
			if (wave[b][ch]==NULL) return -1;
		} else {	
			sprintf(fname, "%s\\Wave_%d_%d.dat",path, b, ch);
			wave[b][ch] = fopen(fname, "wb");
			if (wave[b][ch]==NULL) return -1;
			
		}
	}
	if (format == OUTFILE_ASCII) {
		fprintf(wave[b][ch], "TS = %llu, Ns=%d\n", TimeStamp, Ns);
		for(i=0; i<Ns; i++)
			fprintf(wave[b][ch], "%d\n", Waveform[i]); 
	} else {
		fwrite(&TimeStamp, sizeof(uint64_t), 1, wave[b][ch]);
		fwrite(&Ns, 1, sizeof(uint16_t), wave[b][ch]);
		fwrite(Waveform, sizeof(uint16_t), Ns, wave[b][ch]);
	}
    return 0;
}

// --------------------------------------------------------------------------------------------------------- 
// Description: Save all the regsiters of the borad to a file
// Inputs:	handle = handle of the board
// Return: 0=OK, -1=error
// --------------------------------------------------------------------------------------------------------- 
int SaveRegImage(int handle) 
{
	FILE *regs;
	char fname[100];
	int ret;
	uint32_t addr, reg, ch;

	sprintf(fname, "%s\\reg_image_%d.txt", path, handle);
	regs=fopen(fname, "w");
	if (regs==NULL)
		return -1;

	fprintf(regs, "[COMMON REGS]\n");
	for(addr=0x8100; addr <= 0x8200; addr += 4) {
		ret = CAEN_DGTZ_ReadRegister(handle, addr, &reg);
		if (ret==0)
			fprintf(regs, "%04X : %08X\n", addr, reg);
	}
	for(addr=0xEF00; addr <= 0xEF34; addr += 4) {
		ret = CAEN_DGTZ_ReadRegister(handle, addr, &reg);
		if (ret==0)
			fprintf(regs, "%04X : %08X\n", addr, reg);
	}
	for(addr=0xF000; addr <= 0xF088; addr += 4) {
		ret = CAEN_DGTZ_ReadRegister(handle, addr, &reg);
		if (ret==0)
			fprintf(regs, "%04X : %08X\n", addr, reg);
	}

	for(ch=0; ch<8; ch++) {
		fprintf(regs, "[CHANNEL %d]\n", ch);
		for(addr=0x1000+(ch<<8); addr <= (0x10FF+(ch<<8)); addr += 4) {
			ret = CAEN_DGTZ_ReadRegister(handle, addr, &reg);
			if (ret==0)
				fprintf(regs, "%04X : %08X\n", addr, reg);
		}
	}

	fclose(regs);
	return 0;
}



/* ************************************************************************************** */
/* Functions to be included in the CAENDigitizer library */
/* ************************************************************************************** */
CAEN_DGTZ_ErrorCode _CAEN_DGTZ_SetDPPPreTriggerSize(int handle, int ch, uint32_t samples)
{
  return CAEN_DGTZ_WriteRegister(handle, 0x1038 + (ch<<8), samples); 
}

CAEN_DGTZ_ErrorCode _CAEN_DGTZ_MallocWaveCutEvents(int handle, WaveCutEvent_t **Events, uint32_t *AllocatedSize)
{
    CAEN_DGTZ_ErrorCode ret = 0;
	int i,NevBlt,chmask,nc;

    *AllocatedSize = 0;
	nc=0;
    for (i=0; i<MAX_NCH; i++)
        Events[i] = NULL;

    ret |= CAEN_DGTZ_GetMaxNumEventsBLT(handle, &NevBlt);
    ret |= CAEN_DGTZ_GetChannelEnableMask(handle, &chmask);

	for(i=0; i<MAX_NCH; i++) {
      if (!(chmask & (1<<i)))
            continue;
        nc++;
        if ((Events[i] = (WaveCutEvent_t *)malloc(NevBlt* sizeof(WaveCutEvent_t))) == NULL)
            break;
    }
	if (i < MAX_NCH) {
        _CAEN_DGTZ_FreeWaveCutEvents(handle, Events);
        return CAEN_DGTZ_OutOfMemory;
    }

    *AllocatedSize = nc * NevBlt * sizeof(WaveCutEvent_t);
	return CAEN_DGTZ_Success;
}

CAEN_DGTZ_ErrorCode _CAEN_DGTZ_FreeWaveCutEvents(int handle, WaveCutEvent_t **Events) 
{
    int i;
	for (i=0; i<MAX_NCH; i++)
        if (Events[i] != NULL)
            free(Events[i]);
    return CAEN_DGTZ_Success;
}

//CAEN_DGTZ_ErrorCode _CAEN_DGTZ_MallocWaveCutWaveform(int handle, uint16_t *waveform, uint32_t *allocatedSize) 
//{
//     *allocatedSize = 0;
//	 if ((w = (WaveCut_Waveform_t *)malloc(sizeof(WaveCut_Waveform_t))) == NULL) {
//        return CAEN_DGTZ_OutOfMemory;
//	 }
//	 if ((w->Trace = (int16_t *)malloc(4*1024*1024*sizeof(uint16_t))) == NULL) {
//        free(w);
//        return CAEN_DGTZ_OutOfMemory;
//     }
//    *allocatedSize = sizeof(WaveCut_Waveform_t) + 4*1024*1024*sizeof(uint16_t); //4Msamples/ch for big memory 
//    return CAEN_DGTZ_Success;
//}

//CAEN_DGTZ_ErrorCode _CAEN_DGTZ_FreeWaveCutWaveform(WaveCut_Waveform_t *waveform) {
//    if (waveform != NULL) {
//        free(waveform->Trace);
//        free(waveform);
//    }
//    return CAEN_DGTZ_Success;
//}

static CAEN_DGTZ_ErrorCode CAENDGTZ_API _CAEN_DGTZ_WaveCutDecodeEvent(int handle, int ch, uint32_t *data, WaveCutEvent_t *events) {
    uint32_t size, evsize;
	if ((data[0] & 0xFFC00000))
        return CAEN_DGTZ_InvalidEvent;
    size = data[0] & 0x003FFFFF;
    evsize = (size-2)*2;
	events[0].Ns= evsize;
    events[0].TimeStamp= data[1];
    events[0].Wave = data + 2;   
    return CAEN_DGTZ_Success;
}

CAEN_DGTZ_ErrorCode _CAEN_DGTZ_GetDPPEvents(int handle, char *buffer, int BufferSize, WaveCutEvent_t **Events, uint32_t *NumEvents)
{
	int ch;
	uint32_t *buffer32;
    uint32_t pnt=0, endev;
    char chmask;
	int* index = (int *)calloc(MAX_NCH, sizeof(int)); 
    
	buffer32 = (uint32_t *)buffer; 

	for(ch=0; ch<MAX_NCH; ch++)
		index[ch]=0;

	while(pnt < (uint32_t)(BufferSize/4) - 1) { 
        endev = pnt + (buffer32[pnt] & 0x0FFFFFFF);
        chmask = (char)(buffer32[pnt+1] & 0xFF);
        pnt += 4;
        if (chmask == 0)
            continue;
        for(ch=0; ch<MAX_NCH; ch++) {
            if (!(chmask & (1<<ch)))
                continue;
			if (_CAEN_DGTZ_WaveCutDecodeEvent(handle, ch, buffer32+pnt, Events[ch]+index[ch])) {
				free(index);
                return CAEN_DGTZ_InvalidEvent;
			}
			index[ch] ++;
            pnt += buffer32[pnt] & 0x00FFFFFF;
        }    
        if (pnt != endev) {
			free(index);
            return CAEN_DGTZ_InvalidEvent;
		}
    }
    for(ch=0; ch<MAX_NCH; ch++)
        NumEvents[ch] = index[ch];

	free(index);
	return CAEN_DGTZ_Success;
} 

int ConvertWaveCutEventData(int handle, int DecodeWave, WaveCutEvent_t Event, uint16_t *Waveform)
{
	int i;
	
	if (DecodeWave) {
		for(i=0; i<(int)(Event.Ns/2); i++){
			Waveform[2*i]= (uint16_t)(Event.Wave[i] & 0x3FFF);
			Waveform[2*i+1]= (uint16_t)((Event.Wave[i]>>16) & 0x3FFF);
	    }
	}
		
	return 0;
}
