#ifndef _PEAKSENSINGDAQFUNC_H
#define _PEAKSENSINGDAQFUNC_H

#include <time.h>
#include <sys/timeb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "PeakSensingDAQConst.h"
#include "CAENPeakSensing.h"

#ifdef _WIN32
#define _WINSOCKAPI_    // stops windows.h including winsock.h
#include <WinSock2.h>
#include <process.h>
#include <conio.h>
#define popen  _popen    /* redefine POSIX 'deprecated' popen as _popen */
#define pclose _pclose  /* redefine POSIX 'deprecated' pclose as _pclose */
#define getch  _getch     /* redefine POSIX 'deprecated' */
#define kbhit  _kbhit     /* redefine POSIX 'deprecated' */
#else
#include <unistd.h>
#include <stdint.h>   /* C99 compliant compilers: uint64_t */
#include <ctype.h>    /* toupper() */
#include "sys/time.h"
#define Sleep(t) usleep((t)*1000);
#endif

static long get_time();
int OpenPeakSensing(int *handle, PeakSensingConfig_t ConfigVar);
int PlotEvent(PeakSensingConfig_t *ConfigVar, PeakSensingPlot_t *PlotVar, Counter_t *Counter);
//int PlotEvent_nofile(PeakSensingConfig_t *ConfigVar, PeakSensingPlot_t *PlotVar, Counter_t *Counter);
void SetPlotOptions(PeakSensingPlot_t *PlotVar);
void CheckKeyboardCommands(int *handle, PeakSensingConfig_t  *ConfigVar, Counter_t *Counter,Counter_t *CounterOld);
int ProgramPeakSensing(int handle, PeakSensingBoardConfig_t *BoardConfigVar);
ERROR_CODES OpenPlotter(PeakSensingConfig_t *ConfigVar, PeakSensingPlot_t *PlotVar);
void PrintData(int handle,Counter_t *Counter, Counter_t *CounterOld,PeakSensingConfig_t ConfigVar);
int ClosePlotter(PeakSensingPlot_t *PlotVar);
int UpdateTime(int RefreshTime, uint64_t *PrevTime);
int MallocCounter(Counter_t *Counter);
int ResetCounter(Counter_t *Counter);
int AddEvents(CAEN_PADC_Event_t *Event, uint32_t NumEvents, Counter_t *Counter, int MaxChannels);
ERROR_CODES OpenConfigFile(FILE **f_ini, char *ConfigFileName);
ERROR_CODES ParseConfigFile(FILE *f_ini, PeakSensingConfig_t *ConfigVar);
ERROR_CODES OpenRawFile(FILE **outfile, int BoardIndex, int FileIndex, char *path, char *fname);
ERROR_CODES OpenListFile(FILE **outfile, int BoardIndex, int ChMax, int FileIndex, char *path, char *fname);
ERROR_CODES OpenHistoFile(FILE ***outfile, int BoardIndex, PeakSensingBoardConfig_t *BoardConfigVar, char *path, char *fname);
void ListWrite(FILE *ListFile, int NumEvents, PeakSensingBoardConfig_t *BoardConfigVar, CAEN_PADC_Event_t *Event);
void HistoWrite(FILE **HistoFile, Counter_t *Counter, PeakSensingBoardConfig_t *BoardConfigVar);
#endif
