// firmware_upgrade.cpp : Defines the entry point for the console application.
//
#include "CAENComm.h"
#include "A2795Upgrade.h"
#include <string.h>
#include <iostream>

void Usage(void)
{
    printf("Syntax: A2795Upgrade <conet link> <conet node> [standard|backup] [FlashFile]  \n");
}

int main(int argc, char* argv[])
{
    FILE *stream = NULL;
	CAENComm_ErrorCode ret;
	int CAENComm_handle;
	int conet_link = 0;
	int conet_node = 0;
	int firmware_page = 2;

	if( argc < 5 ) {
		Usage();
		exit(-1);
	}

	conet_link = atoi(argv[1]);
	conet_node= atoi(argv[2]);
	//firmware_page= atoi(argv[3]);
    if( strcmp((char*)argv[3], "standard" ) == 0 ) {
		firmware_page = 2;
    } else {
             if( strcmp((char*)argv[3], "backup") == 0 ) {
				firmware_page = 1;
			} else {
					Usage();
					exit(1);
					}
	}
    if((stream = fopen((const char*)argv[4], "rb" )) == NULL ) {
		printf( "File %s not found\n",argv[4]);
        exit(1);
    }
    fclose(stream);
	
	ret = CAENComm_OpenDevice(CAENComm_OpticalLink, conet_link, conet_node, 0, &CAENComm_handle);
	if (ret != CAENComm_Success) {
		printf( "Open Device Failed\n");
		return -1;
	}

	A2795_flash* main_flash = new A2795_flash(CAENComm_handle, A2795_flash::USER_CONTROLLER_OFFSET); // User flash controler

   // *************************************
   // Application programming 
   // *************************************
	if (firmware_page == 1){
		printf("Upgrading A2795 application BKP firmware image.....\n");
		main_flash->program_firmware(A2795_flash::APPLICATION1_FW_REGION, (char*)argv[4]);
	}
	else if (firmware_page == 2){
		printf("Upgrading A2795 application STD firmware image.....\n");
		main_flash->program_firmware(A2795_flash::APPLICATION2_FW_REGION, (char*)argv[4]);
	}

	CAENComm_CloseDevice(CAENComm_handle);
	return 0;

}

