/*
 * Decompiled with CFR 0.152.
 */
package usbhid4javaserviceprovider;

import com.microchip.scf.CommunicationsInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventType;
import org.hid4java.HidDevice;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.event.HidServicesEvent;

public class Hid4JavaUSBAdapter
implements CommunicationsInterface {
    InputStream inputPipe;
    OutputStream outputPipe;
    int toolIndex = -1;
    String deviceName;
    HidDevice hidDevice = null;
    boolean isDeviceConnected = false;
    int timeOutMS;
    protected static String[] protNames = null;
    protected static ObservableList<Event> deviceListObserver = FXCollections.observableArrayList();
    HidServicesListener listenAttach = new HidServicesListener(){
        int eventID = 0;

        @Override
        public void hidDeviceAttached(HidServicesEvent hse) {
            deviceListObserver.add((Object)new Event((Object)String.format("%02X", hse.getHidDevice().getProductId()), null, new EventType(this.eventID++ + " Attach")));
        }

        @Override
        public void hidDeviceDetached(HidServicesEvent hse) {
            deviceListObserver.add((Object)new Event((Object)String.format("%02X", hse.getHidDevice().getProductId()), null, new EventType(this.eventID++ + " Detach")));
        }

        @Override
        public void hidFailure(HidServicesEvent hse) {
            Event event = new Event((Object)String.format("%02X", hse.getHidDevice().getProductId()), null, new EventType(this.eventID + " Failure"));
            deviceListObserver.add((Object)event);
            System.err.println(hse.toString());
        }
    };

    @Override
    public String[] getAttachedDevices() throws IOException {
        HidManager.getHidServices().addHidServicesListener(this.listenAttach);
        ArrayList<String> deviceList = new ArrayList<String>();
        HidServices hidServices = HidManager.getHidServices();
        for (HidDevice device : hidServices.getAttachedHidDevices()) {
            deviceList.add(String.format("%02X", device.getProductId()));
        }
        String[] deviceListArray = new String[deviceList.size()];
        for (int i = 0; i < deviceListArray.length; ++i) {
            deviceListArray[i] = (String)deviceList.get(i);
        }
        protNames = deviceListArray;
        return deviceListArray;
    }

    private void getDeviceIndexFromToolMap() {
        for (HidDevice dev : HidManager.getHidServices().getAttachedHidDevices()) {
            if (!String.format("%02X", dev.getProductId()).contains(this.deviceName)) continue;
            this.hidDevice = dev;
        }
    }

    @Override
    public boolean connect() throws IOException {
        this.getDeviceIndexFromToolMap();
        if (this.hidDevice == null) {
            throw new RuntimeException("__rawConnect : Port not enumerated");
        }
        boolean success = this.hidDevice.open();
        if (success) {
            this.isDeviceConnected = true;
            this.inputPipe = new USBInputStream();
            this.outputPipe = new USBOutputStream();
        } else {
            this.isDeviceConnected = false;
        }
        return success;
    }

    @Override
    public boolean disconnect() throws IOException {
        this.inputPipe.close();
        this.outputPipe.close();
        boolean tRes = true;
        if (this.hidDevice != null) {
            this.hidDevice.close();
        }
        this.isDeviceConnected = false;
        return tRes;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputPipe != null) {
            return this.inputPipe;
        }
        throw new IOException("Device not opened. Please initialize the device.");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputPipe != null) {
            return this.outputPipe;
        }
        throw new IOException("Device not opened. Please initialize the device.");
    }

    public int getPid() {
        return this.hidDevice.getProductId();
    }

    public int getVid() {
        return this.hidDevice.getVendorId();
    }

    @Override
    public void setDeviceName(String name) {
        this.deviceName = name;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public void setTimeOut(int timeOutinSeconds) {
        this.timeOutMS = timeOutinSeconds;
    }

    @Override
    public boolean isOpen() {
        return this.isDeviceConnected;
    }

    public void addDeviceListObserver(ListChangeListener<? super Event> event) {
        deviceListObserver.addListener(event);
    }

    public void removeDeviceListObserver(ListChangeListener<? super Event> event) {
        deviceListObserver.removeListener(event);
    }

    private class USBOutputStream
    extends OutputStream {
        private USBOutputStream() {
        }

        @Override
        public void write(byte[] b) throws IOException {
            int success;
            if (System.getProperty("os.name").contains("Windows")) {
                byte[] windowsGrossFix = new byte[65];
                windowsGrossFix[0] = 0;
                System.arraycopy(b, 0, windowsGrossFix, 1, 64);
                success = Hid4JavaUSBAdapter.this.hidDevice.write(windowsGrossFix, 65, (byte)0);
            } else {
                success = Hid4JavaUSBAdapter.this.hidDevice.write(b, 64, (byte)0);
            }
            if (success <= 0) {
                System.out.println("Error Message reportted by hid4java: " + Hid4JavaUSBAdapter.this.hidDevice.getLastErrorMessage());
                throw new IOException(Hid4JavaUSBAdapter.this.deviceName);
            }
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class USBInputStream
    extends InputStream {
        private USBInputStream() {
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            int dataReceived = Hid4JavaUSBAdapter.this.hidDevice.read(b, Hid4JavaUSBAdapter.this.timeOutMS);
            System.out.println("Bytes received for transaction" + dataReceived);
            return dataReceived;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public long skip(long n) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

