/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader8bit;

import com.microchip.scf.CommunicationsInterface;
import com.microchip.scf.softwarelibraryinterfaces.i2c.I2CSoftwareLibraryCommunicationsInterface;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import targetdevice.ITargetDevice;
import unified.bootloader.model.UBootModel;
import unified.bootloader8bit.IMVController;
import unified.bootloader8bit.UBootFXMLController;

public class UBoot
implements ITargetDevice<UBootModel> {
    public UBootModel device = new UBootModel();
    protected IMVController mvcController = null;
    protected CommunicationsInterface commsInterface = null;
    public Parent root = null;
    Map<String, CommunicationsInterface> startupConnectedDeviceMap = new HashMap<String, CommunicationsInterface>();

    public void start() {
        Parent tmpRoot = null;
        try {
            tmpRoot = this.loadFxmlMainForm("UBootFXML.fxml");
        }
        catch (IOException ex) {
            Logger.getLogger(UBoot.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.root = tmpRoot;
    }

    private Parent loadFxmlMainForm(String file) throws IOException {
        UBootFXMLController form = new UBootFXMLController(this);
        URL location = this.getClass().getResource(file);
        FXMLLoader loader = new FXMLLoader(location);
        loader.setController((Object)form);
        Object result = loader.load();
        return (Parent)result;
    }

    @Override
    public void setDeviceName(String deviceName) {
        this.device.setDeviceName(deviceName);
    }

    @Override
    public Parent getViewer() {
        if (this.root == null) {
            this.start();
        }
        return this.root;
    }

    @Override
    public void injectController(IMVController mvcController) {
        this.mvcController = mvcController;
    }

    @Override
    public void injectModelCommunicationsController(CommunicationsInterface passedInterface) {
        try {
            this.device.injectInputStream(passedInterface.getInputStream());
            this.device.injectOutputStream(passedInterface.getOutputStream());
        }
        catch (IOException ex) {
            Logger.getLogger(UBoot.class.getName()).log(Level.SEVERE, "Should be Caught Elsewhere", ex);
        }
    }

    @Override
    public UBootModel getModel() {
        return this.device;
    }

    @Override
    public void injectModelCommunicationInterface(CommunicationsInterface passedInterface) {
        try {
            this.device.injectInputStream(passedInterface.getInputStream());
            this.device.injectOutputStream(passedInterface.getOutputStream());
        }
        catch (IOException ex) {
            Logger.getLogger(UBoot.class.getName()).log(Level.SEVERE, "Should be Caught Elsewhere", ex);
        }
    }

    public void injectI2CInterface(I2CSoftwareLibraryCommunicationsInterface passedI2CInterface) {
        this.device.injectI2CCommunicationInterface(passedI2CInterface);
    }
}

