/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader32bit;

import com.microchip.scf.CommunicationsInterface;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import targetdevice.ITargetDevice;
import unified.bootloader.model32bit.UBootModel32bit;
import unified.bootloader32bit.UBootFXML32bitController;
import unified.bootloader8bit.IMVController;

public class UBoot32
implements ITargetDevice<UBootModel32bit> {
    public UBootModel32bit device = new UBootModel32bit();
    protected IMVController mvcController = null;
    public CommunicationsInterface commsInterface = null;
    public Parent root = null;
    Map<String, CommunicationsInterface> startupConnectedDeviceMap = new HashMap<String, CommunicationsInterface>();

    public void start() {
        Parent root = null;
        try {
            root = this.loadFxmlMainForm("UBootFXML32bit.fxml");
        }
        catch (IOException ex) {
            Logger.getLogger(UBoot32.class.getName()).log(Level.SEVERE, null, ex);
        }
        root.setStyle("-fx-box-border: transparent;");
        this.root = root;
    }

    private Parent loadFxmlMainForm(String file) throws IOException {
        UBootFXML32bitController form = new UBootFXML32bitController(this);
        URL location = this.getClass().getResource(file);
        FXMLLoader loader = new FXMLLoader(location);
        loader.setController((Object)form);
        Object result = loader.load();
        return (Parent)result;
    }

    @Override
    public void setDeviceName(String deviceName) {
        this.device.setDeviceName(deviceName);
    }

    @Override
    public Parent getViewer() {
        if (this.root == null) {
            this.start();
        }
        return this.root;
    }

    @Override
    public void injectModelCommunicationsController(CommunicationsInterface passedInterface) {
        try {
            this.device.injectInputStream(passedInterface.getInputStream());
            this.device.injectOutputStream(passedInterface.getOutputStream());
        }
        catch (IOException ex) {
            Logger.getLogger(UBoot32.class.getName()).log(Level.SEVERE, "Should be Caught Elsewhere", ex);
        }
    }

    @Override
    public UBootModel32bit getModel() {
        return this.device;
    }

    @Override
    public void injectController(IMVController mvcController) {
        this.mvcController = mvcController;
    }

    @Override
    public void injectModelCommunicationInterface(CommunicationsInterface passedInterface) {
        try {
            this.device.injectInputStream(passedInterface.getInputStream());
            this.device.injectOutputStream(passedInterface.getOutputStream());
        }
        catch (IOException ex) {
            Logger.getLogger(UBoot32.class.getName()).log(Level.SEVERE, "Should be Caught Elsewhere", ex);
        }
    }
}

