/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader.model;

import I2CSettings.model.I2CSettingsPojo;
import com.microchip.scf.softwarelibraryinterfaces.i2c.I2CSoftwareLibraryCommunicationsInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import observers.ALoraObserver;
import portSettings.model.PortSettingsPojo;
import unified.bootloader.model.IDeviceModel;
import unified.bootloader.model.UBootPoJo;

public class UBootModel
implements IDeviceModel {
    public boolean updateValueFlag = true;
    List<ALoraObserver> modelObserver = new ArrayList<ALoraObserver>();
    List<ALoraObserver> consoleObserver = new ArrayList<ALoraObserver>();
    private String deviceName = null;
    private String version = null;
    private List<String> console = new ArrayList<String>();
    private InputStream communicationsInputStream = null;
    private OutputStream communicationsOutputStream = null;
    private I2CSoftwareLibraryCommunicationsInterface communicationsI2C = null;
    public PortSettingsPojo dfuPojo = new PortSettingsPojo(this);
    public I2CSettingsPojo i2cPojo = new I2CSettingsPojo(this);
    public UBootPoJo ubootPojo = new UBootPoJo(this);

    @Override
    public void injectInputStream(InputStream myInputStream) {
        this.communicationsInputStream = myInputStream;
    }

    @Override
    public InputStream getInputStream() {
        if (this.communicationsInputStream == null) {
            System.err.println("InputStream is not Initialized");
            return null;
        }
        return this.communicationsInputStream;
    }

    @Override
    public void injectOutputStream(OutputStream myInputStream) {
        this.communicationsOutputStream = myInputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.communicationsOutputStream == null) {
            System.err.println("OutputStream is not Initialized");
            return null;
        }
        return this.communicationsOutputStream;
    }

    @Override
    public void injectI2CCommunicationInterface(I2CSoftwareLibraryCommunicationsInterface myI2CComms) {
        this.communicationsI2C = myI2CComms;
    }

    @Override
    public I2CSoftwareLibraryCommunicationsInterface getI2CCommunicationInterface() {
        if (this.communicationsI2C == null) {
            System.err.println("I2C Interface is not Initialized");
            return null;
        }
        return this.communicationsI2C;
    }

    @Override
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    @Override
    public String getDeviceName() {
        if (this.deviceName != null) {
            return this.deviceName;
        }
        System.err.println("Unnamed device");
        return null;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
        this.callObservers();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public synchronized void setConsoleText(String text) {
        this.console.add(text);
        this.callConsoleObservers();
    }

    public synchronized void setProgress(String text) {
        this.callProgressObservers();
    }

    @Override
    public synchronized String getConsoleText() {
        Iterator<String> iterate = this.console.iterator();
        String element = iterate.next();
        iterate.remove();
        return element;
    }

    @Override
    public void addPropertyChangeListener(ALoraObserver listener) {
        this.modelObserver.add(listener);
    }

    @Override
    public void addConsolePropertyChangeListener(ALoraObserver listener) {
        this.consoleObserver.add(listener);
    }

    @Override
    public void callObservers() {
        for (ALoraObserver observer : this.modelObserver) {
            observer.handleEvent(this, "Property");
        }
    }

    public void callWriteBlockSizeObservers() {
        for (ALoraObserver observer : this.modelObserver) {
            observer.handleEvent(this, "WriteBlockSize");
        }
    }

    @Override
    public void callConsoleObservers() {
        for (ALoraObserver observer : this.consoleObserver) {
            observer.handleEvent(this, "Console");
        }
    }

    public void callProgressObservers() {
        for (ALoraObserver observer : this.consoleObserver) {
            observer.handleEvent(this, "Progress");
        }
    }
}

