/*
 * Decompiled with CFR 0.152.
 */
package udpadapter;

import com.microchip.scf.CommunicationsInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UDPAdapter
implements CommunicationsInterface {
    InputStream udpInputStream;
    OutputStream udpOutputStream;
    InetAddress addr;
    SocketAddress socketAddress;
    private int serverPortName = 0;
    DatagramSocket socket;
    String deviceIP = null;
    boolean isDeviceConnected = false;
    int toolIndex = -1;
    String deviceName;
    int timeoutMS;
    protected static String[] protNames = null;

    public synchronized void setParams(String address, int port) {
        this.deviceIP = address;
        this.serverPortName = port;
    }

    @Override
    public boolean connect() throws IOException {
        try {
            this.addr = InetAddress.getByName(this.deviceIP);
            this.socket = new DatagramSocket();
            this.isDeviceConnected = true;
            this.udpInputStream = new UDPInputStream();
            this.udpOutputStream = new UDPOutputStream();
        }
        catch (SocketException | UnknownHostException ex) {
            this.isDeviceConnected = false;
        }
        return this.isDeviceConnected;
    }

    @Override
    public boolean isOpen() {
        return this.isDeviceConnected;
    }

    @Override
    public boolean disconnect() throws IOException {
        this.udpInputStream.close();
        this.udpOutputStream.close();
        this.socket.close();
        this.isDeviceConnected = false;
        return true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.udpInputStream != null) {
            return this.udpInputStream;
        }
        throw new IOException("Device not opened. Please initialize the device.");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.udpOutputStream != null) {
            return this.udpOutputStream;
        }
        throw new IOException("Device not opened. Please initialize the device.");
    }

    @Override
    public String[] getAttachedDevices() throws IOException {
        return protNames;
    }

    @Override
    public void setDeviceName(String name) {
        this.deviceName = name;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    public void setPort(int passedPort) {
        this.serverPortName = passedPort;
    }

    public void setIpAddress(String passedIP) {
        this.deviceIP = passedIP;
    }

    @Override
    public void setTimeOut(int timeOutinSeconds) {
        this.timeoutMS = timeOutinSeconds;
    }

    public int getPort() {
        return this.serverPortName;
    }

    public String getIpAddress() {
        return this.deviceIP;
    }

    private class UDPOutputStream
    extends OutputStream {
        private UDPOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            System.out.println(UDPAdapter.this.serverPortName);
            byte[] data = new byte[1];
            DatagramPacket packet = new DatagramPacket(data, data.length, UDPAdapter.this.addr, UDPAdapter.this.serverPortName);
            UDPAdapter.this.socket.setSoTimeout(UDPAdapter.this.timeoutMS);
            UDPAdapter.this.socket.send(packet);
        }

        @Override
        public void write(byte[] b) throws IOException {
            System.out.println(UDPAdapter.this.serverPortName);
            DatagramPacket packet = new DatagramPacket(b, b.length, UDPAdapter.this.addr, UDPAdapter.this.serverPortName);
            UDPAdapter.this.socket.setSoTimeout(UDPAdapter.this.timeoutMS);
            UDPAdapter.this.socket.send(packet);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class UDPInputStream
    extends InputStream {
        private UDPInputStream() {
        }

        @Override
        public int read() throws IOException {
            try {
                byte[] data = new byte[1];
                DatagramPacket reply = new DatagramPacket(data, data.length);
                UDPAdapter.this.socket.setSoTimeout(UDPAdapter.this.timeoutMS);
                UDPAdapter.this.socket.receive(reply);
                System.out.println("UDPDone");
                return data[1];
            }
            catch (IOException e) {
                return -1;
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            int byte_count = 0;
            System.out.println("UDPRead");
            try {
                DatagramPacket reply = new DatagramPacket(b, b.length);
                UDPAdapter.this.socket.setSoTimeout(UDPAdapter.this.timeoutMS);
                UDPAdapter.this.socket.receive(reply);
                System.out.println("UDPDone");
                byte_count = reply.getLength();
            }
            catch (IOException e) {
                byte_count = 0;
            }
            return byte_count;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

