/*
 * Decompiled with CFR 0.152.
 */
package toplevel;

import console.Console;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.stage.FileChooser;
import targetdevice.ITargetDevice;
import toplevel.TopLevel;
import unified.bootloader.model.UBootModel;
import unified.bootloader.model32bit.UBootModel32bit;
import unified.bootloader32bit.UBoot32;
import unified.bootloader8bit.UBoot;

public class TopLevelFXMLController
implements Initializable {
    TopLevel application;
    UBoot32 uBoot32;
    private final String versionMajor = "0";
    private final String versionMinor = "1";
    private final String versionPatch = "5";
    @FXML
    private ComboBox<String> deviceArchitectureOptions;
    @FXML
    private Pane attachingPane;
    @FXML
    private Label labelSelectedHex;
    @FXML
    private Menu menuFile;
    @FXML
    private MenuItem menuOpen;
    @FXML
    private MenuItem menuClose;
    @FXML
    private Menu menuSettings;
    @FXML
    private MenuItem menuSerial;
    @FXML
    private MenuItem menuUDP;
    @FXML
    private MenuItem menuUSB;
    @FXML
    private MenuItem menuI2C;
    @FXML
    private Menu menuTools;
    @FXML
    private MenuItem menuConsole;
    @FXML
    private Menu menuHelp;
    @FXML
    private MenuItem menuAbout;
    @FXML
    private ImageView imageView;
    FileChooser fileOpenDialog = new FileChooser();
    Console consoleTopLevel = null;
    private final String arch8Bit = "8-bit";
    private final String arch32Bit = "32-bit";
    private final String protSerial = "UART";
    private final String protUDP = "UDP";
    private final String protUSB = "USB";
    private final String protI2C = "I2C";
    ITargetDevice<UBootModel> dev = new UBoot();
    ITargetDevice<UBootModel32bit> dev32 = new UBoot32();

    public TopLevelFXMLController(TopLevel application) {
        this.application = application;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.deviceArchitectureOptions.getSelectionModel().clearSelection();
        this.deviceArchitectureOptions.getItems().add((Object)"Ispector");
        this.deviceArchitectureOptions.setValue((Object)"Ispector");
        this.menuSerial.setDisable(true);
        this.menuUDP.setDisable(true);
        this.menuUSB.setDisable(true);
        this.menuI2C.setDisable(true);
        this.menuSettings.setVisible(false);
        this.menuHelp.setVisible(false);
        this.imageView.setImage(new Image(this.getClass().getResource("ni.png").toExternalForm()));
        if (this.attachingPane.getChildren().size() != 0) {
            this.attachingPane.getChildren().remove(0);
        }
        this.attachingPane.getChildren().add((Object)this.dev32.getViewer());
        this.deviceArchitectureOptions.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                TopLevelFXMLController.this.menuSerial.setDisable(false);
                TopLevelFXMLController.this.menuUDP.setDisable(true);
                TopLevelFXMLController.this.menuUSB.setDisable(true);
                TopLevelFXMLController.this.menuI2C.setDisable(true);
            }
        });
        this.dev32.getModel().ubootPojo32Bit.getProtocolChanged().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                TopLevelFXMLController.this.settingsMenuUpdate();
            }
        });
        this.dev.getModel().ubootPojo.getProtocolChanged().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                TopLevelFXMLController.this.settingsMenuUpdate();
            }
        });
    }

    @FXML
    void actionClose(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    void actionAbout(ActionEvent event) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("About");
        alert.setHeaderText("Bootloader Build Information");
        alert.setContentText("Unified Bootloader Application v0.1.5\n For more information visit: http://microchip.com/bootloader\n");
        alert.showAndWait();
    }

    @FXML
    void actionOpenHex() {
        block3: {
            try {
                this.fileOpenDialog.setInitialDirectory(new File(Preferences.userNodeForPackage(this.getClass()).get("FilePath", System.getProperty("user.home"))));
                this.fileOpenDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(".hex", new String[]{"*.hex"}));
                File fileChosen = this.fileOpenDialog.showOpenDialog(TopLevel.root.getScene().getWindow());
                if (fileChosen != null) {
                    this.labelSelectedHex.setText(fileChosen.getName() + " loaded");
                    this.application.setFileName(fileChosen.getAbsolutePath());
                    this.dev.getModel().ubootPojo.setFileName(fileChosen.getAbsolutePath());
                    this.dev32.getModel().ubootPojo32Bit.setFileName(fileChosen.getAbsolutePath());
                    Preferences.userNodeForPackage(this.getClass()).put("FilePath", fileChosen.getAbsolutePath().substring(0, fileChosen.getAbsolutePath().indexOf(fileChosen.getName())));
                }
            }
            catch (IllegalArgumentException ex) {
                if (!ex.getMessage().contains("Folder parameter must be a valid folder")) break block3;
                this.fileOpenDialog.setInitialDirectory(new File(System.getProperty("user.home")));
                this.fileOpenDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(".hex", new String[]{"*.hex"}));
                File fileChosen = this.fileOpenDialog.showOpenDialog(TopLevel.root.getScene().getWindow());
                if (fileChosen == null) break block3;
                this.labelSelectedHex.setText(fileChosen.getName() + " loaded");
                this.application.setFileName(fileChosen.getAbsolutePath());
                this.dev.getModel().ubootPojo.setFileName(fileChosen.getAbsolutePath());
                this.dev32.getModel().ubootPojo32Bit.setFileName(fileChosen.getAbsolutePath());
                Preferences.userNodeForPackage(this.getClass()).put("FilePath", fileChosen.getAbsolutePath().substring(0, fileChosen.getAbsolutePath().indexOf(fileChosen.getName())));
            }
        }
    }

    private void settingsMenuUpdate() {
        if (((String)this.deviceArchitectureOptions.getValue()).contains("32-bit")) {
            if (this.dev32.getModel().ubootPojo32Bit.getProtocolType().contains("UART")) {
                this.menuSerial.setDisable(false);
                this.menuUDP.setDisable(true);
                this.menuUSB.setDisable(true);
                this.menuI2C.setDisable(true);
                this.menuI2C.setDisable(true);
            } else if (this.dev32.getModel().ubootPojo32Bit.getProtocolType().contains("UDP")) {
                this.menuSerial.setDisable(true);
                this.menuUDP.setDisable(false);
                this.menuUSB.setDisable(true);
                this.menuI2C.setDisable(true);
            } else if (this.dev32.getModel().ubootPojo32Bit.getProtocolType().contains("USB")) {
                this.menuSerial.setDisable(true);
                this.menuUDP.setDisable(true);
                this.menuUSB.setDisable(false);
                this.menuI2C.setDisable(true);
            }
            this.dev32.getModel().ubootPojo32Bit.setProtocolChanged(false);
        } else if (((String)this.deviceArchitectureOptions.getValue()).contains("8-bit")) {
            if (this.dev.getModel().ubootPojo.getProtocolType().contains("UART")) {
                this.menuSerial.setDisable(false);
                this.menuUDP.setDisable(true);
                this.menuUSB.setDisable(true);
                this.menuI2C.setDisable(true);
                this.menuI2C.setDisable(true);
            } else if (this.dev.getModel().ubootPojo.getProtocolType().contains("I2C")) {
                this.menuSerial.setDisable(true);
                this.menuUDP.setDisable(true);
                this.menuUSB.setDisable(true);
                this.menuI2C.setDisable(false);
            }
            this.dev.getModel().ubootPojo.setProtocolChanged(false);
        }
    }

    @FXML
    void actionSettings() {
        if (((String)this.deviceArchitectureOptions.getValue()).contains("8-bit")) {
            this.dev.getModel().ubootPojo.setConfigurationChangedState(true);
        } else {
            this.dev32.getModel().ubootPojo32Bit.setConfigurationChangedState(true);
        }
    }

    @FXML
    void actionConsole() {
        if (((String)this.deviceArchitectureOptions.getValue()).contains("8-bit")) {
            this.dev.getModel().ubootPojo.setConsoleState(true);
        } else {
            this.dev32.getModel().ubootPojo32Bit.setConsoleState(true);
        }
    }

    @FXML
    void actionUSB() {
    }

    @FXML
    void actionUDP() {
    }
}

