/*
 * Decompiled with CFR 0.152.
 */
package toplevel;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import toplevel.TopLevelFXMLController;
import unified.bootloader8bit.IMVController;
import unified.bootloader8bit.MVController;

public class TopLevel
extends Application {
    private static final Logger LOG = Logger.getLogger(TopLevel.class.getName());
    protected IMVController mvcController = new MVController();
    public static Parent root = null;
    private String fileName = null;
    private String version = "";

    public void start(Stage stage) throws Exception {
        Parent root;
        try {
            Properties prop = new Properties();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream stream = loader.getResourceAsStream("version.properties");
            prop.load(stream);
            this.version = prop.getProperty("project.version", "");
        }
        catch (Exception ex) {
            LOG.log(Level.INFO, "Version properties file not found", ex);
        }
        TopLevel.root = root = this.loadFxmlMainForm("TopLevelFXML.fxml");
        Scene scene = new Scene(root);
        String r = ((Object)((Object)this)).getClass().getResource("mcc_modena.css").toExternalForm();
        scene.getStylesheets().clear();
        scene.getStylesheets().add((Object)r);
        stage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResource("memory.png").toExternalForm()));
        stage.setScene(scene);
        stage.setTitle("Nuclear Instruments Ispector Firmware Upgrade tool " + this.version);
        stage.show();
    }

    private Parent loadFxmlMainForm(String file) throws IOException {
        TopLevelFXMLController form = new TopLevelFXMLController(this);
        URL location = ((Object)((Object)this)).getClass().getResource(file);
        FXMLLoader loader = new FXMLLoader(location);
        loader.setController((Object)form);
        Object result = loader.load();
        return (Parent)result;
    }

    public static void main(String[] args) {
        TopLevel.launch((String[])args);
    }

    public void stop() throws Exception {
        super.stop();
        System.exit(0);
    }

    public synchronized void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public synchronized String getFileName() {
        return this.fileName;
    }
}

