/*
 * Decompiled with CFR 0.152.
 */
package protocol.nextchunkgetter;

import protocol.nextchunkgetter.DataChunk;
import protocol.nextchunkgetter.IGetNextChunk;
import readFileModel.MemoryModel;

public class GetNextEraseAddress
implements IGetNextChunk {
    int startAddress = 1536;
    int address = 0;
    int programMemSize = 8192;
    boolean firstTime = true;
    int eraseRowSize = 64;
    int length = 0;
    private final MemoryModel deviceMemoryModel;

    public GetNextEraseAddress(MemoryModel deviceMemoryModel) {
        this.deviceMemoryModel = deviceMemoryModel;
        this.startAddress = this.deviceMemoryModel.byteAlignedBootloaderOffset;
        this.programMemSize = this.deviceMemoryModel.byteAlignedProgramMemorySize;
        this.eraseRowSize = this.deviceMemoryModel.byteAlignedEraseRowSize;
        this.calculateLengthOfRows();
    }

    private void calculateLengthOfRows() {
        this.length = (this.programMemSize - this.startAddress) / this.eraseRowSize;
    }

    @Override
    public DataChunk getData() {
        DataChunk chunk = new DataChunk();
        if (this.firstTime) {
            this.address += this.startAddress;
            this.firstTime = false;
            chunk.address = this.address;
            chunk.length = this.length;
            return chunk;
        }
        this.address += this.length * this.eraseRowSize;
        if (this.address == this.programMemSize) {
            return null;
        }
        chunk.address = this.address;
        chunk.length = this.length;
        return chunk;
    }
}

