/*
 * Decompiled with CFR 0.152.
 */
package protocol.nextchunkgetter;

import i2cBootloaderModel.DeviceArchitecture;
import protocol.nextchunkgetter.DataChunk;
import protocol.nextchunkgetter.IGetNextChunk;
import readFileModel.MemoryModel;

public abstract class AGetNextChunk
implements IGetNextChunk {
    protected final MemoryModel deviceMemoryModel;
    protected final DeviceArchitecture whichDeviceFamily;
    protected int cursor = 0;
    protected State memoryState = State.BUSY;
    protected DataChunk result = new DataChunk();

    public AGetNextChunk(MemoryModel deviceMemoryModel) {
        this.deviceMemoryModel = deviceMemoryModel;
        this.whichDeviceFamily = deviceMemoryModel.deviceFamily;
        this.setCursorToZero();
    }

    protected abstract DataChunk getNextChunk();

    protected void initDataChunkObj() {
        this.result.noData = true;
        this.result.length = this.deviceMemoryModel.byteAlignedWriteBlockSize;
        this.result.data = new byte[this.result.length];
        for (int i = 0; i < this.result.length; ++i) {
            this.result.data[i] = -1;
        }
    }

    protected void setCursorToZero() {
        this.cursor = 0;
    }

    @Override
    public DataChunk getData() {
        DataChunk resultRead;
        block1: {
            if (!(this.deviceMemoryModel.skipErasedFlashLocations & (resultRead = this.getNextChunk()) != null)) break block1;
            while (resultRead.noData && (resultRead = this.getNextChunk()) != null) {
            }
        }
        return resultRead;
    }

    protected static enum State {
        BUSY,
        DONE;

    }
}

