/*
 * Decompiled with CFR 0.152.
 */
package packetprocessor;

import exceptionclasses.ValidationException;
import i2cBootloaderModel.CommandModelPIC32;
import packetprocessor.IPacketProcessor;

public abstract class APacketProcessorMCU32
implements IPacketProcessor {
    protected byte command;
    protected byte[] lengthProcess;
    protected byte[] addressProcess;
    protected byte[] dataPayload;

    protected abstract void pack(byte[] var1);

    @Override
    public void packPacket(Object whatModel, int timeOut) throws ValidationException {
        this.command = ((CommandModelPIC32)whatModel).command;
        this.dataPayload = ((CommandModelPIC32)whatModel).dataPayload;
        this.validatePacket();
        CommandModelPIC32 model = (CommandModelPIC32)whatModel;
        if (model.writeLength == 0 && (this.command == 3 || this.command == 4)) {
            model.data = new byte[model.dataPayload.length + 5];
        }
        this.pack(((CommandModelPIC32)whatModel).data);
    }

    public void validatePacket() throws ValidationException {
    }

    public byte[] longTobyteArray(long data) {
        byte[] dataConverted = new byte[4];
        for (int i = 0; i < 4; ++i) {
            dataConverted[i] = (byte)data;
            data >>= 8;
        }
        return dataConverted;
    }
}

