/*
 * Decompiled with CFR 0.152.
 */
package packetprocessor;

import exceptionclasses.ValidationException;
import i2cBootloaderModel.CommandModelWrite;
import packetprocessor.IPacketProcessor;

public abstract class APacketProcessor
implements IPacketProcessor {
    protected byte command;
    protected long length;
    protected long address;
    protected byte[] lengthProcess;
    protected byte[] addressProcess;
    protected byte[] dataPayload;

    protected abstract void pack(byte[] var1);

    @Override
    public void packPacket(Object whatModel, int timeOut) throws ValidationException {
        this.command = ((CommandModelWrite)whatModel).command;
        this.length = ((CommandModelWrite)whatModel).length;
        this.address = ((CommandModelWrite)whatModel).address;
        this.dataPayload = ((CommandModelWrite)whatModel).dataPayload;
        this.validatePacket();
        this.lengthProcess = this.longTobyteArray(this.length);
        this.addressProcess = this.longTobyteArray(this.address);
        this.pack(((CommandModelWrite)whatModel).data);
    }

    public void validatePacket() throws ValidationException {
        if (this.length >> 16 != 0L || this.length >> 24 != 0L) {
            throw new ValidationException("Internal packet length field more than two bytes.");
        }
    }

    public byte[] longTobyteArray(long data) {
        byte[] dataConverted = new byte[4];
        for (int i = 0; i < 4; ++i) {
            dataConverted[i] = (byte)data;
            data >>= 8;
        }
        return dataConverted;
    }
}

