/*
 * Decompiled with CFR 0.152.
 */
package i2cReadWriteStopXferFunctions;

import com.microchip.scf.CommunicationsInterface;
import com.microchip.scf.exceptions.GenericException;
import com.microchip.scf.exceptions.ReadWriteStopException;
import com.microchip.scf.softwarelibraryinterfaces.i2c.I2CSoftwareLibraryCommunicationsInterface;
import java.io.IOException;
import packetprocessorsI2C.ProcessGetI2CDataFromUSB;
import packetprocessorsI2C.ProcessRead;
import packetprocessorsI2C.ProcessReadParams;
import packetprocessorsI2C.ProcessRepeatRead;
import packetprocessorsI2C.ProcessSetBitrate;
import packetprocessorsI2C.ProcessStopXfer;
import packetprocessorsI2C.ProcessWrite;
import packetprocessorsI2C.ProcessWriteNoStop;

public class MCPUSBI2CBridgeAdapter
implements I2CSoftwareLibraryCommunicationsInterface<CommunicationsInterface> {
    static final String USB_DISCONN = "USB Packet Not Verified. Device Disconnected";
    static final String USB_BYTES_NOMATCH = "USB Packet Not Verified. Number of Read Bytes do not match with the expected value";
    static final String I2C_DEVICE_TIMEOUT = "I2C Packet Error. Device Timed-out";
    static final String I2C_DEVICE_BUSY = "I2C Packet Error. Device Busy ";
    static final String I2C_GET_DATA_FAILURE = "I2C Packet Error. Please disregard the data ";
    static final String COMM_CLASS_NOT_INIT = "Communication Class Not Initialized. Transaction cannot be completed";
    int i2cAddress;
    CommunicationsInterface communicationClass;
    ProcessStopXfer ProcessStopXfer;
    ProcessWrite ProcessWrite;
    ProcessReadParams ProcessReadParams;
    ProcessRead ProcessRead;
    ProcessWriteNoStop ProcessWriteNoStop;
    ProcessRepeatRead ProcessRepeatRead;
    ProcessGetI2CDataFromUSB ProcessGetI2CDataFromUSB;
    ProcessSetBitrate ProcessSetBitrate;

    @Override
    public void aetLowerLevelCommunicationsInterface(CommunicationsInterface commInterface) {
        this.communicationClass = commInterface;
        this.ProcessStopXfer = new ProcessStopXfer(this.communicationClass);
        this.ProcessWrite = new ProcessWrite(this.communicationClass);
        this.ProcessReadParams = new ProcessReadParams(this.communicationClass);
        this.ProcessRead = new ProcessRead(this.communicationClass);
        this.ProcessWriteNoStop = new ProcessWriteNoStop(this.communicationClass);
        this.ProcessRepeatRead = new ProcessRepeatRead(this.communicationClass);
        this.ProcessGetI2CDataFromUSB = new ProcessGetI2CDataFromUSB(this.communicationClass);
        this.ProcessSetBitrate = new ProcessSetBitrate(this.communicationClass);
    }

    @Override
    public int setBitrate(int bitrate) throws IOException {
        try {
            int retryFlag;
            for (retryFlag = 5; retryFlag != 0; --retryFlag) {
                try {
                    this.ProcessSetBitrate.PackerProcessorSetBitrate(bitrate);
                    break;
                }
                catch (GenericException ex) {
                    if (USB_DISCONN.compareTo(ex.exceptionType) == 0) {
                        System.out.println("In setBitrate(). Device Disconnected");
                        throw new ReadWriteStopException("Device Disconnected");
                    }
                    if (COMM_CLASS_NOT_INIT.compareTo(ex.exceptionType) == 0) {
                        throw new ReadWriteStopException(COMM_CLASS_NOT_INIT);
                    }
                    if (USB_BYTES_NOMATCH.compareTo(ex.exceptionType) != 0 && I2C_DEVICE_BUSY.compareTo(ex.exceptionType) != 0) break;
                    System.out.println("In setBitrate(). Device Busy / USB bytes do not match.");
                    continue;
                }
            }
            if (retryFlag == 0) {
                throw new ReadWriteStopException("setBitrate Transaction Failed");
            }
            throw new ReadWriteStopException("setBitrate Transaction Succeeded. Device state reset. Read/Write transaction failed. Please retry.");
        }
        catch (ReadWriteStopException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void setI2CAddress(byte address) {
        this.i2cAddress = address & 0xFF;
    }

    @Override
    public byte getI2CAddress() {
        return (byte)this.i2cAddress;
    }

    @Override
    public int WriteI2cData(byte[] data, int timeoutMS) throws IOException {
        try {
            int retryFlag;
            if (data.length > 60) {
                throw new ReadWriteStopException("Data buffer overflow detected. Maximum 60 bytes of data writes in one transaction");
            }
            for (retryFlag = 5; retryFlag != 0; --retryFlag) {
                try {
                    this.ProcessWrite.PackerProcessorWrite(this.i2cAddress, data, timeoutMS);
                    break;
                }
                catch (GenericException ex) {
                    if (USB_DISCONN.compareTo(ex.exceptionType) == 0) {
                        System.out.println("In WriteI2cData(). Device Disconnected");
                        throw new ReadWriteStopException("Device Disconnected");
                    }
                    if (COMM_CLASS_NOT_INIT.compareTo(ex.exceptionType) == 0) {
                        throw new ReadWriteStopException(COMM_CLASS_NOT_INIT);
                    }
                    if (USB_BYTES_NOMATCH.compareTo(ex.exceptionType) == 0 || I2C_DEVICE_BUSY.compareTo(ex.exceptionType) == 0) {
                        System.out.println("In WriteI2cData(). Device Busy / USB bytes do not match.");
                        continue;
                    }
                    if (I2C_DEVICE_TIMEOUT.compareTo(ex.exceptionType) != 0) break;
                    --retryFlag;
                    System.out.println("In WriteI2cData(). Device Hung / State locked. Stopping transaction. ");
                    this.StopI2cDataTransfer(timeoutMS);
                    break;
                }
            }
            if (retryFlag == 0) {
                throw new ReadWriteStopException("WriteI2CData Transaction Failed");
            }
            while (retryFlag != 0) {
                try {
                    this.ProcessReadParams.PackerProcessorReadStatus(timeoutMS);
                    break;
                }
                catch (GenericException ex) {
                    if (USB_DISCONN.compareTo(ex.exceptionType) == 0) {
                        System.out.println("In WriteI2cData(). Device Disconnected");
                        throw new ReadWriteStopException("Device Disconnected");
                    }
                    if (COMM_CLASS_NOT_INIT.compareTo(ex.exceptionType) == 0) {
                        throw new ReadWriteStopException(COMM_CLASS_NOT_INIT);
                    }
                    if (USB_BYTES_NOMATCH.compareTo(ex.exceptionType) == 0 || I2C_DEVICE_BUSY.compareTo(ex.exceptionType) == 0) {
                        --retryFlag;
                        System.out.println("In WriteI2cData(). Device Busy / USB bytes do not match.");
                        continue;
                    }
                    if (I2C_DEVICE_TIMEOUT.compareTo(ex.exceptionType) != 0) break;
                    --retryFlag;
                    System.out.println("In WriteI2cData(). Device Hung / State locked. Stopping transaction. ");
                    this.StopI2cDataTransfer(timeoutMS);
                    break;
                }
            }
            if (retryFlag == 0) {
                throw new ReadWriteStopException("WriteI2CData Status Check Transaction Failed");
            }
            return 0;
        }
        catch (ReadWriteStopException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public int ReadI2cData(byte[] data, int timeoutMS) throws IOException {
        try {
            int retryFlag;
            int byteCount = 0;
            if (data.length > 60) {
                throw new ReadWriteStopException("Data buffer overflow. Maximum 60 bytes of data reads in one transaction");
            }
            for (retryFlag = 200; retryFlag != 0; --retryFlag) {
                try {
                    this.ProcessRead.PackerProcessorRead(this.i2cAddress, data.length, timeoutMS);
                    break;
                }
                catch (GenericException ex) {
                    if (USB_DISCONN.compareTo(ex.exceptionType) == 0) {
                        System.out.println("In ReadI2cData() -> ReadI2C. Device Disconnected");
                        throw new ReadWriteStopException("Device Disconnected");
                    }
                    if (COMM_CLASS_NOT_INIT.compareTo(ex.exceptionType) == 0) {
                        throw new ReadWriteStopException(COMM_CLASS_NOT_INIT);
                    }
                    if (USB_BYTES_NOMATCH.compareTo(ex.exceptionType) == 0 || I2C_DEVICE_BUSY.compareTo(ex.exceptionType) == 0) {
                        System.out.println("In ReadI2cData() -> ReadI2C. Device Busy / USB bytes do not match.");
                        continue;
                    }
                    if (I2C_DEVICE_TIMEOUT.compareTo(ex.exceptionType) != 0) break;
                    --retryFlag;
                    System.out.println("In ReadI2cData() -> ReadI2C. Device Hung / State locked. Stopping transaction. ");
                    this.StopI2cDataTransfer(timeoutMS);
                    break;
                }
            }
            if (retryFlag == 0) {
                throw new ReadWriteStopException("ReadI2CData Transaction Failed");
            }
            while (retryFlag != 0) {
                try {
                    byteCount = this.ProcessGetI2CDataFromUSB.PackerProcessorGetI2CData(this.i2cAddress, data, timeoutMS);
                    break;
                }
                catch (GenericException ex) {
                    if (USB_DISCONN.compareTo(ex.exceptionType) == 0) {
                        System.out.println("In ReadI2cData() -> GetI2CData. Device Disconnected");
                        throw new ReadWriteStopException("Device Disconnected");
                    }
                    if (COMM_CLASS_NOT_INIT.compareTo(ex.exceptionType) == 0) {
                        throw new ReadWriteStopException(COMM_CLASS_NOT_INIT);
                    }
                    if (USB_BYTES_NOMATCH.compareTo(ex.exceptionType) == 0 || I2C_DEVICE_BUSY.compareTo(ex.exceptionType) == 0 || I2C_GET_DATA_FAILURE.compareTo(ex.exceptionType) == 0) {
                        --retryFlag;
                        System.out.println("In ReadI2cData() -> GetI2CData. Device Busy / USB bytes do not match / Bad Data.");
                        continue;
                    }
                    if (I2C_DEVICE_TIMEOUT.compareTo(ex.exceptionType) != 0) break;
                    --retryFlag;
                    System.out.println("In ReadI2cData() -> GetI2CData. Device Hung / State locked. Stopping transaction. ");
                    this.StopI2cDataTransfer(timeoutMS);
                    break;
                }
            }
            if (retryFlag == 0) {
                throw new ReadWriteStopException("ReadI2CDataFromUSB Transaction Failed");
            }
            return byteCount;
        }
        catch (ReadWriteStopException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public int StopI2cDataTransfer(int timeoutMS) throws IOException {
        try {
            int retryFlag;
            for (retryFlag = 5; retryFlag != 0; --retryFlag) {
                try {
                    this.ProcessStopXfer.PackerProcessorStopXfer(timeoutMS);
                    break;
                }
                catch (GenericException ex) {
                    if (USB_DISCONN.compareTo(ex.exceptionType) == 0) {
                        System.out.println("In StopI2cDataTransfer(). Device Disconnected");
                        throw new ReadWriteStopException("Device Disconnected");
                    }
                    if (COMM_CLASS_NOT_INIT.compareTo(ex.exceptionType) == 0) {
                        throw new ReadWriteStopException(COMM_CLASS_NOT_INIT);
                    }
                    if (USB_BYTES_NOMATCH.compareTo(ex.exceptionType) != 0 && I2C_DEVICE_BUSY.compareTo(ex.exceptionType) != 0) break;
                    System.out.println("In StopI2cDataTransfer(). Device Busy / USB bytes do not match.");
                    continue;
                }
            }
            if (retryFlag == 0) {
                throw new ReadWriteStopException("StopXfer Transaction Failed");
            }
            throw new ReadWriteStopException("StopXfer Transaction Succeeded. Device state reset. Read/Write transaction failed. Please retry.");
        }
        catch (ReadWriteStopException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public int WriteI2cDataNoStop(byte[] data, int timeoutMS) throws IOException {
        try {
            int retryFlag;
            if (data.length > 60) {
                throw new ReadWriteStopException("Data buffer overflow detected. Maximum 60 bytes of data writes in one transaction");
            }
            for (retryFlag = 5; retryFlag != 0; --retryFlag) {
                try {
                    this.ProcessWriteNoStop.PackerProcessorWriteNoStop(this.i2cAddress, data, timeoutMS);
                    break;
                }
                catch (GenericException ex) {
                    if (USB_DISCONN.compareTo(ex.exceptionType) == 0) {
                        System.out.println("In WriteI2cData(). Device Disconnected");
                        throw new ReadWriteStopException("Device Disconnected");
                    }
                    if (COMM_CLASS_NOT_INIT.compareTo(ex.exceptionType) == 0) {
                        throw new ReadWriteStopException(COMM_CLASS_NOT_INIT);
                    }
                    if (USB_BYTES_NOMATCH.compareTo(ex.exceptionType) == 0 || I2C_DEVICE_BUSY.compareTo(ex.exceptionType) == 0) {
                        System.out.println("In WriteI2cData(). Device Busy / USB bytes do not match.");
                        continue;
                    }
                    if (I2C_DEVICE_TIMEOUT.compareTo(ex.exceptionType) != 0) break;
                    --retryFlag;
                    System.out.println("In WriteI2cData(). Device Hung / State locked. Stopping transaction. ");
                    this.StopI2cDataTransfer(timeoutMS);
                    break;
                }
            }
            if (retryFlag == 0) {
                throw new ReadWriteStopException("WriteI2CData Transaction Failed");
            }
            while (retryFlag != 0) {
                try {
                    this.ProcessReadParams.PackerProcessorReadStatus(timeoutMS);
                    break;
                }
                catch (GenericException ex) {
                    if (USB_DISCONN.compareTo(ex.exceptionType) == 0) {
                        System.out.println("In WriteI2cData(). Device Disconnected");
                        throw new ReadWriteStopException("Device Disconnected");
                    }
                    if (COMM_CLASS_NOT_INIT.compareTo(ex.exceptionType) == 0) {
                        throw new ReadWriteStopException(COMM_CLASS_NOT_INIT);
                    }
                    if (USB_BYTES_NOMATCH.compareTo(ex.exceptionType) == 0 || I2C_DEVICE_BUSY.compareTo(ex.exceptionType) == 0) {
                        --retryFlag;
                        System.out.println("In WriteI2cData(). Device Busy / USB bytes do not match.");
                        continue;
                    }
                    if (I2C_DEVICE_TIMEOUT.compareTo(ex.exceptionType) != 0) break;
                    --retryFlag;
                    System.out.println("In WriteI2cData(). Device Hung / State locked. Stopping transaction. ");
                    this.StopI2cDataTransfer(timeoutMS);
                    break;
                }
            }
            if (retryFlag == 0) {
                throw new ReadWriteStopException("WriteI2CData Status Check Transaction Failed");
            }
            return 0;
        }
        catch (ReadWriteStopException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public int RepeatReadI2cData(byte[] data, int timeoutMS) throws IOException {
        try {
            int retryFlag;
            int byteCount = 0;
            if (data.length > 60) {
                throw new ReadWriteStopException("Data buffer overflow. Maximum 60 bytes of data reads in one transaction");
            }
            for (retryFlag = 200; retryFlag != 0; --retryFlag) {
                try {
                    this.ProcessRepeatRead.PackerProcessorRepeatRead(this.i2cAddress, data.length, timeoutMS);
                    break;
                }
                catch (GenericException ex) {
                    if (USB_DISCONN.compareTo(ex.exceptionType) == 0) {
                        System.out.println("In ReadI2cData() -> ReadI2C. Device Disconnected");
                        throw new ReadWriteStopException("Device Disconnected");
                    }
                    if (COMM_CLASS_NOT_INIT.compareTo(ex.exceptionType) == 0) {
                        throw new ReadWriteStopException(COMM_CLASS_NOT_INIT);
                    }
                    if (USB_BYTES_NOMATCH.compareTo(ex.exceptionType) == 0 || I2C_DEVICE_BUSY.compareTo(ex.exceptionType) == 0) {
                        System.out.println("In ReadI2cData() -> ReadI2C. Device Busy / USB bytes do not match.");
                        continue;
                    }
                    if (I2C_DEVICE_TIMEOUT.compareTo(ex.exceptionType) != 0) break;
                    --retryFlag;
                    System.out.println("In ReadI2cData() -> ReadI2C. Device Hung / State locked. Stopping transaction. ");
                    this.StopI2cDataTransfer(timeoutMS);
                    break;
                }
            }
            if (retryFlag == 0) {
                throw new ReadWriteStopException("ReadI2CData Transaction Failed");
            }
            while (retryFlag != 0) {
                try {
                    byteCount = this.ProcessGetI2CDataFromUSB.PackerProcessorGetI2CData(this.i2cAddress, data, timeoutMS);
                    break;
                }
                catch (GenericException ex) {
                    if (USB_DISCONN.compareTo(ex.exceptionType) == 0) {
                        System.out.println("In ReadI2cData() -> GetI2CData. Device Disconnected");
                        throw new ReadWriteStopException("Device Disconnected");
                    }
                    if (COMM_CLASS_NOT_INIT.compareTo(ex.exceptionType) == 0) {
                        throw new ReadWriteStopException(COMM_CLASS_NOT_INIT);
                    }
                    if (USB_BYTES_NOMATCH.compareTo(ex.exceptionType) == 0 || I2C_DEVICE_BUSY.compareTo(ex.exceptionType) == 0 || I2C_GET_DATA_FAILURE.compareTo(ex.exceptionType) == 0) {
                        --retryFlag;
                        System.out.println("In ReadI2cData() -> GetI2CData. Device Busy / USB bytes do not match / Bad Data.");
                        continue;
                    }
                    if (I2C_DEVICE_TIMEOUT.compareTo(ex.exceptionType) != 0) break;
                    --retryFlag;
                    System.out.println("In ReadI2cData() -> GetI2CData. Device Hung / State locked. Stopping transaction. ");
                    this.StopI2cDataTransfer(timeoutMS);
                    break;
                }
            }
            if (retryFlag == 0) {
                throw new ReadWriteStopException("ReadI2CDataFromUSB Transaction Failed");
            }
            return byteCount;
        }
        catch (ReadWriteStopException ex) {
            throw new IOException(ex.getMessage());
        }
    }
}

