/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController;

import exceptionclasses.ValidationException;
import i2cBootloaderController.ACommandBaseExtendedNoDataPayload;
import i2cBootloaderModel.CommandModelWrite;
import i2cBootloaderModel.DeviceArchitecture;
import java.io.InputStream;
import java.io.OutputStream;
import packetprocessor.PacketProcessorNoDataPayloadUART;
import readFileModel.MemoryModel;

public class CommandChecksumUART
extends ACommandBaseExtendedNoDataPayload {
    public CommandChecksumUART(InputStream commsInputStream, OutputStream commsOutputStream, MemoryModel deviceMemoryModel) {
        this.bootloaderInputStream = commsInputStream;
        this.bootloaderOutputStream = commsOutputStream;
        this.deviceMemoryModel = deviceMemoryModel;
        this.setProcessReadData();
        this.setCommandModel(new CommandModelWrite());
        this.model.command = (byte)8;
        this.model.length = deviceMemoryModel.byteAlignedProgramMemorySize - deviceMemoryModel.byteAlignedBootloaderOffset;
        this.model.address = deviceMemoryModel.deviceFamily.compareTo(DeviceArchitecture.PIC16) == 0 ? (long)(deviceMemoryModel.byteAlignedBootloaderOffset / 2) : (long)deviceMemoryModel.byteAlignedBootloaderOffset;
        this.model.dataPayload = null;
        this.model.writeLength = 10;
        this.model.readLengthExpected = 12;
        this.model.allocateReadWriteBufferMemory();
    }

    @Override
    public int validateLevel2() throws ValidationException {
        int theroreticalChecksum = this.deviceMemoryModel.calculateChecksumOnFlash();
        System.out.println("Theoretical Checksum:" + String.format("%02X", theroreticalChecksum));
        System.out.println("Receieved Checksum:" + String.format("%02X", this.model.dataRead[this.model.dataRead.length - 1]) + String.format("%02X", this.model.dataRead[this.model.dataRead.length - 2]));
        if (this.model.dataRead[this.model.dataRead.length - 2] != (byte)(theroreticalChecksum & 0xFF) || this.model.dataRead[this.model.dataRead.length - 1] != (byte)((theroreticalChecksum & 0xFF00) >> 8)) {
            throw new ValidationException("Checksum does not match.");
        }
        if (this.model.errorStatus) {
            this.model.errorStatus = false;
            return -1;
        }
        return 0;
    }

    @Override
    protected void setPacketProcessorToUse() {
        this.commandSpecificPacketProcessor = new PacketProcessorNoDataPayloadUART();
    }
}

