/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController;

import exceptionclasses.ValidationException;
import i2cBootloaderController.ACommandBaseExtendedNoDataPayloadMCU32;
import i2cBootloaderModel.CommandModelPIC32;
import java.io.InputStream;
import java.io.OutputStream;
import packetprocessor.PacketProcessorDataPayloadMCU32;
import readFileModel.MCU32MemoryModel;

public class CommandChecksumMCU32
extends ACommandBaseExtendedNoDataPayloadMCU32 {
    final byte ADDRLB = (byte)2;
    final byte ADDRHB = (byte)2;
    final byte ADDRUB = (byte)3;
    final byte ADDRMB = (byte)3;
    final byte NUMBYTELB = (byte)3;
    final byte NUMBYTEHB = (byte)3;
    final byte NUMBYTEUB = (byte)4;
    final byte NUMBYTEMB = (byte)5;

    public CommandChecksumMCU32(InputStream commsInputStream, OutputStream commsOutputStream, MCU32MemoryModel deviceMemoryModel) {
        this.bootloaderInputStream = commsInputStream;
        this.bootloaderOutputStream = commsOutputStream;
        this.mcu32DeviceMemoryModel = deviceMemoryModel;
        this.setProcessReadDataMCU32();
        this.setCommandModel(new CommandModelPIC32());
        this.model.command = (byte)8;
        byte[] dataPayload = new byte[]{2, 2, 3, 3, 3, 3, 4, 5};
        this.model.dataPayload = dataPayload;
        this.model.writeLength = 14;
        this.model.readLengthExpected = 9;
        this.model.allocateReadWriteBufferMemory();
    }

    @Override
    public int validateLevel2() throws ValidationException {
        int theroreticalChecksum = this.deviceMemoryModel.calculateChecksumOnFlash();
        System.out.println("Theoretical Checksum:" + String.format("%02X", theroreticalChecksum));
        System.out.println("Receieved Checksum:" + String.format("%02X", this.model.dataRead[this.model.dataRead.length - 1]) + String.format("%02X", this.model.dataRead[this.model.dataRead.length - 2]));
        if (this.model.dataRead[this.model.dataRead.length - 2] != (byte)(theroreticalChecksum & 0xFF) || this.model.dataRead[this.model.dataRead.length - 1] != (byte)((theroreticalChecksum & 0xFF00) >> 8)) {
            throw new ValidationException("Checksum does not match.");
        }
        if (this.model.errorStatus) {
            this.model.errorStatus = false;
            return -1;
        }
        return 0;
    }

    @Override
    protected void setPacketProcessorToUse() {
        this.commandSpecificPacketProcessor = new PacketProcessorDataPayloadMCU32();
    }
}

