/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController;

import com.microchip.mcu8.commandcore.ACommandBaseI2C;
import exceptionclasses.TransactionFailureException;
import exceptionclasses.ValidationException;
import i2cBootloaderModel.CommandModelWrite;
import java.io.IOException;
import packetprocessor.PacketProcessorNoDataPayload;

public abstract class ACommandBaseI2CExtendedNoDataPayload
extends ACommandBaseI2C {
    protected CommandModelWrite model;

    @Override
    public int process() throws TransactionFailureException {
        this.setPacketProcessorToUse();
        while (this.retryCount != 0) {
            try {
                this.commandSpecificPacketProcessor.packPacket(this.model, this.timeOut);
                this.i2cInterface.WriteI2cData(this.model.data, this.timeOut);
                System.out.println("READ_VER");
                for (byte b : this.model.data) {
                    System.out.print(String.format("%02X", b));
                }
                System.out.println("READ_VER_DONE");
                int lengthReceived = this.i2cInterface.ReadI2cData(this.model.dataRead, this.timeOut);
                this.processReadData.unpackPacket(lengthReceived, this.model, this.timeOut);
                if (this.model.dataRead != null) {
                    for (byte b : this.model.dataRead) {
                        System.out.println(b);
                    }
                }
                this.validateLevel2();
                break;
            }
            catch (ValidationException ex) {
                --this.retryCount;
                if (this.retryCount != 0) continue;
                throw new TransactionFailureException("Transaction Failed." + ex.whatException);
            }
            catch (IOException ex) {
                --this.retryCount;
                if (this.retryCount != 0) continue;
                throw new TransactionFailureException("Transaction Failed." + ex);
            }
        }
        return 0;
    }

    @Override
    protected void setPacketProcessorToUse() {
        this.commandSpecificPacketProcessor = new PacketProcessorNoDataPayload();
    }

    public void setCommandModel(CommandModelWrite model) {
        this.model = model;
    }
}

