/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController;

import com.microchip.mcu8.commandcore.ACommandBase;
import exceptionclasses.TransactionFailureException;
import exceptionclasses.ValidationException;
import i2cBootloaderModel.CommandModelPIC32;
import java.io.IOException;
import protocol.nextchunkgetter.DataChunk;
import protocol.nextchunkgetter.IGetNextChunk;

public abstract class ACommandBaseExtendedWithDataPayloadMCU32
extends ACommandBase {
    protected CommandModelPIC32 model;
    IGetNextChunk addressIterator;
    State state = State.INIT;

    protected abstract void setEraseChunckIterator();

    @Override
    public int process() throws TransactionFailureException {
        int lengthReceived = 0;
        this.setEraseChunckIterator();
        this.setPacketProcessorToUse();
        DataChunk chunk = null;
        while (this.retryCount != 0) {
            try {
                switch (this.state) {
                    case INIT: {
                        this.model.dataPayload = this.addressIterator.getData().data;
                        this.state = State.WRITE;
                    }
                    case WRITE: {
                        this.commandSpecificPacketProcessor.packPacket(this.model, this.timeOut);
                        this.bootloaderOutputStream.write(this.model.data);
                        this.state = State.READ;
                        System.out.println("WRITE");
                        for (byte b : this.model.data) {
                            System.out.print(String.format("%02X", b));
                        }
                        System.out.println("\nWRITE_DONE");
                        this.modelBootloader.setConsoleText(new String(this.model.dataRead));
                        break;
                    }
                    case READ: {
                        lengthReceived = this.bootloaderInputStream.read(this.model.dataRead);
                        this.state = State.VALIDATE;
                        System.out.println("READ");
                        for (byte b : this.model.dataRead) {
                            System.out.print(String.format("%02X", b));
                        }
                        System.out.println("READ_DONE");
                        System.out.println("READ_DONE" + lengthReceived);
                        break;
                    }
                    case VALIDATE: {
                        this.processReadDataMCU32.unpackPacket(lengthReceived, this.model, this.timeOut);
                        this.validateLevel2();
                        this.state = State.ITERATE;
                        break;
                    }
                    case ITERATE: {
                        chunk = this.addressIterator.getData();
                        if (chunk != null) {
                            this.model.dataPayload = chunk.data;
                            this.state = State.WRITE;
                            break;
                        }
                        return 0;
                    }
                }
            }
            catch (ValidationException ex) {
                --this.retryCount;
                this.state = State.WRITE;
                if (this.retryCount != 0) continue;
                throw new TransactionFailureException("Transaction Failed." + ex.whatException);
            }
            catch (IOException ex) {
                --this.retryCount;
                if (this.retryCount != 0) continue;
                throw new TransactionFailureException("Transaction Failed." + ex);
            }
        }
        return 0;
    }

    public void setCommandModel(CommandModelPIC32 model) {
        this.model = model;
    }

    private static enum State {
        INIT,
        READ,
        WRITE,
        VALIDATE,
        ITERATE;

    }
}

