/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController;

import com.microchip.mcu8.commandcore.ACommandBase;
import exceptionclasses.TransactionFailureException;
import exceptionclasses.ValidationException;
import i2cBootloaderModel.CommandModelWrite;
import i2cBootloaderModel.DeviceArchitecture;
import java.io.IOException;
import protocol.nextchunkgetter.DataChunk;
import protocol.nextchunkgetter.IGetNextChunk;

public abstract class ACommandBaseExtendedWithDataPayload
extends ACommandBase {
    protected CommandModelWrite model;
    IGetNextChunk addressIterator;
    State state = State.INIT;

    protected abstract void setEraseChunckIterator();

    @Override
    public int process() throws TransactionFailureException {
        int lengthReceived = 0;
        this.setEraseChunckIterator();
        this.setPacketProcessorToUse();
        while (this.retryCount != 0) {
            try {
                switch (this.state) {
                    case INIT: {
                        DataChunk chunk = this.addressIterator.getData();
                        this.model.address = this.deviceMemoryModel.deviceFamily.compareTo(DeviceArchitecture.PIC16) == 0 ? (long)(chunk.address / 2) : (long)chunk.address;
                        this.model.length = chunk.length;
                        this.model.dataPayload = chunk.data;
                        this.state = State.WRITE;
                        break;
                    }
                    case WRITE: {
                        this.commandSpecificPacketProcessor.packPacket(this.model, this.timeOut);
                        for (byte b : this.model.data) {
                            System.out.print(String.format("%02X", b));
                        }
                        System.out.println("WRITE");
                        this.bootloaderOutputStream.write(this.model.data);
                        this.state = State.READ;
                        System.out.println("WRITE");
                        for (byte b : this.model.data) {
                            System.out.print(String.format("%02X", b));
                        }
                        System.out.println("WRITE_DONE");
                        this.modelBootloader.setConsoleText(new String(this.model.dataRead));
                        break;
                    }
                    case READ: {
                        lengthReceived = this.bootloaderInputStream.read(this.model.dataRead);
                        this.state = State.VALIDATE;
                        for (byte b : this.model.dataRead) {
                            System.out.print(String.format("%02X", b));
                        }
                        System.out.println("READ");
                        break;
                    }
                    case VALIDATE: {
                        this.processReadData.unpackPacket(lengthReceived, this.model, this.timeOut);
                        this.validateLevel2();
                        this.model.dataRead = this.model.dataRead;
                        this.state = State.ITERATE;
                        break;
                    }
                    case ITERATE: {
                        DataChunk chunck = this.addressIterator.getData();
                        if (chunck != null) {
                            this.model.address = this.deviceMemoryModel.deviceFamily.compareTo(DeviceArchitecture.PIC16) == 0 ? (long)(chunck.address / 2) : (long)chunck.address;
                            this.model.length = chunck.length;
                            this.model.dataPayload = chunck.data;
                            this.state = State.WRITE;
                            break;
                        }
                        return 0;
                    }
                }
            }
            catch (ValidationException ex) {
                --this.retryCount;
                if (this.retryCount != 0) continue;
                throw new TransactionFailureException("Transaction Failed." + ex.whatException);
            }
            catch (IOException ex) {
                --this.retryCount;
                if (this.retryCount != 0) continue;
                throw new TransactionFailureException("Transaction Failed." + ex);
            }
        }
        return 0;
    }

    public void setCommandModel(CommandModelWrite model) {
        this.model = model;
    }

    protected static enum State {
        INIT,
        READ,
        WRITE,
        VALIDATE,
        ITERATE;

    }
}

