/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController;

import com.microchip.mcu8.commandcore.ACommandBase;
import exceptionclasses.TransactionFailureException;
import exceptionclasses.ValidationException;
import i2cBootloaderModel.CommandModelPIC32;
import java.io.IOException;
import packetprocessor.PacketProcessorNoDataPayload;

public abstract class ACommandBaseExtendedNoDataPayloadMCU32
extends ACommandBase {
    protected CommandModelPIC32 model;

    @Override
    public int process() throws TransactionFailureException {
        this.setPacketProcessorToUse();
        while (this.retryCount != 0) {
            try {
                this.commandSpecificPacketProcessor.packPacket(this.model, this.timeOut);
                this.bootloaderOutputStream.write(this.model.data);
                System.out.println("READ_VER");
                for (byte b : this.model.data) {
                    System.out.print(String.format("%02X", b));
                }
                System.out.println("READ_VER_DONE");
                int lengthReceived = this.bootloaderInputStream.read(this.model.dataRead);
                System.err.println("Length Received:" + lengthReceived + "\n");
                this.processReadDataMCU32.unpackPacket(lengthReceived, this.model, this.timeOut);
                if (this.model.dataRead != null) {
                    for (byte b : this.model.dataRead) {
                        System.out.println(String.format("%02X", b));
                    }
                }
                this.validateLevel2();
                break;
            }
            catch (ValidationException ex) {
                --this.retryCount;
                ex.printStackTrace();
                if (this.retryCount != 0) continue;
                throw new TransactionFailureException("Transaction Failed." + ex.whatException);
            }
            catch (IOException ex) {
                --this.retryCount;
                if (this.retryCount != 0) continue;
                throw new TransactionFailureException("Transaction Failed." + ex);
            }
        }
        return 0;
    }

    @Override
    protected void setPacketProcessorToUse() {
        this.commandSpecificPacketProcessor = new PacketProcessorNoDataPayload();
    }

    public void setCommandModel(CommandModelPIC32 model) {
        this.model = model;
    }
}

