/*
 * Decompiled with CFR 0.152.
 */
package commands;

import com.microchip.mcu8.commandcore.ACommandBaseI2C;
import commands.ACommand;
import exceptionclasses.TransactionFailureException;
import i2cBootloaderController.CommandChecksum;
import i2cBootloaderController.CommandEraseDevice;
import i2cBootloaderController.CommandReadVersionProtocolUSB;
import i2cBootloaderController.CommandResetDevice;
import i2cBootloaderController.CommandWriteDeviceEE;
import i2cBootloaderController.CommandWriteDeviceFlash;
import i2cBootloaderModel.BootloaderModel;
import i2cBootloaderModel.DeviceArchitecture;
import java.io.File;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import observers.ABootloaderObserver;
import readFileController.HexFileIO;
import readFileController.IFileIO;
import readFileModel.MCU32MemoryModel;
import readFileModel.MemoryModel;
import unified.bootloader.model.UBootModel;

public class BootloadI2CDFUFED
extends ACommand<UBootModel> {
    private static final Logger LOG = Logger.getLogger(BootloadI2CDFUFED.class.getName());
    boolean propI2cSkipChecksum = false;
    protected String fileName;
    protected ACommandBaseI2C readVersionCommand;
    protected ACommandBaseI2C eraseDeviceCommand;
    protected ACommandBaseI2C checksumCommand;
    protected ACommandBaseI2C resetCommand;
    protected ACommandBaseI2C writeCommand;
    protected ACommandBaseI2C writeCommandEE;
    protected ACommandBaseI2C writeCommandConfig;
    IFileIO fileReader = new HexFileIO();
    protected MemoryModel deviceMemoryModel = new MemoryModel(DeviceArchitecture.PIC18);
    protected BootloaderModel model = new BootloaderModel();

    public BootloadI2CDFUFED() {
        this.retryCount = 5;
        this.timeout = 100;
        try {
            this.propI2cSkipChecksum = Boolean.getBoolean("i2c.skipChecksum");
        }
        catch (Exception ex) {
            LOG.log(Level.INFO, "Could not get configuration properties. Using defaults", ex);
        }
    }

    public void createCommands() {
        this.readVersionCommand = new CommandReadVersionProtocolUSB(((UBootModel)this.device).getI2CCommunicationInterface(), this.deviceMemoryModel);
        this.initializeCommands(this.readVersionCommand, 5, 10000);
    }

    public void createAllExceptReadVersion() {
        this.eraseDeviceCommand = new CommandEraseDevice(((UBootModel)this.device).getI2CCommunicationInterface(), this.deviceMemoryModel);
        this.checksumCommand = new CommandChecksum(((UBootModel)this.device).getI2CCommunicationInterface(), this.deviceMemoryModel);
        this.resetCommand = new CommandResetDevice(((UBootModel)this.device).getI2CCommunicationInterface(), this.deviceMemoryModel);
        this.writeCommand = new CommandWriteDeviceFlash(((UBootModel)this.device).getI2CCommunicationInterface(), this.deviceMemoryModel);
        this.writeCommandEE = new CommandWriteDeviceEE(((UBootModel)this.device).getI2CCommunicationInterface(), this.deviceMemoryModel);
        this.initializeCommands(this.eraseDeviceCommand, 5, 10000);
        this.initializeCommands(this.checksumCommand, 5, 10000);
        this.initializeCommands(this.resetCommand, 5, 100);
        this.initializeCommands(this.writeCommand, 5, 1000);
        this.initializeCommands(this.writeCommandEE, 5, 1000);
    }

    public void setMemoryModelForDevice(MemoryModel deviceMemoryModel, int byteAlignedProgramMemorySize, int byteAlignedbootloaderOffset, int byteAlignedEraseRowSize, int setbyteAlignedeepromSize, int byteAlignedConfigMemoryOffset, int setbyteAlignedConfigSize, int byteAlignedeepromMemoryOffset, boolean skipErasedFlashLocationsFlag, int setbyteAlignedWriteBlockSize) {
        deviceMemoryModel.setbyteAlignedprogramMemorySize(byteAlignedProgramMemorySize);
        deviceMemoryModel.setbyteAlignedbootloaderOffset(byteAlignedbootloaderOffset);
        deviceMemoryModel.setbyteAlignedEraseRowSize(byteAlignedEraseRowSize);
        deviceMemoryModel.setbyteAlignedeepromSize(setbyteAlignedeepromSize);
        deviceMemoryModel.setbyteAlignedeepromMemoryOffset(byteAlignedeepromMemoryOffset);
        deviceMemoryModel.setskipErasedFlashLocationsFlag(skipErasedFlashLocationsFlag);
        deviceMemoryModel.setbyteAlignedWriteBlockSize(setbyteAlignedWriteBlockSize);
        deviceMemoryModel.setbyteAlignedconfigurationWordsOffset(byteAlignedConfigMemoryOffset);
        deviceMemoryModel.setbyteAlignedconfigurationWordsSize(setbyteAlignedConfigSize);
        deviceMemoryModel.createProgramMemoryMap();
        deviceMemoryModel.createEEPROMMap();
        deviceMemoryModel.createConfigurationWordsMap();
    }

    public void setMemoryModelForDevice(MCU32MemoryModel mcu32DeviceMemoryModel) {
        mcu32DeviceMemoryModel.createProgramMemoryMap();
    }

    public void initializeCommands(ACommandBaseI2C command, int retryCount, int timeout) {
        command.setTimeout(timeout);
        command.setRetryCount(retryCount);
        command.setBootloaderModel(this.model);
    }

    protected void setupDevice() {
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Device: " + ((UBootModel)this.device).getDeviceName() + " Bootloading started"));
        this.deviceMemoryModel = ((UBootModel)this.device).ubootPojo.getDeviceArchitecture().compareTo("PIC16") == 0 ? new MemoryModel(DeviceArchitecture.PIC16) : new MemoryModel(DeviceArchitecture.PIC18);
        this.setMemoryModelForDevice(this.deviceMemoryModel, Integer.parseInt(((UBootModel)this.device).ubootPojo.getProgramMemorySize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getBootloaderOffset().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedEraseRowSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getSetbyteAlignedeepromSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedConfigMemoryOffset().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getSetbyteAlignedConfigSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedeepromMemoryOffset().replace("0x", ""), 16), true, Integer.parseInt(((UBootModel)this.device).ubootPojo.getWriteBlockSize().replace("0x", ""), 16));
        this.createCommands();
        this.model.addPropertyChangeListener(new ABootloaderObserver(){

            @Override
            public void handleEvent(BootloaderModel value, String whatChanged, String changed) {
                assert (whatChanged.equals("Version"));
                byte[] changedBytes = changed.getBytes(Charset.forName("ISO-8859-1"));
                String fs = "%s)        BLD_VER: %s          Device ID: 0x%02X           FL_ER: %s           FL_WR: %s           User ID: 0x%04X";
                String version = String.format(fs, ((UBootModel)BootloadI2CDFUFED.this.device).getDeviceName(), changedBytes[9], changedBytes[16] << 8 & 0xFFFF | changedBytes[15] & 0xFF, changedBytes[19], changedBytes[20], changedBytes[24] << 24 & 0xFFFFFFFF | changedBytes[23] << 16 & 0xFFFFFF | changedBytes[22] << 8 & 0xFFFF | changedBytes[21] & 0xFF);
                ((UBootModel)BootloadI2CDFUFED.this.device).setVersion(version);
                System.out.format("%s: %s%n", whatChanged, version);
            }
        });
        this.model.addConsolePropertyChangeListener(new ABootloaderObserver(){

            @Override
            public void handleEvent(BootloaderModel value, String whatChanged, String changed) {
                ((UBootModel)BootloadI2CDFUFED.this.device).setProgress(changed);
            }
        });
    }

    @Override
    public void execute() throws TransactionFailureException {
        this.setupDevice();
        this.fileReader.setMemoryModel(this.deviceMemoryModel);
        this.fileName = ((UBootModel)this.device).ubootPojo.getFileName();
        if (this.fileName == null || this.fileName.isEmpty()) {
            System.out.println("Invalid File");
            throw new TransactionFailureException("Hex File is Invalid");
        }
        File fp = this.fileReader.fopen(this.fileName);
        this.fileReader.fread(fp);
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Reading Version ..."));
        this.readVersionCommand.executeChain();
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Bootloader Version Read Successful"));
        if (this.deviceMemoryModel.deviceFamily.equals((Object)DeviceArchitecture.PIC16)) {
            String parsedEraseSize = "0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_WR") + 7, ((UBootModel)this.device).getVersion().indexOf("User ID") - 11).toString()));
            Integer convertedEraseValue = Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedEraseRowSize().replace("0x", ""), 16);
            String parsedWriteSize = "0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_WR") + 7, ((UBootModel)this.device).getVersion().indexOf("User ID") - 11).toString()));
            Integer convertedWriteValue = Integer.parseInt(((UBootModel)this.device).ubootPojo.getWriteBlockSize().replace("0x", ""), 16);
            ((UBootModel)this.device).ubootPojo.setWriteBlockSize(parsedWriteSize);
            if (convertedWriteValue == 64) {
                convertedWriteValue = 32;
            }
            this.deviceMemoryModel.setbyteAlignedWriteBlockSize(convertedWriteValue);
            ((UBootModel)this.device).ubootPojo.setByteAlignedEraseRowSize(parsedEraseSize);
            convertedEraseValue = convertedEraseValue * 2;
            this.deviceMemoryModel.setbyteAlignedEraseRowSize(convertedEraseValue);
        } else {
            String parsedEraseSize = "0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_ER") + 7, ((UBootModel)this.device).getVersion().indexOf("FL_WR") - 11).toString()));
            Integer convertedEraseValue = Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedEraseRowSize().replace("0x", ""), 16);
            String parsedWriteSize = "0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_WR") + 7, ((UBootModel)this.device).getVersion().indexOf("User ID") - 11).toString()));
            Integer convertedWriteValue = Integer.parseInt(((UBootModel)this.device).ubootPojo.getWriteBlockSize().replace("0x", ""), 16);
            ((UBootModel)this.device).ubootPojo.setWriteBlockSize(parsedWriteSize);
            this.deviceMemoryModel.setbyteAlignedWriteBlockSize(convertedWriteValue);
            ((UBootModel)this.device).ubootPojo.setByteAlignedEraseRowSize(parsedEraseSize);
            this.deviceMemoryModel.setbyteAlignedEraseRowSize(convertedEraseValue);
        }
        this.createAllExceptReadVersion();
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Erasing Device ..."));
        this.eraseDeviceCommand.executeChain();
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Erase Successful"));
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Programming Flash ..."));
        this.writeCommand.executeChain();
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Flashed Programmed"));
        if (((UBootModel)this.device).ubootPojo.getProgramEEData().compareTo("Enabled") == 0) {
            ((UBootModel)this.device).setConsoleText(super.timeStamp("Programming EEData ..."));
            this.writeCommandEE.executeChain();
            ((UBootModel)this.device).setConsoleText(super.timeStamp("EEData Programmed"));
        }
        if (((UBootModel)this.device).ubootPojo.getProgramConfigurationWords().compareTo("Enabled") == 0) {
            ((UBootModel)this.device).setConsoleText(super.timeStamp("Programming Configuration Words ..."));
            this.writeCommandConfig.executeChain();
            ((UBootModel)this.device).setConsoleText(super.timeStamp("Configuration Words Not Yet Supported"));
            ((UBootModel)this.device).setConsoleText(super.timeStamp("Configuration Words Programmed"));
        }
        if (!this.propI2cSkipChecksum) {
            ((UBootModel)this.device).setConsoleText(super.timeStamp("Retrieving Checksum ..."));
            this.checksumCommand.executeChain();
            ((UBootModel)this.device).setConsoleText(super.timeStamp("Checksum Matched"));
        }
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Resetting Device"));
        this.resetCommand.executeChain();
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Device Reset"));
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Device: " + ((UBootModel)this.device).getDeviceName() + " Bootloading Successful"));
    }

    @Override
    public void setDataModel(UBootModel model) {
        this.device = model;
    }

    @Override
    public UBootModel getDataModel() {
        return (UBootModel)this.device;
    }
}

