/*
 * Decompiled with CFR 0.152.
 */
package commands;

import com.microchip.mcu8.commandcore.ACommandBase;
import commands.ACommand;
import exceptionclasses.TransactionFailureException;
import i2cBootloaderController.CommandChecksumMCU32;
import i2cBootloaderController.CommandEraseDeviceMCU32;
import i2cBootloaderController.CommandReadVersionProtocolUARTMCU32;
import i2cBootloaderController.CommandResetDeviceMCU32;
import i2cBootloaderController.CommandWriteDeviceFlashMCU32;
import i2cBootloaderModel.BootloaderModel;
import i2cBootloaderModel.DeviceArchitecture;
import java.io.File;
import java.nio.charset.Charset;
import observers.ABootloaderObserver;
import readFileController.IFileIO;
import readFileController.TextFileIO;
import readFileModel.MCU32MemoryModel;
import readFileModel.MemoryModel;
import unified.bootloader.model32bit.UBootModel32bit;

public class BootloadDFUFED32bit
extends ACommand<UBootModel32bit> {
    protected String fileName;
    protected ACommandBase readVersionCommand;
    protected ACommandBase eraseDeviceCommand;
    protected ACommandBase checksumCommand;
    protected ACommandBase resetCommand;
    protected ACommandBase writeCommand;
    protected ACommandBase writeCommandEE;
    protected ACommandBase writeCommandConfig;
    IFileIO fileReader = new TextFileIO();
    protected MemoryModel deviceMemoryModel = new MemoryModel(DeviceArchitecture.PIC32);
    private static final MCU32MemoryModel mcu32DeviceMemoryModel = new MCU32MemoryModel();
    protected BootloaderModel model = new BootloaderModel();

    public BootloadDFUFED32bit() {
        this.retryCount = 5;
        this.timeout = 100;
    }

    public void createCommands() {
        try {
            this.readVersionCommand = new CommandReadVersionProtocolUARTMCU32(((UBootModel32bit)this.device).getInputStream(), ((UBootModel32bit)this.device).getOutputStream(), mcu32DeviceMemoryModel);
            this.initializeCommands(this.readVersionCommand, 5, 1000);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void createAllExceptReadVersion() {
        this.eraseDeviceCommand = new CommandEraseDeviceMCU32(((UBootModel32bit)this.device).getInputStream(), ((UBootModel32bit)this.device).getOutputStream(), mcu32DeviceMemoryModel);
        this.writeCommand = new CommandWriteDeviceFlashMCU32(((UBootModel32bit)this.device).getInputStream(), ((UBootModel32bit)this.device).getOutputStream(), mcu32DeviceMemoryModel);
        this.checksumCommand = new CommandChecksumMCU32(((UBootModel32bit)this.device).getInputStream(), ((UBootModel32bit)this.device).getOutputStream(), mcu32DeviceMemoryModel);
        this.resetCommand = new CommandResetDeviceMCU32(((UBootModel32bit)this.device).getInputStream(), ((UBootModel32bit)this.device).getOutputStream(), mcu32DeviceMemoryModel);
        this.initializeCommands(this.eraseDeviceCommand, 5, 10000);
        this.initializeCommands(this.writeCommand, 5, 1000);
        this.initializeCommands(this.checksumCommand, 5, 10000);
        this.initializeCommands(this.resetCommand, 5, 100);
    }

    public void setMemoryModelForDevice(MemoryModel deviceMemoryModel, int byteAlignedProgramMemorySize, int byteAlignedbootloaderOffset, int byteAlignedEraseRowSize, int setbyteAlignedeepromSize, int byteAlignedConfigMemoryOffset, int setbyteAlignedConfigSize, int byteAlignedeepromMemoryOffset, boolean skipErasedFlashLocationsFlag, int setbyteAlignedWriteBlockSize) {
        deviceMemoryModel.setbyteAlignedprogramMemorySize(byteAlignedProgramMemorySize);
        deviceMemoryModel.setbyteAlignedbootloaderOffset(byteAlignedbootloaderOffset);
        deviceMemoryModel.setbyteAlignedEraseRowSize(byteAlignedEraseRowSize);
        deviceMemoryModel.setbyteAlignedeepromSize(setbyteAlignedeepromSize);
        deviceMemoryModel.setbyteAlignedeepromMemoryOffset(byteAlignedeepromMemoryOffset);
        deviceMemoryModel.setskipErasedFlashLocationsFlag(skipErasedFlashLocationsFlag);
        deviceMemoryModel.setbyteAlignedWriteBlockSize(setbyteAlignedWriteBlockSize);
        deviceMemoryModel.setbyteAlignedconfigurationWordsOffset(byteAlignedConfigMemoryOffset);
        deviceMemoryModel.setbyteAlignedconfigurationWordsSize(setbyteAlignedConfigSize);
        deviceMemoryModel.createProgramMemoryMap();
        deviceMemoryModel.createEEPROMMap();
        deviceMemoryModel.createConfigurationWordsMap();
    }

    public void setMemoryModelForDevice(MCU32MemoryModel mcu32DeviceMemoryModel) {
        mcu32DeviceMemoryModel.createProgramMemoryMap();
    }

    public void initializeCommands(ACommandBase command, int retryCount, int timeout) {
        command.setTimeout(timeout);
        command.setRetryCount(retryCount);
        command.setBootloaderModel(this.model);
    }

    protected void setupDevice() {
        ((UBootModel32bit)this.device).setConsoleText(super.timeStamp("Device: " + ((UBootModel32bit)this.device).getDeviceName() + " Bootloading started"));
        this.deviceMemoryModel = new MemoryModel(DeviceArchitecture.PIC32);
        this.setMemoryModelForDevice(this.deviceMemoryModel, 65536, 768, 64, 256, 0x300000, 14, 0xF00000, false, 64);
        this.setMemoryModelForDevice(this.deviceMemoryModel, Integer.parseInt(((UBootModel32bit)this.device).ubootPojo32Bit.getProgramMemorySize().replace("0x", ""), 16), Integer.parseInt(((UBootModel32bit)this.device).ubootPojo32Bit.getBootloaderOffset().replace("0x", ""), 16), Integer.parseInt(((UBootModel32bit)this.device).ubootPojo32Bit.getByteAlignedEraseRowSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel32bit)this.device).ubootPojo32Bit.getSetbyteAlignedeepromSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel32bit)this.device).ubootPojo32Bit.getByteAlignedConfigMemoryOffset().replace("0x", ""), 16), Integer.parseInt(((UBootModel32bit)this.device).ubootPojo32Bit.getSetbyteAlignedConfigSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel32bit)this.device).ubootPojo32Bit.getByteAlignedeepromMemoryOffset().replace("0x", ""), 16), false, Integer.parseInt(((UBootModel32bit)this.device).ubootPojo32Bit.getWriteBlockSize().replace("0x", ""), 16));
        this.setMemoryModelForDevice(mcu32DeviceMemoryModel);
        this.createCommands();
        this.model.addPropertyChangeListener(new ABootloaderObserver(){

            @Override
            public void handleEvent(BootloaderModel value, String whatChanged, String changed) {
                assert (whatChanged.equals("Version"));
                byte[] changedBytes = changed.getBytes(Charset.forName("ISO-8859-1"));
                String fs = "%s)        BLD_VER: %s          Device ID: 0x%02X           FL_ER: %s           FL_WR: %s           User ID: 0x%04X";
                String version = String.format(fs, ((UBootModel32bit)BootloadDFUFED32bit.this.device).getDeviceName(), changedBytes[10], changedBytes[17] << 8 & 0xFFFF | changedBytes[16] & 0xFF, changedBytes[20], changedBytes[21], changedBytes[25] << 24 & 0xFFFFFFFF | changedBytes[24] << 16 & 0xFFFFFF | changedBytes[23] << 8 & 0xFFFF | changedBytes[22] & 0xFF);
                ((UBootModel32bit)BootloadDFUFED32bit.this.device).setVersion(version);
                System.out.format("%s: %s%n", whatChanged, version);
            }
        });
        this.model.addConsolePropertyChangeListener(new ABootloaderObserver(){

            @Override
            public void handleEvent(BootloaderModel value, String whatChanged, String changed) {
                ((UBootModel32bit)BootloadDFUFED32bit.this.device).setProgress(changed);
            }
        });
    }

    @Override
    public void execute() throws TransactionFailureException {
        this.setupDevice();
        this.fileReader.setMemoryModel(mcu32DeviceMemoryModel);
        this.fileName = ((UBootModel32bit)this.device).ubootPojo32Bit.getFileName();
        if (this.fileName == null || this.fileName.isEmpty()) {
            System.out.println("Invalid File");
            throw new TransactionFailureException("Hex File is Invalid");
        }
        File fp = this.fileReader.fopen(this.fileName);
        this.fileReader.fread(fp);
        ((UBootModel32bit)this.device).setConsoleText(super.timeStamp("Reading Version ..."));
        this.readVersionCommand.executeChain();
        ((UBootModel32bit)this.device).setConsoleText(super.timeStamp("Bootloader Version Read Successful"));
        this.createAllExceptReadVersion();
        ((UBootModel32bit)this.device).setConsoleText(super.timeStamp("Erasing Device ..."));
        this.eraseDeviceCommand.executeChain();
        ((UBootModel32bit)this.device).setConsoleText(super.timeStamp("Erase Successful"));
        ((UBootModel32bit)this.device).setConsoleText(super.timeStamp("Programming Flash ..."));
        this.writeCommand.executeChain();
        ((UBootModel32bit)this.device).setConsoleText(super.timeStamp("Flashed Programmed"));
        ((UBootModel32bit)this.device).setConsoleText(super.timeStamp("Resetting Device"));
        this.resetCommand.executeChain();
        ((UBootModel32bit)this.device).setConsoleText(super.timeStamp("Device Reset"));
        ((UBootModel32bit)this.device).setConsoleText(super.timeStamp("Device: Bootloaded Successful"));
    }

    @Override
    public void setDataModel(UBootModel32bit model) {
        this.device = model;
    }

    @Override
    public UBootModel32bit getDataModel() {
        return (UBootModel32bit)this.device;
    }
}

