/*
 * Decompiled with CFR 0.152.
 */
package commands;

import com.microchip.mcu8.commandcore.ACommandBase;
import commands.ACommand;
import exceptionclasses.TransactionFailureException;
import i2cBootloaderController.CommandChecksumUART;
import i2cBootloaderController.CommandEraseDeviceUART;
import i2cBootloaderController.CommandReadVersionProtocolUART;
import i2cBootloaderController.CommandResetDeviceUART;
import i2cBootloaderController.CommandWriteDeviceConfigUART;
import i2cBootloaderController.CommandWriteDeviceEEUART;
import i2cBootloaderController.CommandWriteDeviceFlashUART;
import i2cBootloaderModel.BootloaderModel;
import i2cBootloaderModel.DeviceArchitecture;
import java.io.File;
import java.nio.charset.Charset;
import observers.ABootloaderObserver;
import readFileController.HexFileIO;
import readFileController.IFileIO;
import readFileModel.MCU32MemoryModel;
import readFileModel.MemoryModel;
import unified.bootloader.model.UBootModel;

public class BootloadDFUFED
extends ACommand<UBootModel> {
    protected String fileName;
    protected ACommandBase readVersionCommand;
    protected ACommandBase eraseDeviceCommand;
    protected ACommandBase checksumCommand;
    protected ACommandBase resetCommand;
    protected ACommandBase writeCommand;
    protected ACommandBase writeCommandEE;
    protected ACommandBase writeCommandConfig;
    IFileIO fileReader = new HexFileIO();
    protected MemoryModel deviceMemoryModel = new MemoryModel(DeviceArchitecture.PIC18);
    protected BootloaderModel model = new BootloaderModel();

    public BootloadDFUFED() {
        this.retryCount = 5;
        this.timeout = 100;
    }

    public void createCommands() {
        this.readVersionCommand = new CommandReadVersionProtocolUART(((UBootModel)this.device).getInputStream(), ((UBootModel)this.device).getOutputStream(), this.deviceMemoryModel);
        this.initializeCommands(this.readVersionCommand, 5, 1000);
    }

    public void createAllExceptReadVersion() {
        this.eraseDeviceCommand = new CommandEraseDeviceUART(((UBootModel)this.device).getInputStream(), ((UBootModel)this.device).getOutputStream(), this.deviceMemoryModel);
        this.checksumCommand = new CommandChecksumUART(((UBootModel)this.device).getInputStream(), ((UBootModel)this.device).getOutputStream(), this.deviceMemoryModel);
        this.resetCommand = new CommandResetDeviceUART(((UBootModel)this.device).getInputStream(), ((UBootModel)this.device).getOutputStream(), this.deviceMemoryModel);
        this.writeCommand = new CommandWriteDeviceFlashUART(((UBootModel)this.device).getInputStream(), ((UBootModel)this.device).getOutputStream(), this.deviceMemoryModel);
        this.writeCommandEE = new CommandWriteDeviceEEUART(((UBootModel)this.device).getInputStream(), ((UBootModel)this.device).getOutputStream(), this.deviceMemoryModel);
        this.writeCommandConfig = new CommandWriteDeviceConfigUART(((UBootModel)this.device).getInputStream(), ((UBootModel)this.device).getOutputStream(), this.deviceMemoryModel);
        this.initializeCommands(this.eraseDeviceCommand, 5, 10000);
        this.initializeCommands(this.checksumCommand, 5, 10000);
        this.initializeCommands(this.resetCommand, 5, 100);
        this.initializeCommands(this.writeCommand, 5, 1000);
        this.initializeCommands(this.writeCommandConfig, 5, 1000);
        this.initializeCommands(this.writeCommandEE, 5, 1000);
    }

    public void setMemoryModelForDevice(MemoryModel deviceMemoryModel, int byteAlignedProgramMemorySize, int byteAlignedbootloaderOffset, int byteAlignedEraseRowSize, int setbyteAlignedeepromSize, int byteAlignedConfigMemoryOffset, int setbyteAlignedConfigSize, int byteAlignedeepromMemoryOffset, boolean skipErasedFlashLocationsFlag, int setbyteAlignedWriteBlockSize) {
        deviceMemoryModel.setbyteAlignedprogramMemorySize(byteAlignedProgramMemorySize);
        deviceMemoryModel.setbyteAlignedbootloaderOffset(byteAlignedbootloaderOffset);
        deviceMemoryModel.setbyteAlignedEraseRowSize(byteAlignedEraseRowSize);
        deviceMemoryModel.setbyteAlignedeepromSize(setbyteAlignedeepromSize);
        deviceMemoryModel.setbyteAlignedeepromMemoryOffset(byteAlignedeepromMemoryOffset);
        deviceMemoryModel.setskipErasedFlashLocationsFlag(skipErasedFlashLocationsFlag);
        deviceMemoryModel.setbyteAlignedWriteBlockSize(setbyteAlignedWriteBlockSize);
        deviceMemoryModel.setbyteAlignedconfigurationWordsOffset(byteAlignedConfigMemoryOffset);
        deviceMemoryModel.setbyteAlignedconfigurationWordsSize(setbyteAlignedConfigSize);
        deviceMemoryModel.createProgramMemoryMap();
        deviceMemoryModel.createEEPROMMap();
        deviceMemoryModel.createConfigurationWordsMap();
    }

    public void setMemoryModelForDevice(MCU32MemoryModel mcu32DeviceMemoryModel) {
        mcu32DeviceMemoryModel.createProgramMemoryMap();
    }

    public void initializeCommands(ACommandBase command, int retryCount, int timeout) {
        command.setTimeout(timeout);
        command.setRetryCount(retryCount);
        command.setBootloaderModel(this.model);
    }

    protected void setupDevice() {
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Device: " + ((UBootModel)this.device).getDeviceName() + " Bootloading started"));
        this.deviceMemoryModel = ((UBootModel)this.device).ubootPojo.getDeviceArchitecture().compareTo("PIC16") == 0 ? new MemoryModel(DeviceArchitecture.PIC16) : new MemoryModel(DeviceArchitecture.PIC18);
        this.setMemoryModelForDevice(this.deviceMemoryModel, Integer.parseInt(((UBootModel)this.device).ubootPojo.getProgramMemorySize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getBootloaderOffset().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedEraseRowSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getSetbyteAlignedeepromSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedConfigMemoryOffset().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getSetbyteAlignedConfigSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedeepromMemoryOffset().replace("0x", ""), 16), true, Integer.parseInt(((UBootModel)this.device).ubootPojo.getWriteBlockSize().replace("0x", ""), 16));
        this.createCommands();
        this.model.addPropertyChangeListener(new ABootloaderObserver(){

            @Override
            public void handleEvent(BootloaderModel value, String whatChanged, String changed) {
                assert (whatChanged.equals("Version"));
                byte[] changedBytes = changed.getBytes(Charset.forName("ISO-8859-1"));
                String fs = "%s)        BLD_VER: %s          Device ID: 0x%02X           FL_ER: %s           FL_WR: %s           User ID: 0x%04X";
                String version = String.format(fs, ((UBootModel)BootloadDFUFED.this.device).getDeviceName(), changedBytes[10], changedBytes[17] << 8 & 0xFFFF | changedBytes[16] & 0xFF, changedBytes[20], changedBytes[21], changedBytes[25] << 24 & 0xFFFFFFFF | changedBytes[24] << 16 & 0xFFFFFF | changedBytes[23] << 8 & 0xFFFF | changedBytes[22] & 0xFF);
                ((UBootModel)BootloadDFUFED.this.device).setVersion(version);
                System.out.format("%s: %s%n", whatChanged, version);
            }
        });
        this.model.addConsolePropertyChangeListener(new ABootloaderObserver(){

            @Override
            public void handleEvent(BootloaderModel value, String whatChanged, String changed) {
                ((UBootModel)BootloadDFUFED.this.device).setProgress(changed);
            }
        });
    }

    @Override
    public void execute() throws TransactionFailureException {
        this.setupDevice();
        this.fileReader.setMemoryModel(this.deviceMemoryModel);
        this.fileName = ((UBootModel)this.device).ubootPojo.getFileName();
        if (this.fileName == null || this.fileName.isEmpty()) {
            System.out.println("Invalid File");
            throw new TransactionFailureException("Hex File is Invalid");
        }
        File fp = this.fileReader.fopen(this.fileName);
        this.fileReader.fread(fp);
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Reading Version ..."));
        this.readVersionCommand.executeChain();
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Bootloader Version Read Successful"));
        if (this.deviceMemoryModel.deviceFamily.equals((Object)DeviceArchitecture.PIC16)) {
            String parsedEraseSize = "0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_WR") + 7, ((UBootModel)this.device).getVersion().indexOf("User ID") - 11).toString()));
            Integer convertedEraseValue = Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedEraseRowSize().replace("0x", ""), 16);
            String parsedWriteSize = "0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_WR") + 7, ((UBootModel)this.device).getVersion().indexOf("User ID") - 11).toString()));
            Integer convertedWriteValue = Integer.parseInt(((UBootModel)this.device).ubootPojo.getWriteBlockSize().replace("0x", ""), 16);
            ((UBootModel)this.device).ubootPojo.setWriteBlockSize(parsedWriteSize);
            convertedWriteValue = convertedWriteValue * 2;
            this.deviceMemoryModel.setbyteAlignedWriteBlockSize(convertedWriteValue);
            ((UBootModel)this.device).ubootPojo.setByteAlignedEraseRowSize(parsedEraseSize);
            convertedEraseValue = convertedEraseValue * 2;
            this.deviceMemoryModel.setbyteAlignedEraseRowSize(convertedEraseValue);
        } else {
            ((UBootModel)this.device).ubootPojo.setByteAlignedEraseRowSize("0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_ER") + 7, ((UBootModel)this.device).getVersion().indexOf("FL_WR") - 11).toString())));
            this.deviceMemoryModel.setbyteAlignedEraseRowSize(Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedEraseRowSize().replace("0x", ""), 16));
            ((UBootModel)this.device).ubootPojo.setWriteBlockSize("0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_WR") + 7, ((UBootModel)this.device).getVersion().indexOf("User ID") - 11).toString())));
            this.deviceMemoryModel.setbyteAlignedWriteBlockSize(Integer.parseInt(((UBootModel)this.device).ubootPojo.getWriteBlockSize().replace("0x", ""), 16));
        }
        this.createAllExceptReadVersion();
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Erasing Device ..."));
        this.eraseDeviceCommand.executeChain();
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Erase Successful"));
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Programming Flash ..."));
        this.writeCommand.executeChain();
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Flashed Programmed"));
        if (((UBootModel)this.device).ubootPojo.getProgramEEData().compareTo("Enabled") == 0) {
            ((UBootModel)this.device).setConsoleText(super.timeStamp("Programming EEData ..."));
            this.writeCommandEE.executeChain();
            ((UBootModel)this.device).setConsoleText(super.timeStamp("EEData Programmed"));
        }
        if (((UBootModel)this.device).ubootPojo.getProgramConfigurationWords().compareTo("Enabled") == 0) {
            ((UBootModel)this.device).setConsoleText(super.timeStamp("Programming Configuration Words ..."));
            this.writeCommandConfig.executeChain();
            ((UBootModel)this.device).setConsoleText(super.timeStamp("Configuration Words Programmed"));
        }
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Retrieving Checksum ..."));
        this.checksumCommand.executeChain();
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Checksum Matched"));
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Resetting Device"));
        this.resetCommand.executeChain();
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Device Reset"));
        ((UBootModel)this.device).setConsoleText(super.timeStamp("Device: " + ((UBootModel)this.device).getDeviceName() + " Bootloading Successful"));
    }

    @Override
    public void setDataModel(UBootModel model) {
        this.device = model;
    }

    @Override
    public UBootModel getDataModel() {
        return (UBootModel)this.device;
    }
}

