/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.mcu8.commandcore;

import com.microchip.mcu8.commandcore.ICommandBase;
import com.microchip.scf.softwarelibraryinterfaces.i2c.I2CSoftwareLibraryCommunicationsInterface;
import exceptionclasses.TransactionFailureException;
import exceptionclasses.ValidationException;
import i2cBootloaderModel.BootloaderModel;
import i2cBootloaderModel.DeviceArchitecture;
import java.io.InputStream;
import java.io.OutputStream;
import packetprocessor.IPacketProcessor;
import packetprocessor.PacketProcessorReadData;
import packetprocessor.PacketProcessorReadDataMCU32;
import readFileModel.MCU32MemoryModel;
import readFileModel.MemoryModel;

public abstract class ACommandBaseI2C
implements ICommandBase {
    protected int timeOut = 100;
    protected int retryCount = 5;
    protected PacketProcessorReadData processReadData;
    protected PacketProcessorReadDataMCU32 processReadDataMCU32;
    protected IPacketProcessor commandSpecificPacketProcessor;
    public I2CSoftwareLibraryCommunicationsInterface i2cInterface = null;
    public BootloaderModel modelBootloader = null;
    public MemoryModel deviceMemoryModel = null;
    public InputStream bootloaderInputStream = null;
    public OutputStream bootloaderOutputStream = null;
    public MCU32MemoryModel mcu32DeviceMemoryModel = null;
    ACommandBaseI2C nextCommand;

    public abstract int validateLevel2() throws ValidationException;

    public abstract int process() throws TransactionFailureException;

    protected abstract void setPacketProcessorToUse();

    public void setProcessReadData() {
        this.processReadData = new PacketProcessorReadData();
    }

    public void setProcessReadDataMCU32() {
        this.processReadDataMCU32 = new PacketProcessorReadDataMCU32();
    }

    public void setNextCommand(ACommandBaseI2C nextCommand) {
        this.nextCommand = nextCommand;
    }

    public void executeChain() throws TransactionFailureException {
        this.execute();
        if (this.nextCommand != null) {
            this.nextCommand.executeChain();
        }
    }

    @Override
    public int execute() throws TransactionFailureException {
        return this.process();
    }

    public void setBootloaderModel(BootloaderModel model) {
        this.modelBootloader = model;
    }

    @Override
    public void setMemoryModel(MemoryModel deviceMemoryModel) {
        this.deviceMemoryModel = deviceMemoryModel;
    }

    @Override
    public void setDeviceArchitecture(DeviceArchitecture whichDeviceFamily) {
        this.deviceMemoryModel.deviceFamily = whichDeviceFamily;
    }

    @Override
    public void setTimeout(int timeOut) {
        this.timeOut = timeOut;
    }

    @Override
    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setI2CInteface(I2CSoftwareLibraryCommunicationsInterface passedInterface) {
        this.i2cInterface = passedInterface;
    }

    public I2CSoftwareLibraryCommunicationsInterface getI2CInteface() {
        return this.i2cInterface;
    }
}

