/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.intelhex;

public enum HexRecordType {
    DATA(0),
    EOF(1),
    EXTENDED_SEG_ADDR(2),
    EXTENDED_LINEAR_ADDR(4);

    private static final int TYPE_HIGH_NIBBLE = 7;
    private static final int TYPE_LOW_NIBBLE = 8;
    private int type;

    private HexRecordType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public static HexRecordType getRecordType(String record) {
        char[] charBuffer = record.toCharArray();
        if (charBuffer[0] != ':') {
            return null;
        }
        int type = (charBuffer[7] & 0xF) << 4;
        type += charBuffer[8] & 0xF;
        HexRecordType[] recordTypes = HexRecordType.values();
        for (int i = 0; i < recordTypes.length; ++i) {
            if (recordTypes[i].getType() != type) continue;
            return recordTypes[i];
        }
        return null;
    }
}

