/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.intelhex;

import com.microchip.helper.Helper;
import com.microchip.intelhex.HexException;
import com.microchip.intelhex.HexRecord;
import com.microchip.intelhex.HexRecordType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class HexFile {
    private FileInputStream inputStream;
    private InputStreamReader inputReader;
    private BufferedReader bufferReader;

    public HexFile(File hexFile) throws IOException {
        this.inputStream = new FileInputStream(hexFile);
        this.inputReader = new InputStreamReader(this.inputStream);
        this.bufferReader = new BufferedReader(this.inputReader);
    }

    public void close() throws IOException {
        this.bufferReader.close();
        this.inputReader.close();
        this.inputStream.close();
    }

    public String getNextRecord() throws IOException {
        return this.bufferReader.readLine();
    }

    public static byte[] getData(InputStream hexInStream, long startingAddress, int range) throws IOException, HexException {
        HexRecord hexRecord;
        HexRecordType recordType;
        String hexRecordString;
        byte[] data = new byte[range];
        InputStreamReader inputReader = new InputStreamReader(hexInStream);
        BufferedReader bufferReader = new BufferedReader(inputReader);
        long endingAddress = startingAddress + (long)range;
        long extendedAddress = 0L;
        int dataIdx = 0;
        block4: while ((hexRecordString = bufferReader.readLine()) != null && (recordType = (hexRecord = new HexRecord(hexRecordString)).getRecordType()) != HexRecordType.EOF && range > 0) {
            switch (recordType) {
                case DATA: {
                    long startingDataAddress = (extendedAddress & 0xFFFFFFFFFFFF0000L) + (long)hexRecord.getAddress();
                    long endingDataAddress = startingDataAddress + (long)hexRecord.getDataLength();
                    int copySize = 0;
                    int recordDataIdx = 0;
                    if (startingDataAddress < startingAddress && endingDataAddress > startingAddress && endingDataAddress < endingAddress) {
                        copySize = (int)(endingDataAddress - startingAddress);
                        recordDataIdx = hexRecord.getDataLength() - copySize;
                    }
                    if (startingDataAddress >= startingAddress && endingDataAddress < endingAddress) {
                        copySize = hexRecord.getDataLength();
                    }
                    if (startingDataAddress >= startingAddress && endingDataAddress >= endingAddress) {
                        copySize = (int)(endingAddress - startingDataAddress);
                    }
                    if (copySize <= 0) continue block4;
                    if (copySize > range) {
                        copySize = range;
                    }
                    byte[] recordData = hexRecord.getData();
                    System.arraycopy(recordData, recordDataIdx, data, dataIdx, copySize);
                    range -= copySize;
                    dataIdx += copySize;
                    continue block4;
                }
                case EXTENDED_LINEAR_ADDR: {
                    extendedAddress = Helper.getShort(hexRecord.getData(), 0, false);
                    extendedAddress &= 0xFFFFL;
                    extendedAddress <<= 16;
                    continue block4;
                }
            }
            bufferReader.close();
            inputReader.close();
            throw new HexException("Extended Segmented Address Records are not supported");
        }
        return data;
    }

    public static byte[] getData(File hexFile, long startingAddress, int range) throws IOException, HexException {
        FileInputStream fileInputStream = new FileInputStream(hexFile);
        byte[] data = HexFile.getData(fileInputStream, startingAddress, range);
        fileInputStream.close();
        return data;
    }
}

