/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.intelhex;

import com.microchip.helper.Helper;
import com.microchip.intelhex.HexAddressRange;
import com.microchip.intelhex.HexException;
import com.microchip.intelhex.HexRecord;
import com.microchip.intelhex.HexRecordType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;

public class HexAddressRangeList {
    public static HexAddressRange[] getList(InputStream hexFileInStream) throws IOException, HexException {
        String hexRecordString;
        InputStreamReader inputReader = new InputStreamReader(hexFileInStream);
        BufferedReader bufferReader = new BufferedReader(inputReader);
        LinkedList<HexAddressRange> rangeList = new LinkedList<HexAddressRange>();
        long extendedAddress = 0L;
        long startingAddress = 0L;
        long range = 0L;
        block4: while ((hexRecordString = bufferReader.readLine()) != null) {
            HexRecord hexRecord = new HexRecord(hexRecordString);
            HexRecordType recordType = hexRecord.getRecordType();
            if (recordType == HexRecordType.EOF) {
                if (range <= 0L) break;
                HexAddressRange addressRange = new HexAddressRange(startingAddress, range);
                rangeList.add(addressRange);
                range = 0L;
                break;
            }
            switch (recordType) {
                case DATA: {
                    long addressOffset = (extendedAddress & 0xFFFFFFFFFFFF0000L) + ((long)hexRecord.getAddress() & 0xFFFFL);
                    if (startingAddress + range != addressOffset) {
                        if (range > 0L) {
                            HexAddressRange addressRange = new HexAddressRange(startingAddress, range);
                            rangeList.add(addressRange);
                        }
                        startingAddress = addressOffset;
                        range = hexRecord.getDataLength();
                        continue block4;
                    }
                    range += (long)hexRecord.getDataLength() & 0xFFL;
                    continue block4;
                }
                case EXTENDED_LINEAR_ADDR: {
                    extendedAddress = Helper.getShort(hexRecord.getData(), 0, false);
                    extendedAddress &= 0xFFFFL;
                    extendedAddress <<= 16;
                    continue block4;
                }
            }
            bufferReader.close();
            inputReader.close();
            throw new HexException("Extended Segmented Address Records are not supported");
        }
        if (range > 0L) {
            HexAddressRange addressRange = new HexAddressRange(startingAddress, range);
            rangeList.add(addressRange);
        }
        System.gc();
        HexAddressRange[] addressRanges = new HexAddressRange[rangeList.size()];
        for (int i = 0; i < addressRanges.length; ++i) {
            addressRanges[i] = (HexAddressRange)rangeList.remove();
        }
        return addressRanges;
    }

    public static HexAddressRange[] getList(File hexFile) throws IOException, HexException {
        FileInputStream inputStream = new FileInputStream(hexFile);
        HexAddressRange[] hexList = HexAddressRangeList.getList(inputStream);
        inputStream.close();
        return hexList;
    }
}

