/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.core.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class TimeSliceDisplay {
    public static String getDoubleToStringTime(double time, int precision) {
        String units;
        int counter;
        if (time > 0.0) {
            double time2 = time;
            counter = 0;
            while (time2 < 1.0) {
                time2 *= 10.0;
                ++counter;
            }
        } else {
            counter = 7;
        }
        if (counter == 0) {
            time = TimeSliceDisplay.roundNDecimals(time, precision);
            units = " s";
        } else if (counter > 6) {
            time = TimeSliceDisplay.roundNDecimals(time * 1.0E9, precision);
            units = " ns";
        } else if (counter > 3) {
            time = TimeSliceDisplay.roundNDecimals(time * 1000000.0, precision);
            units = " us";
        } else {
            time = TimeSliceDisplay.roundNDecimals(time * 1000.0, precision);
            units = " ms";
        }
        String returnValue = time + units;
        return returnValue;
    }

    public static double roundNDecimals(double d, int precision) {
        String precisionFormat = "#.#";
        while (--precision > 0) {
            precisionFormat = precisionFormat + "#";
        }
        DecimalFormat df = new DecimalFormat(precisionFormat);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        return Double.valueOf(df.format(d));
    }

    public static double getStringToDoubleTimeSecs(String str, int precision) {
        double time;
        int index = str.indexOf(32);
        if (index >= 0) {
            String suburlModuleTadValueString = str.substring(0, index).trim();
            time = Double.parseDouble(suburlModuleTadValueString);
            time = str.contains("ms") ? TimeSliceDisplay.roundNDecimals(time / 1000.0, precision) : (str.contains("us") ? TimeSliceDisplay.roundNDecimals(time / 1000000.0, precision) : (str.contains("ns") ? TimeSliceDisplay.roundNDecimals(time / 1.0E9, precision) : (str.contains("s") ? TimeSliceDisplay.roundNDecimals(time, precision) : 0.0)));
        } else {
            time = 0.0;
        }
        return time;
    }
}

