/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.core.util;

import com.microchip.core.util.HexValidator;
import java.math.BigInteger;
import java.util.regex.Matcher;

public class NumericalValidator
extends HexValidator {
    @Override
    public String validate(String input) {
        Matcher hexMatcher = hexPattern.matcher(input = input.toLowerCase());
        if (hexMatcher.matches()) {
            this.currentUnits = HexValidator.Units.HEX;
            BigInteger integer = new BigInteger(hexMatcher.group(1), 16);
            if (integer.intValue() > this.validBitCount) {
                System.out.println("Input " + integer + "has too many bits (" + this.validBitCount + "): " + integer.bitCount());
                return null;
            }
            return integer.toString();
        }
        Matcher decimalMatcher = decimalPattern.matcher(input);
        if (decimalMatcher.matches()) {
            this.currentUnits = HexValidator.Units.DECIMAL;
            BigInteger integer = new BigInteger(decimalMatcher.group(1));
            if (integer.intValue() > this.validBitCount) {
                System.out.println("Input " + integer + "has too many bits (" + this.validBitCount + "): " + integer.bitCount());
                return null;
            }
            return integer.toString();
        }
        System.out.println("Input was not an unsigned decimal or hexadecimal number: \"" + input + "\"");
        return null;
    }
}

