/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.core.util;

import com.microchip.core.util.AValidator;
import com.microchip.core.util.IValidatorComparator;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HexValidator
extends AValidator
implements IValidatorComparator {
    protected static final String HEX_REGEX = "0x([\\da-f,A-F]+)";
    protected static final String DECIMAL_REGEX = "[+-]?(\\d+)";
    protected static final Pattern hexPattern = Pattern.compile("^\\s*0x([\\da-f,A-F]+)\\s*$");
    protected static final Pattern decimalPattern = Pattern.compile("^\\s*([+-]?(\\d+))\\s*$");
    protected Units setUnits;
    protected Units currentUnits = Units.HEX;
    protected int caretPosition = -1;
    protected Integer validBitCount = 2;

    public HexValidator() {
    }

    public HexValidator(Integer validBitSize) {
        this.validBitCount = validBitSize;
    }

    public HexValidator(String validBitSize) {
        if (validBitSize != null) {
            try {
                this.validBitCount = Integer.parseInt(validBitSize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public String validate(String input) {
        Matcher hexMatcher = hexPattern.matcher(input = input.toLowerCase());
        if (hexMatcher.matches()) {
            this.currentUnits = Units.HEX;
            BigInteger integer = new BigInteger(hexMatcher.group(1), 16);
            if (integer.bitLength() > this.validBitCount) {
                System.out.println("Input " + integer + "has too many bits (" + this.validBitCount + "): " + integer.bitCount());
                return null;
            }
            return integer.toString();
        }
        Matcher decimalMatcher = decimalPattern.matcher(input);
        if (decimalMatcher.matches()) {
            this.currentUnits = Units.DECIMAL;
            BigInteger integer = new BigInteger(decimalMatcher.group(1));
            if (integer.bitLength() > this.validBitCount) {
                System.out.println("Input " + integer + "has too many bits (" + this.validBitCount + "): " + integer.bitCount());
                return null;
            }
            return integer.toString();
        }
        System.out.println("Input was not an unsigned decimal or hexadecimal number: \"" + input + "\"");
        return null;
    }

    @Override
    public String display(String value) {
        String displayString;
        if (value == null) {
            return null;
        }
        if (this.setUnits != null) {
            this.currentUnits = this.setUnits;
        }
        try {
            switch (this.currentUnits) {
                case DECIMAL: {
                    BigInteger integer = new BigInteger(value);
                    displayString = integer.toString();
                    break;
                }
                case HEX: {
                    BigInteger integer = new BigInteger(value);
                    displayString = "0x" + integer.toString(16).toUpperCase();
                    break;
                }
                default: {
                    System.out.println("Unexpected units: " + this.setUnits.name());
                    displayString = value;
                    break;
                }
            }
        }
        catch (NumberFormatException ex) {
            System.out.println("Invalid value (" + value + ") for hexadecimal field");
            displayString = value;
        }
        this.caretPosition = displayString.length();
        return displayString;
    }

    @Override
    public int positionCaret() {
        return this.caretPosition;
    }

    @Override
    public Integer compareTo(String s1, String s2) {
        String n1 = this.validate(s1);
        String n2 = this.validate(s2);
        if (n1 == null) {
            return null;
        }
        if (n2 == null) {
            return null;
        }
        BigInteger d1 = new BigInteger(n1);
        BigInteger d2 = new BigInteger(n2);
        return d1.compareTo(d2);
    }

    public void setUnits(Units units) {
        this.setUnits = units;
    }

    public void setValidCount(Integer bitSize) {
        this.validBitCount = bitSize;
    }

    public static enum Units {
        DECIMAL,
        HEX;

    }
}

