#include "./wxBackgroundBitmap.h"

wxBackgroundBitmap::wxBackgroundBitmap(const wxBitmap &B, const wxWindow *parent) : m_bitmap( B), m_p_parent( parent), wxEvtHandler() {
}

bool wxBackgroundBitmap::ProcessEvent(wxEvent &Event) {
    bool ret= Inherited::ProcessEvent( Event);
    wxEventType event_type= Event.GetEventType();
    if ( event_type== wxEVT_ERASE_BACKGROUND) {
        if ( this->m_p_parent== 0)
            return ret;
        wxEraseEvent &EraseEvent = dynamic_cast<wxEraseEvent &>(Event);
        wxDC *dc= EraseEvent.GetDC();
        dc->DrawBitmap( this->m_bitmap, this->m_p_parent->GetClientSize().GetWidth()- this->m_bitmap.GetWidth(), 0, true);
        return true;
    }
    return ret;
}
