/***************************************************************
 * Name:      SettingsDialogImpl.cpp
 * Purpose:   Code for SettingsDialogImpl class
 * Author:    NDA (nicola.dellamico@ndatech.it)
 * Created:   2008-07-29
 * Copyright: CAEN S.p.A (www.caen.it)
 * License:
 **************************************************************/
#ifdef WX_PRECOMP
#include "wx_pch.h"
#endif
#include "SettingsDialogImpl.h"

SettingsDialogImpl::SettingsDialogImpl(wxWindow* parent)
        : SettingsDialog( parent) {
    // Read configuration settings and setup controls
    if ( !this->m_application_settings.ReadSettings()) {
        wxFAIL_MSG( _("SettingsDialogImpl::SettingsDialogImpl: Errors while reading application settings"));
    }
	this->m_board_type_choice->SetSelection( this->m_application_settings.m_board_type);
    this->m_device_name_textCtrl->SetValue( this->m_application_settings.m_communication_device_id);
    this->m_first_visible_channel_spinCtrl->SetValue( this->m_application_settings.m_first_visible_channel);
    this->m_last_visible_channel_spinCtrl->SetValue( this->m_application_settings.m_last_visible_channel);
    this->m_module_address_spinCtrl->SetValue( this->m_application_settings.m_default_module_address);
	this->m_mux_out_spinCtrl->SetValue( this->m_application_settings.m_default_mux_out);
    this->m_logger_enabled_checkBox->SetValue( this->m_application_settings.m_is_logger_enabled);
    this->m_logger_visible_checkBox->SetValue( this->m_application_settings.m_is_logger_visible);

}

SettingsDialogImpl::~SettingsDialogImpl() {
    //dtor
}

void SettingsDialogImpl::OnOkClicked( wxCommandEvent& event) {
    // Validity checks
    // Communication
    if ( this->m_device_name_textCtrl->GetValue( ).Trim().IsEmpty()) {
        wxMessageDialog dlg( this, _("Invalid device name"), ("Error"), wxOK| wxICON_ERROR);
        dlg.ShowModal();
        return;
    }
    // Board
    if( this->m_application_settings.m_first_visible_channel> this->m_application_settings.m_last_visible_channel) {
        wxMessageDialog dlg( this, _("The first visible channel must be lesser or equal to last visible channel"), ("Error"), wxOK| wxICON_ERROR);
        dlg.ShowModal();
        return;
    }
	this->m_application_settings.m_board_type= (N1568_BOARD_TYPE)this->m_board_type_choice->GetSelection( );
    this->m_application_settings.m_communication_device_id= this->m_device_name_textCtrl->GetValue( ).Trim();
    this->m_application_settings.m_first_visible_channel= this->m_first_visible_channel_spinCtrl->GetValue( );
    this->m_application_settings.m_last_visible_channel= this->m_last_visible_channel_spinCtrl->GetValue( );
    this->m_application_settings.m_default_module_address= this->m_module_address_spinCtrl->GetValue( );
    this->m_application_settings.m_default_mux_out= this->m_mux_out_spinCtrl->GetValue( );
    this->m_application_settings.m_is_logger_enabled= this->m_logger_enabled_checkBox->GetValue( );
    this->m_application_settings.m_is_logger_visible= this->m_logger_visible_checkBox->GetValue( );
    if ( !this->m_application_settings.WriteSettings()) {
        wxFAIL_MSG( _("SettingsDialogImpl::SettingsDialogImpl: Errors while writing application settings"));
    }
    event.Skip();
}
