/***************************************************************
 * Name:      N1568DemoMain.h
 * Purpose:   Defines Application Frame
 * Author:    NDA (nicola.dellamico@ndatech.it)
 * Created:   2008-07-29
 * Copyright: CAEN S.p.A (www.caen.it)
 * License:
 **************************************************************/

#ifndef N1568DEMOMAIN_H
#define N1568DEMOMAIN_H

#include "N1568DemoApp.h"
#include "GUIFrame.h"
#include "ApplicationSettings.h"
#include "common.h"

class wxDateTime;
class ChannelPanelImpl;
class AllChannelPanelImpl;

typedef enum _STATUS_BAR_PANE {
    SBP_SW_REVISION= 0,
    SBP_CONNECTION_STATUS,
    SBP_MODULE_ADDRESS,
    SBP_BOARD_TYPE,
} STATUS_BAR_PANE;

class N1568DemoFrame: public GUIFrame {
public:
    N1568DemoFrame(wxFrame *frame);
    ~N1568DemoFrame();
    void SetStatusBarText( const wxString &msg, STATUS_BAR_PANE pane);
    void AddToLogger( const wxString &msg, LOG_MESSAGE_TYPE type= LMT_INTERNAL);
    N1568_data* GetBoardData( ) {
        return &this->m_board_data;
    }
    bool SetModuleAddress( );
    bool RefreshChannels( );
    static wxString GetExecutablePath();
	void DoExport( bool prompt);
	void DoDirectCmdSend();
	void DoSetMuxOut();

private:
    virtual void OnClose(wxCloseEvent& event);
    virtual void OnQuit(wxCommandEvent& event);
    virtual void OnAbout(wxCommandEvent& event);
    virtual void OnFileQuitToolClicked( wxCommandEvent& event );
    virtual void OnToolsConnectToolClicked( wxCommandEvent& event );
    virtual void OnToolsExportToolClicked( wxCommandEvent& event );
    virtual void OnToolsDownloadToolClicked( wxCommandEvent& event );
    virtual void OnToolsSettingsToolClicked( wxCommandEvent& event );
    virtual void OnHelpAboutToolClicked( wxCommandEvent& event );
    virtual void OnMenuToolsConnect( wxCommandEvent& event );
    virtual void OnMenuToolsExport( wxCommandEvent& event );
    virtual void OnMenuToolsDownload( wxCommandEvent& event );
    virtual void OnMenuToolsSettings( wxCommandEvent& event );
	virtual void OnCmdTextCtrlEnter( wxCommandEvent& event );
	virtual void OnCmdTextCtrl( wxCommandEvent& event );
	virtual void OnCmdSendClick( wxCommandEvent& event );
	virtual void OnMuxOutChanged( wxSpinEvent& event );
	virtual void OnIdle( wxIdleEvent& event );
	virtual void OnModuleAddressChanged( wxSpinEvent& event );
	virtual void OnSize( wxSizeEvent& event );
	void SetStatusBarBoard();

    bool ConnectToDevice( bool connect);
    void SetupSettings( );
    ApplicationSettings m_application_settings;
    void LayoutWindow();
    ChannelPanelImpl* m_channel_panel_array[ MAX_CHANNELS];
    AllChannelPanelImpl* m_all_channel_panel;
    bool m_is_connect;
    N1568_data m_board_data;
	wxDateTime m_next_module_address_sent;
	wxDateTime m_next_mux_out_sent;
	const static int SPIN_CTRL_DELAY_MSEC= 1500;

};

#endif // N1568DEMOMAIN_H
