/***************************************************************
 * Name:      N1568DemoMain.cpp
 * Purpose:   Code for Application Frame
 * Author:    NDA (nicola.dellamico@ndatech.it)
 * Created:   2008-07-29
 * Copyright: CAEN S.p.A (www.caen.it)
 * License:
 **************************************************************/

#ifdef WX_PRECOMP
#include "wx_pch.h"
#endif

#ifdef __BORLANDC__
#pragma hdrstop
#endif //__BORLANDC__
#include <wx/textfile.h>
#include <wx/filename.h>
#include <wx/datetime.h>

#include "N1568DemoMain.h"
#include "ChannelPanelImpl.h"
#include "AllChannelPanelImpl.h"
#include "SettingsDialogImpl.h"
#include "wxBackgroundBitmap.h"

//helper functions
enum wxbuildinfoformat {
    short_f, long_f
};

wxString wxbuildinfo(wxbuildinfoformat format) {
    wxString wxbuild(wxVERSION_STRING);

    if (format == long_f ) {
#if defined(__WXMSW__)
        wxbuild << _T("-Windows");
#elif defined(__WXMAC__)
        wxbuild << _T("-Mac");
#elif defined(__UNIX__)
        wxbuild << _T("-Linux");
#endif

#if wxUSE_UNICODE
        wxbuild << _T("-Unicode build");
#else
        wxbuild << _T("-ANSI build");
#endif // wxUSE_UNICODE
    }

    return wxbuild;
}


N1568DemoFrame::N1568DemoFrame(wxFrame *frame)
        : GUIFrame(frame) {
    this->m_is_connect= false;

	this->m_main_toolBar->PushEventHandler( new wxBackgroundBitmap( wxBitmap(_T("images/caen.png"), wxBITMAP_TYPE_PNG), this));
    this->m_main_toolBar->EnableTool( ID_TOOLS_EXPORT_TOOL, this->m_is_connect);
    this->m_main_toolBar->EnableTool( ID_TOOLS_DOWNLOAD_TOOL, this->m_is_connect);
	this->m_cmd_send_button->Enable( this->m_is_connect);

    for ( int i= 0; i< MAX_CHANNELS ; i++) {
        this->m_channel_panel_array[ i]= new ChannelPanelImpl( this->m_channels_scrolledWindow, this);
        this->m_channel_panel_array[ i]->Show( false);
        this->m_channel_sizer->Add( this->m_channel_panel_array[ i], 0, wxEXPAND | wxALL, 0 );
        this->m_channel_panel_array[ i]->SetChannelId( i);
        this->m_channel_panel_array[ i]->EnableCommunication( false);
    }

    this->m_all_channel_panel= new AllChannelPanelImpl( this->m_channels_scrolledWindow, this);
    this->m_all_channel_panel->Show( true);
    this->m_channel_sizer->Add( this->m_all_channel_panel, 0, wxEXPAND | wxALL, 0 );
    this->m_all_channel_panel->SetChannelId( 0);
    this->m_all_channel_panel->EnableCommunication( false);

    this->AddToLogger( _( "Application started"), LMT_INTERNAL);

    // Read configuration settings and setup controls
    if ( !this->m_application_settings.ReadSettings()) {
        wxFAIL_MSG( _("N1568DemoFrame:: Errors while reading application settings"));
        this->AddToLogger( _("N1568DemoFrame:: Errors while reading application settings"), LMT_INTERNAL);
    } else {
        this->AddToLogger( _( "Application settings read."), LMT_INTERNAL);
    }
    this->LayoutWindow();
    wxString sw_rev( _("N1568Demo "));
    sw_rev<< SW_REVISION;
    this->SetStatusBarText( sw_rev, SBP_SW_REVISION);
	this->SetStatusBarBoard();
	this->m_module_address_spinCtrl->SetValue( this->m_application_settings.m_default_module_address);
	this->m_mux_out_spinCtrl->SetValue( this->m_application_settings.m_default_mux_out);
	this->m_next_module_address_sent= wxDateTime::UNow();
	this->m_next_mux_out_sent= wxDateTime::UNow();

}

N1568DemoFrame::~N1568DemoFrame() {
}

void N1568DemoFrame::SetStatusBarBoard() {
	switch( this->m_application_settings.m_board_type) {
		case N1568A:
			this->SetStatusBarText( _T("N1568A"), SBP_BOARD_TYPE);
			break;
		case N1568B:
			this->SetStatusBarText( _T("N1568B"), SBP_BOARD_TYPE);
			break;
		default:
			this->SetStatusBarText( _T(""), SBP_BOARD_TYPE);
			break;
	}
}

wxString N1568DemoFrame::GetExecutablePath() {
    static bool found = false;
    static wxString path;

    if (found)
        return path;
    else {
#ifdef __WXMSW__

        char buf[512];
        *buf = '\0';
        GetModuleFileName(NULL, buf, 511);
        path = buf;

#elif defined(__WXMAC__)

        ProcessInfoRec processinfo;
        ProcessSerialNumber procno ;
        FSSpec fsSpec;

        procno.highLongOfPSN = NULL ;
        procno.lowLongOfPSN = kCurrentProcess ;
        processinfo.processInfoLength = sizeof(ProcessInfoRec);
        processinfo.processName = NULL;
        processinfo.processAppSpec = &fsSpec;

        GetProcessInformation( &procno , &processinfo ) ;
        path = wxMacFSSpec2MacFilename(&fsSpec);
#else
        wxString argv0 = wxTheApp->argv[0];

        if (wxIsAbsolutePath(argv0))
            path = argv0;
        else {
            wxPathList pathlist;
            pathlist.AddEnvList(wxT("PATH"));
            path = pathlist.FindAbsoluteValidPath(argv0);
        }

        wxFileName filename(path);
        filename.Normalize();
        path = filename.GetFullPath();
#endif
        found = true;
        return path;
    }
}

void N1568DemoFrame::OnClose(wxCloseEvent &/*event*/) {
    Destroy();
}

void N1568DemoFrame::OnQuit(wxCommandEvent &/*event*/) {
    Destroy();
}

void N1568DemoFrame::OnAbout(wxCommandEvent &/*event*/) {
	AboutDialog dlg( this);
	wxString label;
	label= _( "N1568Demo Rev. ");
	label<< SW_REVISION;
	dlg.m_sw_rev_Text->SetLabel( label);
	dlg.m_sdk_sw_rev_Text->SetLabel( N1568_SW_rev());
	dlg.ShowModal( );
}
void N1568DemoFrame::OnFileQuitToolClicked( wxCommandEvent& event ) {
    this->OnQuit( event);
}
void N1568DemoFrame::OnToolsConnectToolClicked( wxCommandEvent& event ) {
    this->OnMenuToolsConnect( event);
}
void N1568DemoFrame::OnToolsExportToolClicked( wxCommandEvent& /*event*/ ) {
	this->DoExport( true);
}
void N1568DemoFrame::OnToolsDownloadToolClicked( wxCommandEvent& event ) {
    this->OnMenuToolsDownload( event);
}
void N1568DemoFrame::OnToolsSettingsToolClicked( wxCommandEvent& event ) {
    this->OnMenuToolsSettings( event);
}
void N1568DemoFrame::OnMenuToolsConnect( wxCommandEvent& /*event*/ ) {
    this->ConnectToDevice( !this->m_is_connect);
}
void N1568DemoFrame::OnMenuToolsExport( wxCommandEvent& /*event*/ ) {
	this->DoExport( true);
}
void N1568DemoFrame::DoExport( bool prompt) {
	if ( !this->m_is_connect) {
        return;
    }
    // Prompt the user
	if( prompt) {
		wxMessageDialog prompt_dlg( this, _("Pressing Ok the channel 0 data will be copied to other channels!\nDo you confirm the operation ?"), ("Warning"), wxOK| wxCANCEL| wxICON_WARNING);
		if ( prompt_dlg.ShowModal()!= wxID_OK) {
			return;
		}
	}
    // Export channel 0 data to other channels
    if ( !N1568_export( &this->m_board_data)) {
        wxString msg( _("Error while sending export command "));
        wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
        dlg.ShowModal();
        this->AddToLogger( msg, LMT_INTERNAL);
    }
    this->AddToLogger( N1568_get_last_answer( &this->m_board_data), LMT_COMMUNICATION);
    // Refresh channels status
    this->RefreshChannels();

}
void N1568DemoFrame::OnMenuToolsDownload( wxCommandEvent& /*event*/ ) {
    if ( !this->m_is_connect) {
        return;
    }
    // Select a file
    wxFileDialog file_dlg( this, _("Choose a command file to download to the board ..."), "", _T(""), _T("*.*"), wxFD_OPEN| wxFD_FILE_MUST_EXIST| wxFD_PREVIEW);
    if ( file_dlg.ShowModal()!= wxID_OK) {
        return;
    }
    wxTextFile text_file;
    if ( !text_file.Open( file_dlg.GetPath())) {
        wxString msg( _("Error while opening donwload file "));
        msg<< file_dlg.GetPath();
        wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
        dlg.ShowModal();
        this->AddToLogger( msg, LMT_INTERNAL);
        return;
    }
    UINT8 buff[ 256];
    for ( size_t i= 0; i< text_file.GetLineCount(); i++) {
        wxString line= text_file[ i].Trim().Trim( false);
        int timeout= 40;
        switch ( line[ 0]) {
        case '#':
            // comment line
            continue;
        case 'M':
        case 'm':
        case 'X':
        case 'x':
            timeout= 3000;
            break;
        }
        UINT16 buff_size= (UINT16) line.Length();
        if ( buff_size>= sizeof( buff)) {
            wxString msg( _("Bad input line: ["));
            msg<< i<< _T("] '")<< line<< _T("'");
            wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
            dlg.ShowModal();
            this->AddToLogger( msg, LMT_INTERNAL);
            continue;
        }
        if ( !buff_size) {
            continue;
        }
        line<< '\r';
        ++buff_size;
        memcpy( buff, line.GetData(), buff_size);
        if ( !send_buffer( &this->m_board_data.m_common_data, buff, buff_size )) {
            wxString msg( _("Error while sending command: ["));
            msg<< i<< _T("] '")<< line<< _T("'");
            wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
            dlg.ShowModal();
            this->AddToLogger( msg, LMT_INTERNAL);
            continue;
        }
        UINT16 asw_buff_size= ASW_BUFF_SIZE- 1;
        if ( !receive_buffer( &this->m_board_data.m_common_data, (UINT8*)this->m_board_data.m_p_asw_buff, &asw_buff_size, timeout)) {
            wxString msg( _("Error while receiving answer "));
            wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
            dlg.ShowModal();
            this->AddToLogger( msg, LMT_INTERNAL);
            continue;
        }
        this->m_board_data.m_asw_buff_len= asw_buff_size;
        this->AddToLogger( N1568_get_last_answer( &this->m_board_data), LMT_COMMUNICATION);
    }
    text_file.Close();
    // Refresh channels status
    this->RefreshChannels();

}
void N1568DemoFrame::OnMenuToolsSettings( wxCommandEvent& /*event */) {
    this->SetupSettings();
}

void N1568DemoFrame::OnHelpAboutToolClicked( wxCommandEvent& event ) {
    this->OnAbout( event);
}
void N1568DemoFrame:: SetStatusBarText( const wxString &msg, STATUS_BAR_PANE pane) {
#if wxUSE_STATUSBAR
    this->m_main_statusBar->SetStatusText( msg, (int)pane);
#endif
}
bool N1568DemoFrame::ConnectToDevice( bool connect) {
    if ( connect== this->m_is_connect) {
        return true;
    }

    if ( connect) {
		if ( !N1568_open( &this->m_board_data, this->m_application_settings.m_communication_device_id.GetData(), this->m_application_settings.m_board_type)) {
            wxString msg( _("Unable to open communication device: "));
            msg<< this->m_application_settings.m_communication_device_id;
            wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
            dlg.ShowModal();
            this->AddToLogger( msg, LMT_INTERNAL);
            this->m_main_toolBar->ToggleTool( ID_TOOLS_CONNECT_TOOL, false);
            this->m_menu_tools_connect->Check( false);
            return false;
        }
        this->m_is_connect= true;
        wxString log_msg= _("Communication device opened: ");
        log_msg<< this->m_application_settings.m_communication_device_id;
        this->AddToLogger( log_msg, LMT_INTERNAL);
		this->DoSetMuxOut();
    } else {
        if ( !N1568_close( &this->m_board_data)) {
            wxString msg( _("Unable to close communication device: "));
            msg<< this->m_application_settings.m_communication_device_id;
            wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
            dlg.ShowModal();
            this->AddToLogger( msg, LMT_INTERNAL);
            this->m_main_toolBar->ToggleTool( ID_TOOLS_CONNECT_TOOL, true);
            this->m_menu_tools_connect->Check( true);
            return false;
        } else {
            this->SetStatusBarText( _T(""), SBP_MODULE_ADDRESS);
        }
        this->m_is_connect= false;
        this->AddToLogger( _("Communication device closed"), LMT_INTERNAL);
    }
    for ( int i= 0; i< MAX_CHANNELS; i++) {
        this->m_channel_panel_array[ i]->EnableCommunication( this->m_is_connect);
    }
	this->m_all_channel_panel->EnableCommunication( this->m_is_connect);

    this->m_main_toolBar->ToggleTool( ID_TOOLS_CONNECT_TOOL, this->m_is_connect);
    this->m_menu_tools_export->Enable( this->m_is_connect);
    this->m_main_toolBar->EnableTool( ID_TOOLS_EXPORT_TOOL, this->m_is_connect);
    this->m_menu_tools_download->Enable( this->m_is_connect);
    this->m_main_toolBar->EnableTool( ID_TOOLS_DOWNLOAD_TOOL, this->m_is_connect);
	this->m_cmd_send_button->Enable( this->m_is_connect);
    if ( this->m_is_connect) {
        wxString msg( _("CONNECTED: "));
        msg<< this->m_application_settings.m_communication_device_id;
        this->SetStatusBarText( msg, SBP_CONNECTION_STATUS);
    } else {
        this->SetStatusBarText( _("NOT CONNECTED"), SBP_CONNECTION_STATUS);
    }
	this->m_main_toolBar->SetToolNormalBitmap( ID_TOOLS_CONNECT_TOOL, wxBitmap( this->m_is_connect? wxT("images/cache_red.png"): wxT("images/cache.png"), wxBITMAP_TYPE_ANY));
	wxDateTime now= wxDateTime::UNow();
	char tmpbuff[255];
	UINT8 tmp[5];
	int n = this->m_module_address_spinCtrl->GetValue();
	sprintf(tmpbuff,"M%d\r",n);
	memcpy(tmp,tmpbuff,5);
	if ( this->m_is_connect) {
		if ( !send_buffer( &this->m_board_data.m_common_data, tmp, 5)) {
			wxString msg( _("Error while sending command: ["));
			wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
			dlg.ShowModal();
			this->AddToLogger( msg, LMT_INTERNAL);
			return false;
		}
		int timeout= 40;
		UINT16 asw_buff_size= ASW_BUFF_SIZE- 1;
		if ( !receive_buffer( &this->m_board_data.m_common_data, (UINT8*)this->m_board_data.m_p_asw_buff, &asw_buff_size, timeout)) {
			wxString msg( _("Error while receiving answer "));
			wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
			dlg.ShowModal();
			this->AddToLogger( msg, LMT_INTERNAL);
			return false;
		}
		this->m_board_data.m_asw_buff_len= asw_buff_size;
		this->AddToLogger( N1568_get_last_answer( &this->m_board_data), LMT_COMMUNICATION);
		//this->RefreshChannels();
		this->m_next_module_address_sent= now.Add( wxDateSpan( -10));
	}
    return true;
}
bool N1568DemoFrame::RefreshChannels() {
    for ( int i= 0; i< MAX_CHANNELS; i++) {
        if ( !this->m_channel_panel_array[ i]->ReadFromBoard( false, false)) {
            return false;
        }
    }
	this->DoSetMuxOut();
    return true;
}
bool N1568DemoFrame::SetModuleAddress( ) {
    // Setup module id
	if ( !N1568_set_module( &this->m_board_data, (UINT8)this->m_module_address_spinCtrl->GetValue())) {
        wxString msg( _("Error while sending module address "));
		msg<< this->m_module_address_spinCtrl->GetValue();
        wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
        dlg.ShowModal();
        this->AddToLogger( msg, LMT_INTERNAL);
        this->AddToLogger( N1568_get_last_answer( &this->m_board_data), LMT_COMMUNICATION);
        return false;
    }
    wxString msg( _("MODULE ADD: "));
	msg<< this->m_module_address_spinCtrl->GetValue();
    this->SetStatusBarText( msg, SBP_MODULE_ADDRESS);
    this->AddToLogger( N1568_get_last_answer( &this->m_board_data), LMT_COMMUNICATION);
    return true;
}
void N1568DemoFrame::SetupSettings( ) {
    SettingsDialogImpl dlg( this);
    if ( dlg.ShowModal()!= wxID_OK) {
        return;
    }
    wxString org_communication_device_id= this->m_application_settings.m_communication_device_id;
	N1568_BOARD_TYPE org_board_type= this->m_application_settings.m_board_type;
    // Read configuration settings and setup controls
    if ( !this->m_application_settings.ReadSettings()) {
        wxFAIL_MSG( _("N1568DemoFrame:: Errors while reading application settings"));
    }
	this->SetStatusBarBoard();
    this->LayoutWindow();
    this->m_channel_sizer->Layout();
    this->Refresh();
	// Alberto
	this->m_mux_out_spinCtrl->SetValue( this->m_application_settings.m_default_mux_out);
    // Communication device
    if ( this->m_is_connect) {
        if (( org_communication_device_id!= this->m_application_settings.m_communication_device_id)||
			( org_board_type!= this->m_application_settings.m_board_type)) {
            // Close the connection ...
            if ( this->ConnectToDevice( false)) {
                // ... and reconnect
                this->ConnectToDevice( true);
            }
        }
    }
   // if ( this->m_is_connect) {
   //     if ( org_default_module_adress!= this->m_application_settings.m_default_module_address) {
   //         this->SetModuleAddress( );
   //         this->RefreshChannels();
   //     }
   // }
   // if ( this->m_is_connect) {
   //     if ( org_default_mux_out!= this->m_application_settings.m_default_mux_out) {
			//this->DoSetMuxOut( );
   //         this->RefreshChannels();
   //     }
   // }
}
void N1568DemoFrame::AddToLogger( const wxString &msg, LOG_MESSAGE_TYPE type) {
    if ( !this->m_application_settings.m_is_logger_enabled) {
        return;
    }
    wxColour text_color;
    switch ( type) {
    case LMT_INTERNAL:
        text_color.Set( 0x30, 0x30, 0x30);
        break;
    case LMT_COMMUNICATION:
        text_color.Set( 0x10, 0x10, 0xff);
        break;
    default:
        wxFAIL_MSG( _("Internal error: N1568DemoFrame::AddtoLogger Unhandled message type"));
        break;
    }
    wxString log_msg= msg;
    this->m_logger_richText->BeginTextColour( text_color);
    this->m_logger_richText->AppendText( log_msg.Trim( ));
    this->m_logger_richText->AppendText( _T("\n"));
    this->m_logger_richText->EndTextColour( );
    this->m_logger_richText->ShowPosition( this->m_logger_richText->GetLastPosition());
    ::wxSafeYield( NULL, true);
}
void N1568DemoFrame::LayoutWindow() {
    this->m_bottom_panel->Show( this->m_application_settings.m_is_logger_visible);
    if ( this->m_application_settings.m_is_logger_visible) {
        this->m_main_splitter->SplitHorizontally( this->m_channels_scrolledWindow, this->m_bottom_panel, 200);
    } else {
        this->m_main_splitter->Unsplit( this->m_bottom_panel);
    }
    bool first_found= false;
    for ( int i= 0; i< MAX_CHANNELS ; i++) {
        bool to_show= (i>= this->m_application_settings.m_first_visible_channel)&& (i<= this->m_application_settings.m_last_visible_channel);
        this->m_channel_panel_array[ i]->Show( to_show);
        if ( to_show&& ( !first_found)) {
            first_found= true;
            this->m_channel_panel_array[ i]->ShowLabels( true);
        } else {
            this->m_channel_panel_array[ i]->ShowLabels( false);
        }
		this->m_channel_panel_array[ i]->SetBoardType( this->m_application_settings.m_board_type);
    }
	this->m_all_channel_panel->ShowLabels( !first_found);
	this->m_all_channel_panel->SetBoardType( this->m_application_settings.m_board_type);
    this->Layout();
}
void N1568DemoFrame::OnCmdTextCtrlEnter( wxCommandEvent& /*event*/ ){
	this->DoDirectCmdSend();
}
void N1568DemoFrame::DoDirectCmdSend() {
	if ( !this->m_is_connect) {
		return;
	}
	UINT8 buff[ 256];
	wxString line= this->m_cmd_textCtrl->GetValue().Trim( false);
	int timeout= 40;
	switch ( line[ 0]) {
		case 'M':
		case 'm':
		case 'X':
		case 'x':
			timeout= 3000;
			break;
	}
	UINT16 buff_size= (UINT16) line.Length();
	if ( buff_size>= sizeof( buff)) {
		wxString msg( _("Bad input line: ["));
		msg<< _T("] '")<< line<< _T("'");
		wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
		dlg.ShowModal();
		this->AddToLogger( msg, LMT_INTERNAL);
		return;
	}
	if ( !buff_size) {
		return;
	}
	line<< '\r';
	++buff_size;
	memcpy( buff, line.GetData(), buff_size);
	if ( !send_buffer( &this->m_board_data.m_common_data, buff, buff_size )) {
		wxString msg( _("Error while sending command: ["));
		msg<< _T("] '")<< line<< _T("'");
		wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
		dlg.ShowModal();
		this->AddToLogger( msg, LMT_INTERNAL);
		return;
	}
	UINT16 asw_buff_size= ASW_BUFF_SIZE- 1;
	if ( !receive_buffer( &this->m_board_data.m_common_data, (UINT8*)this->m_board_data.m_p_asw_buff, &asw_buff_size, timeout)) {
		wxString msg( _("Error while receiving answer "));
		wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
		dlg.ShowModal();
		this->AddToLogger( msg, LMT_INTERNAL);
		return;
	}
	this->m_board_data.m_asw_buff_len= asw_buff_size;
	this->AddToLogger( N1568_get_last_answer( &this->m_board_data), LMT_COMMUNICATION);
	// Refresh channels status
	// this->RefreshChannels();
	this->m_cmd_textCtrl->SetSelection( -1, -1);
	this->m_cmd_textCtrl->SetFocus();
	this->m_cmd_textCtrl->SetForegroundColour( wxColour( 0, 0, 0 ) );
	this->m_cmd_textCtrl->Refresh();
}
void N1568DemoFrame::OnCmdTextCtrl( wxCommandEvent& event ){
	this->m_cmd_textCtrl->SetForegroundColour( wxColour( 240, 0, 0 ) );
	this->m_cmd_textCtrl->Refresh();
	event.Skip();
}
void N1568DemoFrame::OnCmdSendClick( wxCommandEvent& /*event*/ ){
	this->DoDirectCmdSend();
}
void N1568DemoFrame::OnMuxOutChanged( wxSpinEvent& /*event*/ ){
//	this->DoSetMuxOut();
	this->m_next_mux_out_sent= wxDateTime::UNow().Add( wxTimeSpan( 0, 0, 0 , SPIN_CTRL_DELAY_MSEC));

}
void N1568DemoFrame::DoSetMuxOut() {
	if( !this->m_is_connect) {
		return;
	}
    // SetChannel to the mux out control id
	int channel_id= this->m_mux_out_spinCtrl->GetValue();
	if ( !N1568_set_channel( &this->m_board_data, channel_id, NULL)) {
        wxString msg( _("Error while writing channel id "));
        msg<< channel_id;
        wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
        dlg.ShowModal();
        this->AddToLogger( msg);
        this->AddToLogger( N1568_get_last_answer( &this->m_board_data), LMT_COMMUNICATION);
        return;
    } else {
        this->AddToLogger( N1568_get_last_answer( &this->m_board_data), LMT_COMMUNICATION);
    }
}
void N1568DemoFrame::OnModuleAddressChanged( wxSpinEvent& /*event*/ ){
	this->m_next_module_address_sent= wxDateTime::UNow().Add( wxTimeSpan( 0, 0, 0 , SPIN_CTRL_DELAY_MSEC));
}

void N1568DemoFrame::OnIdle( wxIdleEvent& event ) {
	wxDateTime now= wxDateTime::UNow();
	if( now>= this->m_next_module_address_sent)
	{
		if ( this->m_is_connect) {
			this->SetModuleAddress();
			this->RefreshChannels();
			this->m_next_module_address_sent= now.Add( wxDateSpan( 10));
		}
	}
	if( now>= this->m_next_mux_out_sent)
	{
		if ( this->m_is_connect) {
			this->DoSetMuxOut();
			this->m_next_mux_out_sent= now.Add( wxDateSpan( 10));
		}
	}

	event.Skip();
}
void N1568DemoFrame::OnSize( wxSizeEvent& event ){
	this->m_main_toolBar->Refresh( true);
	event.Skip();
}
