/***************************************************************
 * Name:      ChannelPanelImpl.h
 * Purpose:   Defines for ChannelPanelImpl class
 * Author:    NDA (nicola.dellamico@ndatech.it)
 * Created:   2008-07-29
 * Copyright: CAEN S.p.A (www.caen.it)
 * License:
 **************************************************************/
#ifndef _CHANNELPANELIMPL_H
#define _CHANNELPANELIMPL_H

#include "GUIFrame.h"
#include "common.h"

class N1568DemoFrame;

class ChannelPanelImpl : public ChannelPanel {
public:
    ChannelPanelImpl( wxWindow* parent, N1568DemoFrame* p_main_frame);
    virtual ~ChannelPanelImpl();
    void ShowLabels( bool show);
    virtual void SetChannelId( int channel_id);
    void EnableCommunication( bool enable);
    bool ReadFromBoard( bool force_update, bool set_muxout);
	void SetBoardType( N1568_BOARD_TYPE board_type);
protected:
    int m_channel_id;
    N1568_data *m_p_board_data;
    void UpdateControls( N1568_channel_status& channel_status, bool force);
    void OnCFThChanged( wxSpinEvent& event );
    void OnCFWdtChanged( wxSpinEvent& event );
    void OnPZChanged( wxSpinEvent& event );
    void OnFGChanged( wxSpinEvent& event );
    void OnSHChanged( wxSpinEvent& event );
    void OnCGChanged( wxSpinEvent& event );
    void OnCGTChanged( wxSpinEvent& event );
    void OnInChanged( wxCommandEvent& event );
    void OnSTRChanged( wxCommandEvent& event );
    virtual void OnWriteClicked( wxCommandEvent& event );
    virtual void OnReadClicked( wxCommandEvent& event );

	bool m_CFTh_changed;
    bool m_CFWdt_changed;
    bool m_PZ_changed;
    bool m_FG_changed;
    bool m_SH_changed;
    bool m_CG_changed;
    bool m_CGT_changed;
    bool m_In_changed;
    bool m_STR_changed;
    void ResetChangeFlags();
    bool m_is_connect;
    void SetDirty( bool is_dirty);
    bool m_is_dirty;
    void AddToLogger( const wxString &msg, LOG_MESSAGE_TYPE type= LMT_INTERNAL);
    N1568DemoFrame* m_p_main_frame;
	N1568_BOARD_TYPE m_board_type;
private:
};

#endif // _CHANNELPANELIMPL_H
