/***************************************************************
 * Name:      ChannelPanelImpl.cpp
 * Purpose:   Code for ChannelPanelImpl class
 * Author:    NDA (nicola.dellamico@ndatech.it)
 * Created:   2008-07-29
 * Copyright: CAEN S.p.A (www.caen.it)
 * License:
 **************************************************************/
#ifdef WX_PRECOMP
#include "wx_pch.h"
#include "wx/log.h"
#endif
#include "ChannelPanelImpl.h"
#include "N1568DemoMain.h"

ChannelPanelImpl::ChannelPanelImpl( wxWindow* parent, N1568DemoFrame* p_main_frame)
        : ChannelPanel( parent), m_channel_id( -1), m_is_connect( false), m_p_main_frame( p_main_frame) {
    this->m_p_board_data= m_p_main_frame->GetBoardData();
    this->SetDirty( false);
	this->m_board_type= this->m_p_board_data->m_board_type;
}

ChannelPanelImpl::~ChannelPanelImpl() {

}

void ChannelPanelImpl::ShowLabels( bool show) {
    this->m_cfd_threshold_staticText->Show( show);
    this->m_cfd30_out_width_staticText->Show( show);
    this->m_pole_zero_adj_staticText->Show( show);
    this->m_fine_gain_staticText->Show( show);
    this->m_shaping_time_staticText->Show( show);
    this->m_coarse_gain_staticText->Show( show);
    this->m_gain_timing_staticText->Show( show);
    this->m_input_polarity_staticText->Show( show);
    this->m_stretcher_enable_staticText->Show( show);
}

void ChannelPanelImpl::SetBoardType( N1568_BOARD_TYPE board_type) {
	/*if( this->m_board_type == board_type) {
		this->AddToLogger(_T("0"));
		return;
	}*/
	this->m_board_type= board_type;
	switch( this->m_board_type) {
		case N1568A:
			this->m_stretcher_enable_staticText->SetLabel( _T("Out."));
			this->m_stretcher_enable_choice->Clear();
			this->m_stretcher_enable_choice->Append( _T("POSITIVE"));
			this->m_stretcher_enable_choice->Append( _T("NEGATIVE"));
			this->m_stretcher_enable_choice->SetSelection( 0 );
			this->m_stretcher_enable_choice->SetToolTip( _("Setup the output polarity ") );

			this->m_fine_gain_spinCtrl->SetValue( 0);
			this->m_fine_gain_spinCtrl->SetRange( 0, 191);
			break;
		case N1568B:
			this->m_stretcher_enable_staticText->SetLabel( _T("STR."));
			this->m_stretcher_enable_choice->Clear();
			this->m_stretcher_enable_choice->Append( _T("DISABLED"));
			this->m_stretcher_enable_choice->Append( _T("ENABLED"));
			this->m_stretcher_enable_choice->SetSelection( 0 );
			this->m_stretcher_enable_choice->SetToolTip( _("Enable/Disable the stretcher ") );

			this->m_fine_gain_spinCtrl->SetValue( 0);
			this->m_fine_gain_spinCtrl->SetRange( 0, 127);
			break;
	}
}

void ChannelPanelImpl::SetChannelId( int channel_id) {
    this->m_channel_id= channel_id;
    // Setup label
    wxString text( _("Ch "));
    this->m_channel_staticText->SetLabel( text<< channel_id);
}
void ChannelPanelImpl::EnableCommunication( bool enable) {
    this->m_is_connect= enable;
    this->m_read_button->Enable( this->m_is_connect);
    this->m_write_button->Enable( this->m_is_dirty&& this->m_is_connect);
}
void ChannelPanelImpl::OnCFThChanged( wxSpinEvent& /*event*/ ) {
    this->m_CFTh_changed= true;
    this->SetDirty( true);
}
void ChannelPanelImpl::OnCFWdtChanged( wxSpinEvent& /*event*/ ) {
    this->m_CFWdt_changed= true;
    this->SetDirty( true);
}
void ChannelPanelImpl::OnPZChanged( wxSpinEvent& /*event*/ ) {
    this->m_PZ_changed= true;
    this->SetDirty( true);
}
void ChannelPanelImpl::OnFGChanged( wxSpinEvent& /*event*/ ) {
    this->m_FG_changed= true;
    this->SetDirty( true);
}
void ChannelPanelImpl::OnSHChanged( wxSpinEvent& /*event*/ ) {
    this->m_SH_changed= true;
    this->SetDirty( true);
}
void ChannelPanelImpl::OnCGChanged( wxSpinEvent& /*event*/ ) {
    this->m_CG_changed= true;
    this->SetDirty( true);
}
void ChannelPanelImpl::OnCGTChanged( wxSpinEvent& /*event*/ ) {
    this->m_CGT_changed= true;
    this->SetDirty( true);
}
void ChannelPanelImpl::OnInChanged( wxCommandEvent& /*event*/ ) {
    this->m_In_changed= true;
    this->SetDirty( true);
}
void ChannelPanelImpl::OnSTRChanged( wxCommandEvent& /*event*/ ) {
    this->m_STR_changed= true;
    this->SetDirty( true);
}
void ChannelPanelImpl::ResetChangeFlags() {
    this->m_CFTh_changed= false;
    this->m_CFWdt_changed= false;
    this->m_PZ_changed= false;
    this->m_FG_changed= false;
    this->m_SH_changed= false;
    this->m_CG_changed= false;
    this->m_CGT_changed= false;
    this->m_In_changed= false;
    this->m_STR_changed= false;
}
void ChannelPanelImpl::AddToLogger( const wxString &msg, LOG_MESSAGE_TYPE type) {
    this->m_p_main_frame->AddToLogger( msg, type);
}
void ChannelPanelImpl::OnWriteClicked( wxCommandEvent& /*event*/ ) {
    // SetChannel
    if ( !N1568_set_channel( this->m_p_board_data, this->m_channel_id, NULL)) {
        wxString msg( _("Error while writing channel id "));
        msg<< this->m_channel_id;
        wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
        dlg.ShowModal();
        this->AddToLogger( msg);
        this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
        return;
    } else {
        this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
    }

    N1568_channel_status channel_status;

    if ( this->m_CFTh_changed) {
        UINT8 value= (UINT8)this->m_cfd_threshold_spinCtrl->GetValue();
        if ( !N1568_set_discr_thr( this->m_p_board_data, value, &channel_status)) {
            wxString msg( _("Error while writing CFTh "));
            msg<< value;
            wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
            dlg.ShowModal();
            this->AddToLogger( msg);
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            return;
        } else {
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            // Check for read value match
            UINT8 read_value= channel_status.m_discr_thr;
            if ( read_value!= value) {
                wxString msg( _("CFTh readout mismatch: "));
                msg<< _("written: ")<< value<< _(" read: ")<< read_value;
                wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
                dlg.ShowModal();
                this->AddToLogger( msg);
            }
        }
    }
    if ( this->m_CFWdt_changed) {
        UINT8 value= (UINT8)this->m_cfd30_out_width_spinCtrl->GetValue();
        if ( !N1568_set_cfd_out_width( this->m_p_board_data, value, &channel_status)) {
            wxString msg( _("Error while writing CFWdt "));
            msg<< value;
            wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
            dlg.ShowModal();
            this->AddToLogger( msg);
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            return;
        } else {
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            // Check for read value match
            UINT8 read_value= channel_status.m_cfd_out_width;
            if ( read_value!= value) {
                wxString msg( _("CFWdt readout mismatch: "));
                msg<< _("written: ")<< value<< _(" read: ")<< read_value;
                wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
                dlg.ShowModal();
                this->AddToLogger( msg);
            }
        }
    }
    if ( this->m_PZ_changed) {
        UINT8 value= (UINT8)this->m_pole_zero_adj_spinCtrl->GetValue();
        if ( !N1568_set_pole_zero_adj( this->m_p_board_data, value, &channel_status)) {
            wxString msg( _("Error while writing P/Z adjust "));
            msg<< value;
            wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
            dlg.ShowModal();
            this->AddToLogger( msg);
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            return;
        } else {
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            // Check for read value match
            UINT8 read_value= channel_status.m_pole_zero_adj;
            if ( read_value!= value) {
                wxString msg( _("P/Z adjust readout mismatch: "));
                msg<< _("written: ")<< value<< _(" read: ")<< read_value;
                wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
                dlg.ShowModal(); 
                this->AddToLogger( msg);
            }
        }
    }
    if ( this->m_FG_changed) {
        UINT8 value= (UINT8)this->m_fine_gain_spinCtrl->GetValue();
        if ( !N1568_set_fine_gain( this->m_p_board_data, value, &channel_status)) {
            wxString msg( _("Error while writing Fine gain "));
            msg<< value;
            wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
            dlg.ShowModal();
            this->AddToLogger( msg);
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            return;
        } else {
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            // Check for read value match
            UINT8 read_value= channel_status.m_fine_gain;
            if ( read_value!= value) {
                wxString msg( _("Fine gain readout mismatch: "));
                msg<< _("written: ")<< value<< _(" read: ")<< read_value;
                wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
                dlg.ShowModal();
                this->AddToLogger( msg);
            }
        }
    }
    if ( this->m_SH_changed) {
        UINT8 value= (UINT8)this->m_shaping_time_spinCtrl->GetValue();
        if ( !N1568_set_shape( this->m_p_board_data, value, &channel_status)) {
            wxString msg( _("Error while writing Shaping time "));
            msg<< value;
            wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
            dlg.ShowModal();
            this->AddToLogger( msg);
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            return;
        } else {
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            // Check for read value match
            UINT8 read_value= channel_status.m_shape_setting;
            if ( read_value!= value) {
                wxString msg( _("Shaping time readout mismatch: "));
                msg<< _("written: ")<< value<< _(" read: ")<< read_value;
                wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
                dlg.ShowModal();
                this->AddToLogger( msg);
            }
        }
    }
    if ( this->m_CG_changed) {
        UINT8 value= (UINT8)this->m_coarse_gain_spinCtrl->GetValue();
        if ( !N1568_set_coarse_gain( this->m_p_board_data, value, &channel_status)) {
            wxString msg( _("Error while writing coarse gain "));
            msg<< value;
            wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
            dlg.ShowModal();
            this->AddToLogger( msg);
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            return;
        } else {
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            // Check for read value match
            UINT8 read_value= channel_status.m_coarse_gain;
            if ( read_value!= value) {
                wxString msg( _("Coarse gain readout mismatch: "));
                msg<< _("written: ")<< value<< _(" read: ")<< read_value;
                wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
                dlg.ShowModal();
                this->AddToLogger( msg);
            }
        }
    }
    if ( this->m_CGT_changed) {
        UINT8 value= (UINT8)this->m_gain_timing_spinCtrl->GetValue();
        if ( !N1568_set_gain_of_timing( this->m_p_board_data, value, &channel_status)) {
            wxString msg( _("Error while writing coarse gain timing "));
            msg<< value;
            wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
            dlg.ShowModal();
            this->AddToLogger( msg);
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            return;
        } else {
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            // Check for read value match
            UINT8 read_value= channel_status.m_gain_timing;
            if ( read_value!= value) {
                wxString msg( _("Coarse gain timing readout mismatch: "));
                msg<< _("written: ")<< value<< _(" read: ")<< read_value;
                wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
                dlg.ShowModal();
                this->AddToLogger( msg);
            }
        }
    }
    if ( this->m_In_changed) {
        UINT8 value= (UINT8)this->m_input_polarity_choice->GetSelection();
        if ( !N1568_set_input_polarity( this->m_p_board_data, value!= 0, &channel_status)) {
            wxString msg( _("Error while writing input polarity "));
            msg<< value;
            wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
            dlg.ShowModal();
            this->AddToLogger( msg);
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            return;
        } else {
            this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
            // Check for read value match
            UINT8 read_value= channel_status.m_is_polarity_negative? 1: 0;
            if ( read_value!= value) {
                wxString msg( _("Input polarity readout mismatch: "));
                msg<< _("written: ")<< value<< _(" read: ")<< read_value;
                wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
                dlg.ShowModal();
                this->AddToLogger( msg);
            }
        }
    }
    if ( this->m_STR_changed) {
        UINT8 value= (UINT8)this->m_stretcher_enable_choice->GetSelection();
		switch( this->m_board_type) {
			case N1568A:
				if ( !N1568_set_output_polarity( this->m_p_board_data, value!= 0, &channel_status)) {
					wxString msg( _("Error while writing input polarity"));
					msg<< value;
					wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
					dlg.ShowModal();
					this->AddToLogger( msg);
					this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
					return;
				} else {
					this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
					// Check for read value match
					UINT8 read_value= channel_status.m_is_output_polarity_negative? 1: 0;
					if ( read_value!= value) {
						wxString msg( _("Output polarity readout mismatch: "));
						msg<< _("written: ")<< value<< _(" read: ")<< read_value;
						wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
						dlg.ShowModal();
						this->AddToLogger( msg);
					}
				}
				break;
			case N1568B:
				if ( !N1568_set_stretcher( this->m_p_board_data, value!= 0, &channel_status)) {
					wxString msg( _("Error while writing stretcher enable "));
					msg<< value;
					wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
					dlg.ShowModal();
					this->AddToLogger( msg);
					this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
					return;
				} else {
					this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
					// Check for read value match
					UINT8 read_value= channel_status.m_is_strecher_enabled? 1: 0;
					if ( read_value!= value) {
						wxString msg( _("Stretcher enable readout mismatch: "));
						msg<< _("written: ")<< value<< _(" read: ")<< read_value;
						wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
						dlg.ShowModal();
						this->AddToLogger( msg);
					}
				}
				break;
			default:
				wxFAIL_MSG( _("ChannelPanelImpl:: unhandled board type"));
				break;
		}
    }
    this->SetDirty( false);
	this->m_p_main_frame->DoSetMuxOut();
}
void ChannelPanelImpl::OnReadClicked( wxCommandEvent& /*event*/ ) {
    this->ReadFromBoard( true, true);
}
void ChannelPanelImpl::UpdateControls( N1568_channel_status& channel_status, bool force) {
	if( !this->m_CFTh_changed|| force) {
		this->m_cfd_threshold_spinCtrl->SetValue( channel_status.m_discr_thr);
	}
	if( !this->m_CFWdt_changed|| force) {
	    this->m_cfd30_out_width_spinCtrl->SetValue( channel_status.m_cfd_out_width);
	}
	if( !this->m_PZ_changed|| force) {
	    this->m_pole_zero_adj_spinCtrl->SetValue( channel_status.m_pole_zero_adj);
	}
    if( !this->m_FG_changed|| force) {
		this->m_fine_gain_spinCtrl->SetValue( channel_status.m_fine_gain);
	}
    if( !this->m_SH_changed|| force) {
	    this->m_shaping_time_spinCtrl->SetValue( channel_status.m_shape_setting);
	}
    if( !this->m_CG_changed|| force) {
		this->m_coarse_gain_spinCtrl->SetValue( channel_status.m_coarse_gain);
	}
    if( !this->m_CGT_changed|| force) {
	    this->m_gain_timing_spinCtrl->SetValue( channel_status.m_gain_timing);
	}
    if( !this->m_In_changed|| force) {
	    this->m_input_polarity_choice->SetSelection( channel_status.m_is_polarity_negative? 1: 0);
	}
    if( !this->m_STR_changed|| force) {
	    this->m_stretcher_enable_choice->SetSelection( channel_status.m_is_strecher_enabled? 1: 0);
	}
}
void ChannelPanelImpl::SetDirty( bool is_dirty) {
    this->m_is_dirty= is_dirty;
    if ( !this->m_is_dirty) {
        this->ResetChangeFlags();
    }
    this->m_read_button->Enable( this->m_is_connect);
    this->m_write_button->Enable( this->m_is_dirty&& this->m_is_connect);
}
bool ChannelPanelImpl::ReadFromBoard( bool force_update, bool set_muxout) {
    N1568_channel_status channel_status;

    // Setup the channel to get the new channel status
    if ( !N1568_set_channel( this->m_p_board_data, this->m_channel_id, &channel_status)) {
        wxString msg( _("Error while writing channel id "));
        msg<< this->m_channel_id;
        wxMessageDialog dlg( this, msg, ("Error"), wxOK| wxICON_ERROR);
        dlg.ShowModal();
        this->AddToLogger( msg);
        this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
        return false;
    } else {
        this->AddToLogger( N1568_get_last_answer( this->m_p_board_data), LMT_COMMUNICATION);
        this->UpdateControls( channel_status, force_update);
    }
	if( force_update) {
		this->SetDirty( false);
	}
	if( set_muxout) {
		this->m_p_main_frame->DoSetMuxOut();
	}
    return true;
}
