/***************************************************************
 * Name:      ApplicationSetings.cpp
 * Purpose:   Code for ApplicationSetings class
 * Author:    NDA (nicola.dellamico@ndatech.it)
 * Created:   2008-07-29
 * Copyright: CAEN S.p.A (www.caen.it)
 * License:
 **************************************************************/
#include <wx/config.h>
#include <wx/confbase.h>

#include "ApplicationSettings.h"

const wxString& BASE_CONFIG_SETTINGS= _T( "/APPLICATION_SETTINGS");
const wxString& SETTINGS_FILENAME= _T( "N1568Demo");


ApplicationSettings::ApplicationSettings() {
#if defined(__WXMSW__)
    this->m_communication_device_id= _T("COM1");
#elif defined(__WXMAC__)
    this->m_communication_device_id= _T("???");
#elif defined(__UNIX__)
    this->m_communication_device_id= _T("/dev/ttyUSB0");
#endif
    this->m_first_visible_channel= 0;
    this->m_last_visible_channel= MAX_CHANNELS- 1;
    this->m_default_module_address= 0;
	this->m_default_mux_out= 0;
    this->m_is_logger_enabled= true;
    this->m_is_logger_visible= true;
	this->m_board_type= N1568B;

}

ApplicationSettings::~ApplicationSettings() {
    //dtor
}

bool ApplicationSettings::ReadSettings( ) {
    // Read from configuration file
    wxConfig *config = new wxConfig( SETTINGS_FILENAME);

    //
    // Communication settings
    wxString section= BASE_CONFIG_SETTINGS+ _T( "COMMUNICATION/");
    this->m_communication_device_id= config->Read( section+ _T( "DEVICE_ID"), _T(""));
    //
    // Board settings
    section= BASE_CONFIG_SETTINGS+ _T( "BOARD/");
    this->m_first_visible_channel= config->Read( section+ _T( "FIRST_VISIBLE_CHANNEL"), 0L);
    this->m_last_visible_channel= config->Read( section+ _T( "LAST_VISIBLE_CHANNEL"), (long)( MAX_CHANNELS- 1));
    this->m_default_module_address= config->Read( section+ _T( "DEFAULT_MODULE_ADDRESS"), 0L);
    this->m_default_mux_out= config->Read( section+ _T( "DEFAULT_MUX_OUT"), 0L);
	wxString board_type= config->Read( section+ _T( "BOARD_TYPE"), _T("N1568B"));
	// Check board type:
	this->m_board_type= N1568B;
	if( !board_type.CmpNoCase( "N1568A")) {
		this->m_board_type= N1568A;
	} else if( !board_type.CmpNoCase( "N1568B")) {
		this->m_board_type= N1568B;
	}
    //
    // Application settings
    section= BASE_CONFIG_SETTINGS+ _T( "APPLICATION/");
    this->m_is_logger_enabled= config->Read( section+ _T( "IS_LOGGER_ENABLED"), 1L)!= 0;
    this->m_is_logger_visible= config->Read( section+ _T( "IS_LOGGER_VISIBLE"), 1L)!= 0;

    delete config;
    return true;
}

bool ApplicationSettings::WriteSettings( ) {
    // Read from configuration file
    wxConfig *config = new wxConfig( SETTINGS_FILENAME);

    //
    // Communication settings
    wxString section= BASE_CONFIG_SETTINGS+ _T( "COMMUNICATION/");
    config->Write( section+ _T( "DEVICE_ID"), this->m_communication_device_id);
    //
    // Board settings
    section= BASE_CONFIG_SETTINGS+ _T( "BOARD/");
    config->Write( section+ _T( "FIRST_VISIBLE_CHANNEL"), this->m_first_visible_channel);
    config->Write( section+ _T( "LAST_VISIBLE_CHANNEL"), this->m_last_visible_channel);
    config->Write( section+ _T( "DEFAULT_MODULE_ADDRESS"), this->m_default_module_address);
    config->Write( section+ _T( "DEFAULT_MUX_OUT"), this->m_default_mux_out);
	wxString board_type= "N1568B";
	// Check board type:
	switch( this->m_board_type){
		case N1568A:
			board_type= "N1568A";
			break;
		case N1568B:
			board_type= "N1568B";
			break;
	}
	config->Write( section+ _T( "BOARD_TYPE"), board_type);
    //
    // Application settings
    section= BASE_CONFIG_SETTINGS+ _T( "APPLICATION/");
    config->Write( section+ _T( "IS_LOGGER_ENABLED"), this->m_is_logger_enabled? 1: 0);
    config->Write( section+ _T( "IS_LOGGER_VISIBLE"), this->m_is_logger_visible? 1: 0);

    delete config;
    return true;
}
