/***************************************************************
 * Name:      AllChannelPanelImpl.cpp
 * Purpose:   Code for AllChannelPanelImpl class
 * Author:    NDA (nicola.dellamico@ndatech.it)
 * Created:   2008-09-16
 * Copyright: CAEN S.p.A (www.caen.it)
 * License:
 **************************************************************/
#ifdef WX_PRECOMP
#include "wx_pch.h"
#endif
#include "AllChannelPanelImpl.h"
#include "N1568DemoMain.h"

AllChannelPanelImpl::AllChannelPanelImpl( wxWindow* parent, N1568DemoFrame* p_main_frame)
        : ChannelPanelImpl( parent, p_main_frame) {
}

AllChannelPanelImpl::~AllChannelPanelImpl() {
}

void AllChannelPanelImpl::OnWriteClicked( wxCommandEvent& event ) {
	ChannelPanelImpl::OnWriteClicked( event );
	// Do export to other channels
	this->m_p_main_frame->DoExport( false);
}
void AllChannelPanelImpl::OnReadClicked( wxCommandEvent& /*event*/ ) {
	// Do refresh other channels
	this->m_p_main_frame->RefreshChannels( );
}
void AllChannelPanelImpl::SetChannelId( int channel_id) {
    this->m_channel_id= channel_id;
    // Setup label
    wxString text( _("All "));
    this->m_channel_staticText->SetLabel( text);
}

