/*
 * Decompiled with CFR 0.152.
 */
package cvupgradegui;

import cvupgradegui.AppProperties;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PllDevice {
    private final BoardType boardType;
    private int dividerR;
    private int dividerN;
    private int divider0;
    private int divider5;
    private int divider6;
    private int delay6;
    private double actualInputFreq;
    private double vcxoFreq;
    private double outputClockFreq;
    private boolean bypassMode;
    private boolean outputClockEnabled;
    private boolean delay6Enabled;
    private static final double defaultInputClockFreq = 50.0;
    private static final double[] inputClockFreqPresets = new double[]{10.0, 50.0, 62.5, 100.0, 125.0};
    private static final double outputDelayBase = 570.0;
    private static final double outputDelayIncr = 300.0;
    private static final double pfdFreq = 10.0;
    private static final double pfdFreqTolerance = 0.5;
    private static final int prescalerN = 4;
    private static final int flashPageSize = 264;
    private static final int vcxoRegister = 61576;
    private static final double[] defaultVcxoFreq = new double[]{500.0, 500.0, 500.0, 500.0, 500.0, 1000.0};
    private static final double[][] vcxoFreqs = new double[][]{{500.0, 1000.0}, {500.0, 1000.0}, {500.0, 1000.0}, {500.0, 1000.0}, {500.0, 1000.0}, {1000.0}};
    private final double[] defaultAdcFreqs = new double[]{100.0, 250.0, 500.0, 500.0, 62.5, 1000.0};
    private final double[] defaultOutputClockFreqs = new double[]{50.0, 62.5, 62.5, 62.5, 62.5, 62.5};
    private final double[] divider5Multipliers = new double[]{1.0, 2.0, 4.0, 4.0, 0.5, 8.0};
    private final boolean[] bypassModeSupport = new boolean[]{true, true, true, true, false, true};
    String clearText = null;
    ByteArrayOutputStream rbfStream;

    private double getDivider5Multiplier() {
        return this.divider5Multipliers[this.boardType.INT];
    }

    public PllDevice(BoardType boardType) {
        this.boardType = boardType;
    }

    public void initWithDefaults() {
        this.setBypassModeEnabled(false);
        this.setInputFreqs(this.getDefaultInputClockFreq(), this.getDefaultVcxoFreq());
        this.setAdcFreq(this.getDefaultAdcFreq());
        this.setOutputClockEnabled(false);
        this.setOutputClockFreq(this.getDefaultOutputClockFreq());
        this.setOutputClockDelayEnabled(false);
        this.setOutputClockDelay(this.getDefaultOutputClockDelay());
    }

    public int getVcxoRegister() {
        return 61576;
    }

    public String getBoardName() {
        return this.boardType.toString();
    }

    public void setBypassModeEnabled(boolean enabled) {
        this.bypassMode = enabled;
    }

    public boolean isBypassModeEnabled() {
        return this.bypassMode;
    }

    public boolean hasBypassMode() {
        return this.bypassModeSupport[this.boardType.INT];
    }

    public double getActualInputFreq() {
        return this.actualInputFreq;
    }

    public double[] getVcxoFreqs() {
        return vcxoFreqs[this.boardType.INT];
    }

    public double getDefaultVcxoFreq() {
        return defaultVcxoFreq[this.boardType.INT];
    }

    public double getCurrentVcxoFreq() {
        return this.vcxoFreq;
    }

    public double getDefaultInputClockFreq() {
        return 50.0;
    }

    public double[] getInputClockFreqs() {
        return inputClockFreqPresets;
    }

    public void selectInputFreqs(int clockIndex, int vxcoIndex) {
        this.setInputFreqs(inputClockFreqPresets[clockIndex], this.getVcxoFreqs()[vxcoIndex]);
    }

    public void setInputFreqs(double fin, double fvcxo) {
        if (fin <= 0.0 || fvcxo <= 0.0) {
            return;
        }
        this.vcxoFreq = fvcxo;
        double errmin = 99999.0;
        for (int r = 1; r <= 16383; ++r) {
            double approxFin;
            double errnew;
            int n = (int)(fvcxo * (double)r / fin);
            if (n < 1 || !((errnew = Math.abs((approxFin = fvcxo * (double)r / (double)n) / (double)r - 10.0)) < errmin) || !(errnew < 0.5)) continue;
            this.dividerR = r;
            this.dividerN = n;
            this.actualInputFreq = approxFin;
            errmin = errnew;
            if (!(errmin < 1.0E-6)) continue;
            return;
        }
    }

    public void setOutputClockEnabled(boolean enabled) {
        this.outputClockEnabled = enabled;
    }

    public boolean isOutputClockEnabled() {
        return this.outputClockEnabled;
    }

    public double getDefaultOutputClockFreq() {
        return this.defaultOutputClockFreqs[this.boardType.INT];
    }

    public double getCurrentOutputClockFreq() {
        return this.divider6 >= 1 ? this.getOutputClockFreqs()[this.divider6 - 1] : 0.0;
    }

    public double[] getOutputClockFreqs() {
        double[] freqs = new double[32];
        double targetFreq = this.bypassMode ? this.actualInputFreq : this.vcxoFreq;
        for (int i = 0; i < 32; ++i) {
            freqs[i] = targetFreq / (double)(i + 1);
        }
        return freqs;
    }

    public void setOutputClockFreq(double freq) {
        int index = 0;
        for (double f : this.getOutputClockFreqs()) {
            if (freq == f) break;
            ++index;
        }
        this.divider6 = index + 1;
    }

    public void selectOutputClockFreq(int index) {
        this.divider6 = index + 1;
    }

    public void setOutputClockDelayEnabled(boolean enabled) {
        this.delay6Enabled = enabled;
    }

    public boolean isOutputClockDelayEnabled() {
        return this.delay6Enabled;
    }

    public double getDefaultOutputClockDelay() {
        return this.getOutputClockDelays()[0];
    }

    public double getCurrentOutputClockDelay() {
        return this.getOutputClockDelays()[this.delay6];
    }

    public double[] getOutputClockDelays() {
        double[] delays = new double[32];
        double cumul = 570.0;
        for (int i = 0; i < 32; ++i) {
            delays[i] = cumul;
            cumul += 300.0;
        }
        return delays;
    }

    public void setOutputClockDelay(double delay) {
        int index = 0;
        for (double f : this.getOutputClockDelays()) {
            if (delay == f) break;
            ++index;
        }
        this.selectOutputClockDelay(index);
    }

    public void selectOutputClockDelay(int index) {
        this.delay6 = index;
    }

    public Double getDefaultAdcFreq() {
        return this.defaultAdcFreqs[this.boardType.INT];
    }

    public Double[] getAdcFreqs() {
        int i;
        ArrayList<Double> freqs = new ArrayList<Double>(32);
        double div5mod = this.getDivider5Multiplier();
        int numFreqs = div5mod > 0.0 ? (int)(32.0 / div5mod) : (int)(32.0 * div5mod);
        int startDiv = (div5mod > 0.0 ? 1 : (int)(1.0 / div5mod)) + (this.bypassMode ? 0 : (int)(this.vcxoFreq / this.getDefaultAdcFreq() - 1.0));
        double baseFreq = this.bypassMode ? this.actualInputFreq : this.vcxoFreq;
        for (i = 0; i < numFreqs && i + startDiv < 32; ++i) {
            freqs.add(baseFreq / (double)(i + startDiv));
        }
        return freqs.toArray(new Double[i]);
    }

    private Integer[] getDividers0() {
        int i;
        ArrayList<Integer> divs0 = new ArrayList<Integer>(32);
        double div5mod = this.getDivider5Multiplier();
        int numDivs = div5mod > 0.0 ? (int)(32.0 / div5mod) : (int)(32.0 * div5mod);
        int startDiv = (div5mod > 0.0 ? 1 : (int)(1.0 / div5mod)) + (this.bypassMode ? 0 : (int)(this.vcxoFreq / this.getDefaultAdcFreq() - 1.0));
        for (i = 0; i < numDivs && i + startDiv < 32; ++i) {
            divs0.add(i + startDiv);
        }
        return divs0.toArray(new Integer[i]);
    }

    public void setAdcFreq(double freq) {
        double f;
        int index = 0;
        Double[] doubleArray = this.getAdcFreqs();
        int n = doubleArray.length;
        for (int i = 0; i < n && freq != (f = doubleArray[i].doubleValue()); ++i) {
            ++index;
        }
        this.selectAdcFreq(index);
    }

    public void selectAdcFreq(int index) {
        this.divider0 = this.getDividers0()[index];
        this.divider5 = (int)((double)this.divider0 * this.getDivider5Multiplier());
    }

    private int toDutyCycleFormat(int dividerValue) {
        if (dividerValue < 2) {
            dividerValue = 2;
        }
        int dutyCycleLow = dividerValue >> 1;
        int dutyCycleHigh = dividerValue - dutyCycleLow;
        int dutyCycle = dutyCycleHigh - 1 << 4 | dutyCycleLow - 1;
        return dutyCycle;
    }

    private boolean isDivBypassed(int divValue) {
        return divValue <= 1 || this.bypassMode;
    }

    private byte rotateByte(byte original) {
        byte rotated = 0;
        for (int i = 0; i < 8; ++i) {
            rotated = (byte)(rotated << 1);
            rotated = (byte)(rotated | original & 1);
            original = (byte)(original >> 1);
        }
        return rotated;
    }

    public void compile() {
        this.clearText = "";
        this.rbfStream = new ByteArrayOutputStream(264);
        int counterB = this.dividerN / 4;
        int counterA = this.dividerN - counterB * 4;
        while (counterA + 4 < counterB - 1) {
            counterA += 4;
            --counterB;
        }
        try {
            String line;
            String templateFilePath = AppProperties.PllTemplatesDir + this.boardType.toString() + "_template.txt";
            BufferedReader br = new BufferedReader(new FileReader(new File(templateFilePath)));
            Pattern regs = Pattern.compile("\\s*\"([0-9A-Fa-f]{2})\"\\s*,\\s*\"([0-1]{8})\"\\s*,\\s*\"([0-9A-Fa-f]{2})\"");
            Pattern other = Pattern.compile("\\s*\"(\\w+):\"\\s*,\\s*\\d+\\.*\\d+");
            while ((line = br.readLine()) != null) {
                Matcher mRegs = regs.matcher(line);
                Matcher mOther = other.matcher(line);
                if (!mRegs.matches() && !mOther.matches()) {
                    this.clearText = this.clearText + line + AppProperties.Newline;
                    continue;
                }
                if (mRegs.matches()) {
                    int address = Integer.parseInt(mRegs.group(1), 16);
                    int value = Integer.parseInt(mRegs.group(3), 16);
                    switch (address) {
                        case 4: {
                            value = counterA;
                            break;
                        }
                        case 5: {
                            value = counterB >> 8 & 0x1F;
                            break;
                        }
                        case 6: {
                            value = counterB & 0xFF;
                            break;
                        }
                        case 11: {
                            value = this.dividerR >> 8 & 0x3F;
                            break;
                        }
                        case 12: {
                            value = this.dividerR & 0xFF;
                            break;
                        }
                        case 56: {
                            value = !this.delay6Enabled ? 1 : 0;
                            break;
                        }
                        case 58: {
                            value = this.delay6 << 1;
                            break;
                        }
                        case 66: {
                            value = !this.outputClockEnabled ? 5 : 4;
                            break;
                        }
                        case 69: {
                            value = this.bypassMode ? 29 : 2;
                            break;
                        }
                        case 72: {
                            value = this.toDutyCycleFormat(this.divider0);
                            break;
                        }
                        case 74: {
                            value = this.boardType == BoardType.V1751 ? this.toDutyCycleFormat(this.divider0 * 4) : this.toDutyCycleFormat(this.divider0);
                            break;
                        }
                        case 76: {
                            value = this.toDutyCycleFormat(this.divider0);
                            break;
                        }
                        case 78: {
                            value = this.boardType == BoardType.V1751 ? this.toDutyCycleFormat(this.divider0 * 4) : this.toDutyCycleFormat(this.divider0);
                            break;
                        }
                        case 73: {
                            value = this.isDivBypassed(this.divider0) ? 128 : 0;
                            break;
                        }
                        case 75: {
                            value = this.boardType == BoardType.V1751 ? (this.isDivBypassed(this.divider0 * 4) ? 128 : 0) : (this.isDivBypassed(this.divider0) ? 128 : 0);
                            break;
                        }
                        case 77: {
                            value = this.isDivBypassed(this.divider0) ? 128 : 0;
                            break;
                        }
                        case 79: {
                            value = this.boardType == BoardType.V1751 ? (this.isDivBypassed(this.divider0 * 4) ? 128 : 0) : (this.isDivBypassed(this.divider0) ? 128 : 0);
                            break;
                        }
                        case 82: {
                            value = this.toDutyCycleFormat(this.divider5);
                            break;
                        }
                        case 83: {
                            value = (this.divider5 <= 1 ? 128 : 0) | (this.boardType == BoardType.V1751 ? 2 : 0);
                            break;
                        }
                        case 84: {
                            value = this.toDutyCycleFormat(this.divider6);
                            break;
                        }
                        case 85: {
                            value = this.isDivBypassed(this.divider6) ? 128 : 0;
                        }
                    }
                    this.clearText = this.clearText + String.format("\"%02X\",\"%08d\",\"%02X\"", address, Integer.parseInt(Integer.toBinaryString(value), 10), value) + AppProperties.Newline;
                    this.rbfStream.write(this.rotateByte((byte)address));
                    this.rbfStream.write(this.rotateByte((byte)value));
                    continue;
                }
                if (!mOther.matches()) continue;
                String tag = mOther.group(1);
                double value = 0.0;
                boolean ignore = false;
                if ("RefIn".equals(tag)) {
                    value = this.actualInputFreq;
                } else if ("CLKInp1".equals(tag)) {
                    value = this.actualInputFreq;
                } else if ("CLKInp2".equals(tag)) {
                    value = this.vcxoFreq;
                } else {
                    ignore = true;
                }
                if (!ignore) {
                    this.clearText = this.clearText + String.format(Locale.US, "\"%s:\",%f", tag, value) + AppProperties.Newline;
                    continue;
                }
                this.clearText = this.clearText + line + AppProperties.Newline;
            }
            br.close();
            while (this.rbfStream.size() < 264) {
                this.rbfStream.write(0);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PllDevice.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getPlainText() {
        return this.clearText;
    }

    public byte[] getRbfData() {
        return this.rbfStream != null ? this.rbfStream.toByteArray() : null;
    }

    public static enum BoardType {
        V1724(0),
        V1720(1),
        V1721(2),
        V1731(3),
        V1740(4),
        V1751(5),
        V1782(6);

        public final int INT;

        private BoardType(int intval) {
            this.INT = intval;
        }
    }
}

