/*
 * Decompiled with CFR 0.152.
 */
package it.caen.V2495;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import it.caen.V2495.FTD2XX_Native;
import it.caen.V2495.NativeComm;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class V2495 {
    private int controller_base_address;
    private int bitstream_length;
    private Byte[] bitstream;
    private boolean _flash_controller_present;
    private int lHandle = -1;
    private int lLink;
    private int lType;
    private int lConet;
    private int lBA;
    private jd2xx lDevice;
    private ControllerType lCType;
    private final int MAIN_FIRMWARE_SECTORS = 42;
    private final int MAIN_FIRMWARE_BITSTREAM_LENGTH = 2709139;
    private final int USER_FIRMWARE_SECTORS = 66;
    private final int USER_FIRMWARE_BITSTREAM_LENGTH = 4321299;
    private final int MAIN_FACTORY_START_ADDRESS = 0;
    private final int MAIN_APPLICATION_START_ADDRESS = 0x400000;
    private final int MAIN_CONFIG_ROM_START_ADDRESS = 0x1FF0000;
    private final int USER_FACTORY_START_ADDRESS = 0;
    private final int USER_APPLICATION1_START_ADDRESS = 0x800000;
    private final int USER_APPLICATION2_START_ADDRESS = 0xC20000;
    private final int USER_APPLICATION3_START_ADDRESS = 0x1040000;
    private final int USER_APPLICATION4_START_ADDRESS = 21364736;
    private final int USER_APPLICATION5_START_ADDRESS = 0x1880000;
    private final int PAGE_SIZE = 256;
    private final int SECTOR_SIZE = 65536;
    private final int OPCODE_OFFSET = 0;
    private final int ADDRESS_OFFSET = 4;
    private final int PAYLOAD_OFFSET = 8;
    private final int REBOOT_OFFSET = 12;
    private final int REBOOT_ADDRESS_OFFSET = 16;
    private final int UNLOCK_OFFSET = 20;
    private final int FPGA_ACCESS_OFFSET = 24;
    private final int FLASH_ACCESS_OFFSET = 28;
    private final int IDCODE_OFFSET = 240;
    private final int BRAM_START_OFFSET = 256;
    private final int RESET_CONTROLLER_OPCODE = 0;
    private final int WRITE_ENABLE_OPCODE = 1;
    private final int READ_STATUS_OPCODE = 2;
    private final int SECTOR_ERASE_OPCODE = 3;
    private final int WRITE_PAGE_OPCODE = 4;
    private final int READ_PAGE_OPCODE = 5;
    private final int WRITE_STATUS_OPCODE = 6;
    private final int NOP_OPCODE = 15;
    private final int CONTROLLER_NOT_PRESENT = -1;
    private final int COMMUNICATION_ERROR = -2;
    private final int PROTECT_SECTORS_0_63 = 15;
    private final int PROTECT_SECTORS_0_127 = 24;
    private final int UNPROTECT_ALL = 8;

    private int Write(int[] data, int addr, boolean autoinc) throws IOException {
        byte[] h = new byte[200];
        int autoinc_flag = 0;
        int currentpointer = 0;
        this.lDevice.purge(2);
        int ll = data.length - 1;
        int aa = addr;
        autoinc_flag = autoinc ? 0 : 2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(data.length * 4);
        IntBuffer intBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        intBuffer.put(data);
        byte[] array = byteBuffer.array();
        h[0] = -1;
        h[1] = 0;
        h[2] = -85;
        h[3] = (byte)(240 + autoinc_flag);
        h[4] = (byte)(aa >> 24 & 0xFF);
        h[5] = (byte)(aa >> 16 & 0xFF);
        h[6] = (byte)(aa >> 8 & 0xFF);
        h[7] = (byte)(aa >> 0 & 0xFF);
        h[8] = (byte)(ll >> 16 & 0xFF);
        h[9] = (byte)(ll >> 8 & 0xFF);
        h[10] = (byte)(ll >> 0 & 0xFF);
        int wbtot = 0;
        int translen = 4 * data.length;
        int bytewritten = this.lDevice.write(h, 0, 11);
        if (bytewritten == 0) {
            return -1;
        }
        do {
            bytewritten = this.lDevice.write(array, currentpointer, translen);
            currentpointer += bytewritten;
            ++wbtot;
        } while ((translen -= bytewritten) > 0);
        return data.length;
    }

    private int[] Read(int addr, int length, boolean autoinc) throws IOException {
        byte[] h = new byte[200];
        boolean currentpointer = false;
        this.lDevice.purge(2);
        int ll = length - 1;
        int aa = addr;
        int autoinc_flag = 0;
        autoinc_flag = autoinc ? 0 : 2;
        h[0] = -1;
        h[1] = 0;
        h[2] = -85;
        h[3] = (byte)(241 + autoinc_flag);
        h[4] = (byte)(aa >> 24 & 0xFF);
        h[5] = (byte)(aa >> 16 & 0xFF);
        h[6] = (byte)(aa >> 8 & 0xFF);
        h[7] = (byte)(aa >> 0 & 0xFF);
        h[8] = (byte)(ll >> 16 & 0xFF);
        h[9] = (byte)(ll >> 8 & 0xFF);
        h[10] = (byte)(ll >> 0 & 0xFF);
        boolean wbtot = false;
        int translen = 4 * length;
        int bytewritten = this.lDevice.write(h, 0, 11);
        if (bytewritten == 0) {
            throw new IOException();
        }
        byte[] data = this.lDevice.read(translen);
        IntBuffer intBuf = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int[] array = new int[intBuf.remaining()];
        intBuf.get(array);
        return array;
    }

    public V2495(int LinkNum, ControllerType type) {
        this.lDevice = new jd2xx();
        this.lCType = type;
        this.lLink = LinkNum;
        this.lHandle = -1;
        if (type == ControllerType.MAINCONTROLLER) {
            this.bitstream_length = 2709139;
        } else if (type == ControllerType.USERCONTROLLER) {
            this.bitstream_length = 4321299;
        }
        this.controller_base_address = type.getOffset();
        this.bitstream = new Byte[this.bitstream_length];
    }

    public V2495(int LinkType, int LinkNum, int ConetNode, int VMEBaseAddress, ControllerType Ctype) throws IOException {
        this.lLink = LinkNum;
        this.lType = LinkType;
        this.lConet = ConetNode;
        this.lBA = VMEBaseAddress;
        this.lDevice = null;
        this.lCType = Ctype;
        if (this.lCType == ControllerType.MAINCONTROLLER) {
            this.bitstream_length = 2709139;
        } else if (this.lCType == ControllerType.USERCONTROLLER) {
            this.bitstream_length = 4321299;
        }
        this.controller_base_address = this.lCType.getOffset();
        this.bitstream = new Byte[this.bitstream_length];
    }

    public void Open() throws IOException {
        int idcode;
        if (this.lDevice != null) {
            int n = this.lDevice.createDeviceInfoList();
            if (n < this.lLink + 1) {
                throw new IOException("Invalid link number (n=" + String.valueOf(n) + ")");
            }
            String pl = System.getProperty("sun.arch.data.model");
            this.lDevice.open(this.lLink);
            this.lDevice.resetDevice();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.lDevice.setBitMode(255, 64);
            this.lDevice.setFlowControl(256, (byte)0, (byte)0);
            this.lDevice.setTimeouts(1000, 1000);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.lDevice.purge(1);
            this.lDevice.purge(2);
            this.Write32(0xFFFFFF, 1);
            this.Write32(0xFFFFFF, 1);
            this.Write32(0xFFFFFF, 1);
            this.Write32(33312, 61898);
            int valore = this.Read32(33312);
            this.Write32(33312, 0);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            IntBuffer pInt = IntBuffer.allocate(1);
            int err = NativeComm.CAENComm_OpenDevice(this.lType, this.lLink, this.lConet, this.lBA, pInt);
            if (err != 0) {
                throw new IOException("Cannot Open the Device (comm_err=" + String.valueOf(err) + ")");
            }
            this.lHandle = pInt.get(0);
        }
        if ((idcode = this.Read32(this.controller_base_address + 240)) != -890297195) {
            this._flash_controller_present = false;
            this.lDevice.close();
            throw new IOException("Device not found");
        }
        this._flash_controller_present = true;
        this.Write32(this.controller_base_address + 20, -1413851887);
    }

    public void Close() throws IOException {
        if (this.lDevice != null) {
            this.lDevice.close();
        } else {
            NativeComm.CAENComm_CloseDevice(this.lHandle);
        }
    }

    public void EnableFlashAccess() throws IOException {
        if (this.lHandle != -1) {
            NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 24, 0);
            NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 28, 1);
        } else {
            this.Write32(this.controller_base_address + 24, 0);
            this.Write32(this.controller_base_address + 28, 1);
        }
    }

    public void DisableFlashAccess() throws IOException {
        if (this.lHandle != -1) {
            NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 28, 0);
            NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 24, 1);
        } else {
            this.Write32(this.controller_base_address + 28, 0);
            this.Write32(this.controller_base_address + 24, 1);
        }
    }

    private byte rev_byte(byte v) {
        byte t = v;
        for (int i = 7; i > 0; --i) {
            t = (byte)(t << 1);
            v = (byte)(v >> 1);
            t = (byte)(t | v & 1);
        }
        return t;
    }

    private int wait_controller() throws IOException {
        int data;
        IntBuffer pInt = IntBuffer.allocate(1);
        do {
            if (this.lHandle != -1) {
                int err = NativeComm.CAENComm_Read32(this.lHandle, this.controller_base_address + 0, pInt);
                if (err != 0) {
                    return 0;
                }
                data = pInt.get(0);
                continue;
            }
            data = this.Read32(this.controller_base_address + 0);
        } while ((data & 0xFE) != 0);
        return 0;
    }

    private int wait_flash() throws IOException {
        int data;
        IntBuffer pInt = IntBuffer.allocate(1);
        do {
            this.wait_controller();
            if (this.lHandle != -1) {
                NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 0, 2);
                int err = NativeComm.CAENComm_Read32(this.lHandle, this.controller_base_address + 0, pInt);
                if (err != 0) {
                    throw new IOException();
                }
                data = pInt.get(0);
                continue;
            }
            this.Write32(this.controller_base_address + 0, 2);
            data = this.Read32(this.controller_base_address + 0);
        } while ((data >> 8 & 1) != 0);
        return 0;
    }

    public int PageWrite(int start_address, byte[] buf) throws IOException {
        Memory addrs = new Memory(256L);
        Memory errors = new Memory(256L);
        Memory datas = new Memory(256L);
        if (!this._flash_controller_present) {
            return -1;
        }
        if (this.lHandle != -1) {
            NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 4, start_address);
            NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 8, 255);
        } else {
            this.Write32(this.controller_base_address + 4, start_address);
            this.Write32(this.controller_base_address + 8, 255);
        }
        for (int i = 0; i < 64; ++i) {
            int MemoryOffset = i * 4;
            long lvalue = 0L;
            for (int j = 0; j < 4; ++j) {
                long tmp = buf[i * 4 + j] & 0xFF;
                lvalue |= tmp << 8 * j;
            }
            int value = (int)(lvalue & 0xFFFFFFFFL);
            addrs.setInt((long)MemoryOffset, this.controller_base_address + 256 + 4 * i);
            datas.setInt((long)MemoryOffset, value);
        }
        if (this.lHandle != -1) {
            NativeComm.CAENComm_MultiWrite32(this.lHandle, (Pointer)addrs, 64, (Pointer)datas, (Pointer)errors);
            NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 0, 1);
            NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 0, 4);
        } else {
            IntBuffer intBuf = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
            int[] array = new int[intBuf.remaining()];
            intBuf.get(array);
            this.Write(array, this.controller_base_address + 256, true);
            this.Write32(this.controller_base_address + 0, 1);
            this.Write32(this.controller_base_address + 0, 4);
        }
        this.wait_flash();
        return 0;
    }

    public byte[] PageRead(int start_address) throws Exception {
        Memory addrs = new Memory(256L);
        Memory errors = new Memory(256L);
        Memory datas = new Memory(256L);
        byte[] buf = new byte[256];
        IntBuffer pInt = IntBuffer.allocate(1);
        if (!this._flash_controller_present) {
            throw new Exception("CONTROLLER_NOT_PRESENT");
        }
        if (this.lHandle != -1) {
            NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 4, start_address);
            NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 8, 255);
            NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 0, 5);
        } else {
            this.Write32(this.controller_base_address + 4, start_address);
            this.Write32(this.controller_base_address + 8, 255);
            this.Write32(this.controller_base_address + 0, 5);
        }
        this.wait_controller();
        for (int i = 0; i < 64; ++i) {
            int MemoryOffset = i * 4;
            addrs.setInt((long)MemoryOffset, this.controller_base_address + 256 + 4 * i);
        }
        if (this.lHandle != -1) {
            NativeComm.CAENComm_Read32(this.lHandle, this.controller_base_address + 256, pInt);
            int dataV = pInt.get(0);
            NativeComm.CAENComm_MultiRead32(this.lHandle, (Pointer)addrs, 64, (Pointer)datas, (Pointer)errors);
            byte[] data = datas.getByteArray(0L, 256);
            System.arraycopy(data, 0, buf, 0, 256);
        } else {
            int[] v = this.Read(this.controller_base_address + 256, 64, true);
            ByteBuffer byteBuffer = ByteBuffer.allocate(v.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer.put(v);
            buf = byteBuffer.array();
        }
        return buf;
    }

    public int EraseSector(int start_address) throws IOException {
        if (!this._flash_controller_present) {
            return -1;
        }
        if (this.lHandle != -1) {
            NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 4, start_address);
            NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 0, 1);
            NativeComm.CAENComm_Write32(this.lHandle, this.controller_base_address + 0, 3);
        } else {
            this.Write32(this.controller_base_address + 4, start_address);
            this.Write32(this.controller_base_address + 0, 1);
            this.Write32(this.controller_base_address + 0, 3);
        }
        this.wait_flash();
        return 0;
    }

    public boolean ProgramFirmware(FwRegion region, String filename, boolean verify, boolean no_bit_reverse, boolean skip_erase) throws IOException, Exception {
        int sectors_to_write = 0;
        byte[] buf = new byte[256];
        int start_address = 0;
        Path path = Paths.get(filename, new String[0]);
        byte[] data = Files.readAllBytes(path);
        block0 : switch (this.lCType) {
            case MAINCONTROLLER: {
                sectors_to_write = 42;
                switch (region) {
                    case BOOT: {
                        start_address = 0;
                        break block0;
                    }
                    case APP1: {
                        start_address = 0x400000;
                        break block0;
                    }
                }
                throw new IOException();
            }
            case USERCONTROLLER: {
                sectors_to_write = 66;
                switch (region) {
                    case BOOT: {
                        start_address = 0;
                        break block0;
                    }
                    case APP1: {
                        start_address = 0x800000;
                        break block0;
                    }
                    case APP2: {
                        start_address = 0xC20000;
                        break block0;
                    }
                    case APP3: {
                        start_address = 0x1040000;
                        break block0;
                    }
                    case APP4: {
                        start_address = 21364736;
                        break block0;
                    }
                    case APP5: {
                        start_address = 0x1880000;
                        break block0;
                    }
                }
                break;
            }
        }
        if (!skip_erase) {
            for (int i = 0; i < sectors_to_write; ++i) {
                this.EraseSector(start_address + i * 65536);
            }
        }
        for (int sector = sectors_to_write - 1; sector >= 0; --sector) {
            for (int page = 255; page >= 0; --page) {
                int remain;
                int offset = sector * 65536 + page * 256;
                int n = remain = this.bitstream_length - offset > 0 ? this.bitstream_length - offset : 0;
                if (remain == 0) continue;
                int bytes_to_write = remain < 256 ? remain : 256;
                System.arraycopy(data, offset, buf, 0, bytes_to_write);
                if (!no_bit_reverse) {
                    for (int k = 0; k < bytes_to_write; ++k) {
                        buf[k] = this.rev_byte(buf[k]);
                    }
                }
                this.PageWrite(start_address + offset, buf);
                if (!verify) continue;
                byte[] buf_ver = this.PageRead(start_address + offset);
                for (int ii = 0; ii < bytes_to_write; ++ii) {
                    if (buf_ver[ii] == buf[ii]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean VerifyFirmware(FwRegion region, String filename, boolean no_bit_reverse) throws IOException, Exception {
        byte[] buf = new byte[256];
        int start_address = 0;
        int sectors_to_read = 0;
        Path path = Paths.get(filename, new String[0]);
        byte[] data = Files.readAllBytes(path);
        block0 : switch (this.lCType) {
            case MAINCONTROLLER: {
                sectors_to_read = 42;
                switch (region) {
                    case BOOT: {
                        start_address = 0;
                        break block0;
                    }
                    case APP1: {
                        start_address = 0x400000;
                        break block0;
                    }
                }
                throw new IOException();
            }
            case USERCONTROLLER: {
                sectors_to_read = 66;
                switch (region) {
                    case BOOT: {
                        start_address = 0;
                        break block0;
                    }
                    case APP1: {
                        start_address = 0x800000;
                        break block0;
                    }
                    case APP2: {
                        start_address = 0xC20000;
                        break block0;
                    }
                    case APP3: {
                        start_address = 0x1040000;
                        break block0;
                    }
                    case APP4: {
                        start_address = 21364736;
                        break block0;
                    }
                    case APP5: {
                        start_address = 0x1880000;
                        break block0;
                    }
                }
                break;
            }
        }
        for (int sector = 0; sector < sectors_to_read; ++sector) {
            for (int page = 0; page < 256; ++page) {
                int remain;
                int offset = sector * 65536 + page * 256;
                int n = remain = this.bitstream_length - offset > 0 ? this.bitstream_length - offset : 0;
                if (remain == 0) continue;
                int bytes_to_read = remain < 256 ? remain : 256;
                System.arraycopy(data, offset, buf, 0, bytes_to_read);
                if (!no_bit_reverse) {
                    for (int k = 0; k < bytes_to_read; ++k) {
                        buf[k] = this.rev_byte(buf[k]);
                    }
                }
                byte[] buf_ver = this.PageRead(start_address + offset);
                for (int ii = 0; ii < bytes_to_read; ++ii) {
                    if (buf_ver[ii] == buf[ii]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean EraseFirmware(FwRegion region) throws IOException {
        int sectors_to_erase = 0;
        int start_address = 0;
        block0 : switch (this.lCType) {
            case MAINCONTROLLER: {
                sectors_to_erase = 42;
                switch (region) {
                    case BOOT: {
                        start_address = 0;
                        break block0;
                    }
                    case APP1: {
                        start_address = 0x400000;
                        break block0;
                    }
                }
                throw new IOException();
            }
            case USERCONTROLLER: {
                sectors_to_erase = 66;
                switch (region) {
                    case BOOT: {
                        start_address = 0;
                        break block0;
                    }
                    case APP1: {
                        start_address = 0x800000;
                        break block0;
                    }
                    case APP2: {
                        start_address = 0xC20000;
                        break block0;
                    }
                    case APP3: {
                        start_address = 0x1040000;
                        break block0;
                    }
                    case APP4: {
                        start_address = 21364736;
                        break block0;
                    }
                    case APP5: {
                        start_address = 0x1880000;
                        break block0;
                    }
                }
                break;
            }
        }
        for (int i = 0; i < sectors_to_erase; ++i) {
            this.EraseSector(start_address + i * 65536);
        }
        return true;
    }

    public int Read32(int address) throws IOException {
        if (this.lHandle == -1) {
            int[] v = this.Read(address, 1, false);
            return v[0];
        }
        IntBuffer pInt = IntBuffer.allocate(1);
        NativeComm.CAENComm_Read32(this.lHandle, address, pInt);
        return pInt.get(0);
    }

    public void Write32(int address, int data) throws IOException {
        if (this.lHandle == -1) {
            int[] d = new int[]{data};
            int v = this.Write(d, address, false);
            if (v != 1) {
                throw new IOException("Write failed");
            }
        } else {
            NativeComm.CAENComm_Write32(this.lHandle, address, data);
        }
    }

    static {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            String archDataModel = System.getProperty("sun.arch.data.model");
            if (archDataModel.contains("64")) {
                System.setProperty("jna.library.path", "./x64/");
            } else {
                System.setProperty("jna.library.path", "./x86/");
            }
        }
    }

    public static enum FwRegion {
        BOOT(0),
        APP1(1),
        APP2(2),
        APP3(3),
        APP4(4),
        APP5(5);

        private final int index;

        private FwRegion(int idx) {
            this.index = idx;
        }

        public int getOffset() {
            return this.index;
        }
    }

    public static enum ControllerType {
        MAINCONTROLLER(34048),
        USERCONTROLLER(34560);

        private final int offset;

        private ControllerType(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    private class jd2xx {
        private long lHandle;
        public static final int PURGE_RX = 1;
        public static final int PURGE_TX = 2;
        public static final int BITMODE_RESET = 0;
        public static final int BITMODE_ASYNC_BITBANG = 1;
        public static final int BITMODE_MPSSE = 2;
        public static final int BITMODE_SYNC_BITBANG = 4;
        public static final int BITMODE_MCU_HOST = 8;
        public static final int BITMODE_FAST_SERIAL = 16;
        public static final int BITMODE_CBUS_BITBANG = 32;
        public static final int BITMODE_SYNC_FIFO = 64;
        public static final int FLOW_NONE = 0;
        public static final int FLOW_RTS_CTS = 256;
        public static final int FLOW_DTR_DSR = 512;
        public static final int FLOW_XON_XOFF = 1024;

        private String getErrorCode(long error) {
            switch ((int)error) {
                case 0: {
                    return "OK";
                }
                case 1: {
                    return "INVALID_HANDLE";
                }
                case 2: {
                    return "DEVICE_NOT_FOUND";
                }
                case 3: {
                    return "DEVICE_NOT_OPENED";
                }
                case 4: {
                    return "IO_ERROR";
                }
                case 5: {
                    return "INSUFFICIENT_RESOURCES";
                }
                case 6: {
                    return "INVALID_PARAMETER";
                }
                case 7: {
                    return "INVALID_BAUD_RATE";
                }
                case 8: {
                    return "DEVICE_NOT_OPENED_FOR_ERASE";
                }
                case 9: {
                    return "DEVICE_NOT_OPENED_FOR_WRITE";
                }
                case 10: {
                    return "FAILED_TO_WRITE_DEVICE";
                }
                case 11: {
                    return "EEPROM_READ_FAILED";
                }
                case 12: {
                    return "EEPROM_WRITE_FAILED";
                }
                case 13: {
                    return "EEPROM_ERASE_FAILED";
                }
                case 14: {
                    return "EEPROM_NOT_PRESENT";
                }
                case 15: {
                    return "EEPROM_NOT_PROGRAMMED";
                }
                case 16: {
                    return "INVALID_ARGS";
                }
                case 17: {
                    return "NOT_SUPPORTED";
                }
                case 18: {
                    return "OTHER_ERROR";
                }
                case 19: {
                    return "DEVICE_LIST_NOT_READY";
                }
            }
            return "OTHER_ERROR";
        }

        public int createDeviceInfoList() throws IOException {
            LongBuffer pLong = LongBuffer.allocate(1);
            long status = FTD2XX_Native.FT_SetVIDPID(8673, 10);
            if ((status & 0xFFFFFFFFL) != 0L) {
                throw new IOException(this.getErrorCode(status));
            }
            status = FTD2XX_Native.FT_CreateDeviceInfoList(pLong);
            if ((status & 0xFFFFFFFFL) != 0L) {
                throw new IOException(this.getErrorCode(status));
            }
            return (int)pLong.get(0);
        }

        public void open(int deviceNumber) throws IOException {
            LongBuffer pHandle = LongBuffer.allocate(1);
            long status = FTD2XX_Native.FT_Open(deviceNumber, pHandle);
            if ((status & 0xFFFFFFFFL) != 0L) {
                throw new IOException(this.getErrorCode(status));
            }
            this.lHandle = pHandle.get(0);
        }

        public void close() throws IOException {
            long status;
            if (this.lHandle != -1L && ((status = FTD2XX_Native.FT_Close(this.lHandle)) & 0xFFFFFFFFL) != 0L) {
                throw new IOException(this.getErrorCode(status));
            }
        }

        public byte[] read(int length) throws IOException {
            IntBuffer rsize = IntBuffer.allocate(1);
            ByteBuffer bb = ByteBuffer.allocate(length);
            IntBuffer buffer = IntBuffer.allocate(length / 4);
            long status = FTD2XX_Native.FT_Read(this.lHandle, bb, length, rsize);
            if ((status & 0xFFFFFFFFL) != 0L) {
                throw new IOException(this.getErrorCode(status));
            }
            int dataRead = rsize.get(0);
            if (dataRead != length) {
                throw new IOException(this.getErrorCode(4L));
            }
            return bb.array();
        }

        public int write(byte[] bytes, int offset, int length) throws IOException {
            IntBuffer wsize = IntBuffer.allocate(1);
            long status = FTD2XX_Native.FT_Write(this.lHandle, bytes, length, wsize);
            if ((status & 0xFFFFFFFFL) != 0L) {
                throw new IOException(this.getErrorCode(status));
            }
            return wsize.get(0);
        }

        public void setFlowControl(int flowControl, byte XOn, byte XOff) throws IOException {
            long status = FTD2XX_Native.FT_SetFlowControl(this.lHandle, (short)flowControl, XOn, XOff);
            if ((status & 0xFFFFFFFFL) != 0L) {
                throw new IOException(this.getErrorCode(status));
            }
        }

        public void resetDevice() throws IOException {
            long status = FTD2XX_Native.FT_ResetDevice(this.lHandle);
            if ((status & 0xFFFFFFFFL) != 0L) {
                throw new IOException(this.getErrorCode(status));
            }
        }

        public void setBitMode(int mask, int mode) throws IOException {
            long status = FTD2XX_Native.FT_SetBitMode(this.lHandle, (byte)mask, (byte)mode);
            if ((status & 0xFFFFFFFFL) != 0L) {
                throw new IOException(this.getErrorCode(status));
            }
        }

        public void setTimeouts(int readTimeout, int writeTimeout) throws IOException {
            long status = FTD2XX_Native.FT_SetTimeouts(this.lHandle, readTimeout, writeTimeout);
            if ((status & 0xFFFFFFFFL) != 0L) {
                throw new IOException(this.getErrorCode(status));
            }
        }

        public void purge(int mask) throws IOException {
            long status = FTD2XX_Native.FT_Purge(this.lHandle, (byte)mask);
            if ((status & 0xFFFFFFFFL) != 0L) {
                throw new IOException(this.getErrorCode(status));
            }
        }
    }
}

