/******************************************************************************
* 
* CAEN SpA - Front End Division
* Via Vetraia, 11 - 55049 - Viareggio ITALY
* +390594388398 - www.caen.it
*
******************************************************************************/

#ifndef _DPP_QDC_H
#define _DPP_QDC_H

/* System library includes */
#include <stdio.h>
#include <time.h>
#include <sys/timeb.h>


#ifdef _WIN32
#include <process.h>
#else
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#endif

#include <errno.h>
#include <limits.h>

#include <CAENDigitizer.h>

/* Macro definition */ 
#ifndef LINUX
  #define popen  _popen    /* redefine POSIX 'deprecated' popen as _popen */
  #define pclose _pclose   /* redefine POSIX 'deprecated' pclose as _pclose */
#endif

#define MAX_CHANNELS 64
#define MAX_GROUPS 8

#define CAEN_USE_DIGITIZERS
#define IGNORE_DPP_DEPRECATED

#define CONNECTION_TYPE_USB    0
#define CONNECTION_TYPE_OPT    1
#define CONNECTION_TYPE_AUTO   255

#define HISTO_NBIN    8192

#define MAX_AGGR_NUM_PER_BLOCK_TRANSFER   1023 /* MAX 1023 */ 


#define ENABLE_TEST_PULSE 1
#ifdef _WIN32

#define WORKING_DIR "\\CAENDPP-QDC_Demo\\"
#define CONFIG_FILE_NAME "config.txt"
#define PLOT_FILE "PlotData.txt"
#define PLOT_WAVE "PlotWave.txt"

#else

#define MAX_PATH          260
#define WORKING_DIR "/CAENDPP-QDC_Demo"
#define CONFIG_FILE_NAME "/etc/CAENDPP-QDC_Demo/config.txt"
#define PLOT_FILE "/PlotData.txt"
#define PLOT_WAVE "/PlotWave.txt"

#endif

#define REFRESH_RATE 1000 /* ms */


/* Charge cuts */
#define CHARGE_LLD_CUT 0
#define CHARGE_ULD_CUT (HISTO_NBIN-1)

/* Data structures */

typedef struct 
{
    uint32_t ConnectionType;
    uint32_t ConnectionLinkNum;
    uint32_t ConnectionConetNode;
    uint32_t ConnectionVMEBaseAddress;
	uint32_t RecordLength;   
	uint32_t PreTrigger;     
	uint32_t ActiveChannel;
	uint32_t PreGate;
	uint32_t ChargeSensitivity;
	uint32_t FixedBaseline;
	uint32_t BaselineMode;
    uint32_t TrgMode;
    uint32_t TrgSmoothing;
    uint32_t TrgHoldOff;
    uint32_t TriggerThreshold[64];
	uint32_t DCoffset[8];	
	uint32_t NevAggr;
    uint32_t PulsePol;
    uint32_t EnChargePed;
    uint32_t SaveList;
    uint32_t SaveCSVFile;
    uint32_t DisTrigHist;
    uint32_t DisSelfTrigger;
    uint32_t EnTestPulses;
    uint32_t TestPulsesRate;
    uint32_t DefaultTriggerThr;
	uint64_t ChannelTriggerMask;
	CAEN_DGTZ_DPP_AcqMode_t AcqMode;
	CAEN_DGTZ_DPP_QDC_Params_t DPPParams;
} BoardParameters;

/* Data structures */

/* Globals */
extern int	        gHandle;                                   /* CAEN library handle */
                                                               
/* Variable declarations */                                    
extern unsigned int gActiveChannel;                            /* Active channel for data analysis */
extern unsigned int gEquippedChannels;                         /* Number of equipped channels      */
extern unsigned int gEquippedGroups;                           /* Number of equipped groups        */
                                                               
                                                               
extern uint32_t**   gHisto;                                    /* Histograms                       */
                                                               
extern uint64_t     gExtendedTimeTag[MAX_CHANNELS];            /* Extended Time Tag                */
extern uint64_t     gETT[MAX_CHANNELS];                        /* Extended Time Tag                */
extern uint64_t     gCurrTimeTag[MAX_CHANNELS];                /* Current Time Tag                */
extern uint64_t     gPrevTimeTag[MAX_CHANNELS];                /* Previous Time Tag                */
                                                               
extern BoardParameters   gParams;                              /* Board parameters structure       */
extern CAEN_DGTZ_DPP_QDC_Params_t *DPPParams;				   /*Board DP-QDC parameters			*/
   
extern char home_directory[MAX_PATH];						/* User home directory path           */
extern char *w_dir;
extern char *config_file;									/* To store path to config file in user directory */
extern char *plotdata_file;									/* To store path to PlotData.txt file in user directory */
extern char *plotwave_file;									/* To store path to PlotWave.txt file in user directory */

extern FILE *       gListFiles[MAX_CHANNELS];                  /* Output file for list data        */
                                                               
extern CAEN_DGTZ_BoardInfo_t             gBoardInfo;           /* Board Informations               */ 
extern CAEN_DGTZ_DPP_QDC_Event_t*     gEvent[MAX_CHANNELS]; /* Events                           */

extern CAEN_DGTZ_DPP_QDC_Waveforms_t* gWaveforms;           /* Waveforms                        */

/* Variable definitions */
extern int          gSWTrigger;                                /* Signal for software trigger          */
extern int			running;                                   /* Readout is running			       */	
extern int		    gAcqrun;								   /* Acquisition is on			       */
extern int          grp4stats;                                 /* Selected group for statistics        */
extern int          gLoops;                                    /* Number of acquisition loops          */
extern int          gToggleTrace;                              /* Signal for trace toggle from user    */
extern int          gSaveCSVFile;                              /* Save CSV file                        */
extern int          gAnalogTrace;                              /* Signal for analog trace toggle       */
extern int          gRestart    ;                              /* Signal acquisition restart from user */
extern int          gStopped;                              /* Signal acquisition stopped from user */
extern char *       gAcqBuffer;                                /* Acquisition buffer                   */
extern char *       gEventPtr;                                 /* Events buffer pointer                */
extern FILE *       gHistPlotFile;                             /* Source file for histogram plot       */
extern FILE *       gWavePlotFile;                             /* Source file for waveform plot        */
extern int          gAcquisitionBufferAllocated;               /* Buffers are allocated  			  */

/* Runtime statistics */
extern unsigned int gBytesRead;                                /* Number of bytes read                   */
extern uint64_t     gTotEvCnt;                                 /* Total number of events                 */
extern uint64_t     gPrevTotEvCnt;                             /* Previous Total number of events        */
extern uint64_t     gChEvCnt[MAX_CHANNELS];                    /* Channel event counter                  */
extern uint64_t     gPrevChEvCnt[MAX_CHANNELS];                /* Previous Channel event counter         */

extern long         gCurrTime;                                 /* Current time                     */
extern long         gPrevTime;                                 /* Previous saved time              */
extern long         gPrevWPlotTime;                            /* Previous time of Waveform plot   */
extern long         gPrevHPlotTime;                            /* Previous time of Histogram plot  */
extern long         gPrevKeyTime;                              /* Previous keyboard check time     */
extern long         gRunStartTime;                             /* Time of run start                */
extern long         gRunElapsedTime;                           /* Elapsed time since start         */
extern long         gUpdateElapsedTime;                        /* Elapsed time since last update   */
extern char* gRunID;                                    /* Run Identifier                   */

/* *************************************************************************************************
** Function prototypes 
****************************************************************************************************/

/* readout_demo functions prototypes */
int  setup_acquisition();
int  cleanup_on_exit(FILE *csvFile);
int  ResetStatistics();

void PrintMenu();//print menu on screen


/* Board parameters utility functions */
void set_default_parameters(BoardParameters *params);
int  load_configuration_from_file(char * fname, BoardParameters *params);
int  setup_parameters(BoardParameters *params, char *fname);
int  configure_digitizer(int handle, int gEquippedGroups, BoardParameters *params);

/* Utility functions prototypes */
long get_time();
void clear_screen( void );

#ifdef LINUX
    #include <sys/time.h> /* struct timeval, select() */
    #include <termios.h> /* tcgetattr(), tcsetattr() */
    #include <stdlib.h> /* atexit(), exit() */
    #include <unistd.h> /* read() */
    #include <stdio.h> /* printf() */
    #include <string.h> /* memcpy() */
	#include <stdint.h> /* memcpy() */
	
	#define CLEARSCR "clear"

/*****************************************************************************/
/*  SLEEP  */
/*****************************************************************************/
void Sleep(int t);

/*****************************************************************************/
/*  GETCH  */
/*****************************************************************************/
int getch(void);

/*****************************************************************************/
/*  KBHIT  */
/*****************************************************************************/
int kbhit();


#else  /* Windows */

    #include <conio.h>
	#define getch _getch
	#define kbhit _kbhit
	
	#define CLEARSCR "cls"
#endif
#endif
